/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.ArrowKeyMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditStyledText
extends EditText {
    public static final String LOG_TAG = "EditStyledText";
    public static final boolean DBG = false;
    public static final int MODE_NOTHING = 0;
    public static final int MODE_COPY = 1;
    public static final int MODE_PASTE = 2;
    public static final int MODE_SIZE = 3;
    public static final int MODE_COLOR = 4;
    public static final int MODE_SELECT = 5;
    public static final int MODE_ALIGN = 6;
    public static final int MODE_CUT = 7;
    public static final int STATE_SELECT_OFF = 0;
    public static final int STATE_SELECT_ON = 1;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_SELECT_FIX = 3;
    public static final int HINT_MSG_NULL = 0;
    public static final int HINT_MSG_COPY_BUF_BLANK = 1;
    public static final int HINT_MSG_SELECT_START = 2;
    public static final int HINT_MSG_SELECT_END = 3;
    public static final int HINT_MSG_PUSH_COMPETE = 4;
    public static final int DEFAULT_BACKGROUND_COLOR = 0xFFFFFF;
    public EditStyledTextNotifier mESTInterface;
    public EditorManager mManager;
    public StyledTextConverter mConverter;
    public StyledTextDialog mDialog;
    public Drawable mDefaultBackground;
    public int mBackgroundColor;

    public EditStyledText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public EditStyledText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EditStyledText(Context context) {
        super(context);
        this.init();
    }

    public void setNotifier(EditStyledTextNotifier estInterface) {
        this.mESTInterface = estInterface;
    }

    public void setBuilder(AlertDialog.Builder builder) {
        this.mDialog.setBuilder(builder);
    }

    public void setColorAlertParams(CharSequence colortitle, CharSequence[] colornames, CharSequence[] colorints) {
        this.mDialog.setColorAlertParams(colortitle, colornames, colorints);
    }

    public void setSizeAlertParams(CharSequence sizetitle, CharSequence[] sizenames, CharSequence[] sizedisplayints, CharSequence[] sizesendints) {
        this.mDialog.setSizeAlertParams(sizetitle, sizenames, sizedisplayints, sizesendints);
    }

    public void setAlignAlertParams(CharSequence aligntitle, CharSequence[] alignnames) {
        this.mDialog.setAlignAlertParams(aligntitle, alignnames);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mManager.isSoftKeyBlocked() && event.getAction() == 1) {
            this.cancelLongPress();
        }
        boolean superResult = super.onTouchEvent(event);
        if (event.getAction() == 1) {
            this.mManager.onCursorMoved();
        }
        return superResult;
    }

    public void onStartEdit() {
        this.mManager.onStartEdit();
    }

    public void onEndEdit() {
        this.mManager.onEndEdit();
    }

    public void onStartCopy() {
        this.mManager.onStartCopy();
    }

    public void onStartCut() {
        this.mManager.onStartCut();
    }

    public void onStartPaste() {
        this.mManager.onStartPaste();
    }

    public void onStartSize() {
        this.mManager.onStartSize();
    }

    public void onStartColor() {
        this.mManager.onStartColor();
    }

    public void onStartBackgroundColor() {
        this.mManager.onStartBackgroundColor();
    }

    public void onStartAlign() {
        this.mManager.onStartAlign();
    }

    public void onStartSelect() {
        this.mManager.onStartSelect();
    }

    public void onStartSelectAll() {
        this.mManager.onStartSelectAll();
    }

    public void onFixSelectedItem() {
        this.mManager.onFixSelectedItem();
    }

    public void onInsertImage(Uri uri) {
        this.mManager.onInsertImage(uri);
    }

    public void onInsertImage(int resId) {
        this.mManager.onInsertImage(resId);
    }

    public void onInsertHorizontalLine() {
        this.mManager.onInsertHorizontalLine();
    }

    public void onClearStyles() {
        this.mManager.onClearStyles();
    }

    public void setItemSize(int size) {
        this.mManager.setItemSize(size);
    }

    public void setItemColor(int color2) {
        this.mManager.setItemColor(color2);
    }

    public void setAlignment(Layout.Alignment align) {
        this.mManager.setAlignment(align);
    }

    @Override
    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        this.mBackgroundColor = color2;
    }

    public void setHtml(String html) {
        this.mConverter.SetHtml(html);
    }

    public boolean isEditting() {
        return this.mManager.isEditting();
    }

    public boolean isStyledText() {
        return this.mManager.isStyledText();
    }

    public boolean isSoftKeyBlocked() {
        return this.mManager.isSoftKeyBlocked();
    }

    public int getEditMode() {
        return this.mManager.getEditMode();
    }

    public int getSelectState() {
        return this.mManager.getSelectState();
    }

    @Override
    public Bundle getInputExtras(boolean create) {
        Bundle bundle = super.getInputExtras(create);
        if (bundle != null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("allowEmoji", true);
        return bundle;
    }

    public String getHtml() {
        return this.mConverter.getHtml();
    }

    public String getHtml(ArrayList<Uri> uris) {
        this.mConverter.getUriArray(uris, this.getText());
        return this.mConverter.getHtml();
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getForeGroundColor(int pos) {
        if (pos < 0 || pos > this.getText().length()) {
            Log.e(LOG_TAG, "---getForeGroundColor: Illigal position.");
            return 0xFFFFFF;
        }
        ForegroundColorSpan[] spans = this.getText().getSpans(pos, pos, ForegroundColorSpan.class);
        if (spans.length > 0) {
            return spans[0].getForegroundColor();
        }
        return 0xFFFFFF;
    }

    public void init() {
        this.requestFocus();
        this.mDefaultBackground = this.getBackground();
        this.mBackgroundColor = 0xFFFFFF;
        this.mManager = new EditorManager(this);
        this.mConverter = new StyledTextConverter(this);
        this.mDialog = new StyledTextDialog(this);
        this.setMovementMethod(new StyledTextArrowKeyMethod(this.mManager));
        this.mManager.blockSoftKey();
        this.mManager.unblockSoftKey();
    }

    public void onShowForegroundColorAlert() {
        this.mDialog.onShowForegroundColorAlertDialog();
    }

    public void onShowBackgroundColorAlert() {
        this.mDialog.onShowBackgroundColorAlertDialog();
    }

    public void onShowSizeAlert() {
        this.mDialog.onShowSizeAlertDialog();
    }

    public void onShowAlignAlert() {
        this.mDialog.onShowAlignAlertDialog();
    }

    public void setHintMessage(int msgId) {
        if (this.mESTInterface != null) {
            this.mESTInterface.notifyHintMsg(msgId);
        }
    }

    public void notifyStateChanged(int mode, int state) {
        if (this.mESTInterface != null) {
            this.mESTInterface.notifyStateChanged(mode, state);
        }
    }

    public class HorizontalLineDrawable
    extends ShapeDrawable {
        public View mView;

        public HorizontalLineDrawable(int color2, View view) {
            super(new RectShape());
            this.mView = view;
            this.renewColor(color2);
            this.renewBounds(view);
        }

        public void draw(Canvas canvas) {
            this.renewColor();
            this.renewBounds(this.mView);
            super.draw(canvas);
        }

        public void renewBounds(View view) {
            int width = this.mView.getWidth();
            if (width > 20) {
                width -= 20;
            }
            this.setBounds(0, 0, width, 2);
        }

        public void renewColor(int color2) {
            this.getPaint().setColor(color2);
        }

        public void renewColor() {
            if (this.mView instanceof View) {
                int start;
                ImageSpan parent = this.getParentSpan();
                Editable text = ((EditStyledText)this.mView).getText();
                ForegroundColorSpan[] spans = text.getSpans(start = text.getSpanStart(parent), start, ForegroundColorSpan.class);
                if (spans.length > 0) {
                    this.renewColor(spans[spans.length - 1].getForegroundColor());
                }
            }
        }

        public ImageSpan getParentSpan() {
            Editable text;
            ImageSpan[] images;
            if (this.mView instanceof EditStyledText && (images = (text = ((EditStyledText)this.mView).getText()).getSpans(0, text.length(), ImageSpan.class)).length > 0) {
                for (ImageSpan image : images) {
                    if (image.getDrawable() != this) continue;
                    return image;
                }
            }
            Log.e(EditStyledText.LOG_TAG, "---renewBounds: Couldn't find");
            return null;
        }
    }

    public class HorizontalLineSpan
    extends ImageSpan {
        public HorizontalLineSpan(int color2, View view) {
            super(new HorizontalLineDrawable(color2, view));
        }
    }

    public class StyledTextArrowKeyMethod
    extends ArrowKeyMovementMethod {
        public EditorManager mManager;

        public StyledTextArrowKeyMethod(EditorManager manager) {
            this.mManager = manager;
        }

        public boolean onKeyDown(TextView widget, Spannable buffer, int keyCode, KeyEvent event) {
            if (!this.mManager.isSoftKeyBlocked()) {
                return super.onKeyDown(widget, buffer, keyCode, event);
            }
            return this.executeDown(widget, buffer, keyCode);
        }

        public int getEndPos(TextView widget) {
            int end = widget.getSelectionStart() == this.mManager.getSelectionStart() ? widget.getSelectionEnd() : widget.getSelectionStart();
            return end;
        }

        public boolean up(TextView widget, Spannable buffer) {
            int end;
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForOffset(end = this.getEndPos(widget));
            if (line > 0) {
                int to;
                if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line - 1)) {
                    float h = layout2.getPrimaryHorizontal(end);
                    to = layout2.getOffsetForHorizontal(line - 1, h);
                } else {
                    to = layout2.getLineStart(line - 1);
                }
                this.mManager.setSelectedEndPos(to);
                this.mManager.onCursorMoved();
                return true;
            }
            return false;
        }

        public boolean down(TextView widget, Spannable buffer) {
            int end;
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForOffset(end = this.getEndPos(widget));
            if (line < layout2.getLineCount() - 1) {
                int to;
                if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + 1)) {
                    float h = layout2.getPrimaryHorizontal(end);
                    to = layout2.getOffsetForHorizontal(line + 1, h);
                } else {
                    to = layout2.getLineStart(line + 1);
                }
                this.mManager.setSelectedEndPos(to);
                this.mManager.onCursorMoved();
                return true;
            }
            return false;
        }

        public boolean left(TextView widget, Spannable buffer) {
            Layout layout2 = widget.getLayout();
            int to = layout2.getOffsetToLeftOf(this.getEndPos(widget));
            this.mManager.setSelectedEndPos(to);
            this.mManager.onCursorMoved();
            return true;
        }

        public boolean right(TextView widget, Spannable buffer) {
            Layout layout2 = widget.getLayout();
            int to = layout2.getOffsetToRightOf(this.getEndPos(widget));
            this.mManager.setSelectedEndPos(to);
            this.mManager.onCursorMoved();
            return true;
        }

        public boolean executeDown(TextView widget, Spannable buffer, int keyCode) {
            boolean handled = false;
            switch (keyCode) {
                case 19: {
                    handled |= this.up(widget, buffer);
                    break;
                }
                case 20: {
                    handled |= this.down(widget, buffer);
                    break;
                }
                case 21: {
                    handled |= this.left(widget, buffer);
                    break;
                }
                case 22: {
                    handled |= this.right(widget, buffer);
                    break;
                }
                case 23: {
                    this.mManager.onFixSelectedItem();
                    handled = true;
                }
            }
            return handled;
        }
    }

    public class StyledTextDialog {
        public AlertDialog.Builder mBuilder;
        public CharSequence mColorTitle;
        public CharSequence mSizeTitle;
        public CharSequence mAlignTitle;
        public CharSequence[] mColorNames;
        public CharSequence[] mColorInts;
        public CharSequence[] mSizeNames;
        public CharSequence[] mSizeDisplayInts;
        public CharSequence[] mSizeSendInts;
        public CharSequence[] mAlignNames;
        public EditStyledText mEST;

        public StyledTextDialog(EditStyledText est) {
            this.mEST = est;
        }

        public void setBuilder(AlertDialog.Builder builder) {
            this.mBuilder = builder;
        }

        public void setColorAlertParams(CharSequence colortitle, CharSequence[] colornames, CharSequence[] colorints) {
            this.mColorTitle = colortitle;
            this.mColorNames = colornames;
            this.mColorInts = colorints;
        }

        public void setSizeAlertParams(CharSequence sizetitle, CharSequence[] sizenames, CharSequence[] sizedisplayints, CharSequence[] sizesendints) {
            this.mSizeTitle = sizetitle;
            this.mSizeNames = sizenames;
            this.mSizeDisplayInts = sizedisplayints;
            this.mSizeSendInts = sizesendints;
        }

        public void setAlignAlertParams(CharSequence aligntitle, CharSequence[] alignnames) {
            this.mAlignTitle = aligntitle;
            this.mAlignNames = alignnames;
        }

        public boolean checkColorAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mColorTitle == null || this.mColorNames == null || this.mColorInts == null) {
                Log.e(EditStyledText.LOG_TAG, "--- color alert params are null.");
                return false;
            }
            if (this.mColorNames.length != this.mColorInts.length) {
                Log.e(EditStyledText.LOG_TAG, "--- the length of color alert params are different.");
                return false;
            }
            return true;
        }

        public boolean checkSizeAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mSizeTitle == null || this.mSizeNames == null || this.mSizeDisplayInts == null || this.mSizeSendInts == null) {
                Log.e(EditStyledText.LOG_TAG, "--- size alert params are null.");
                return false;
            }
            if (this.mSizeNames.length != this.mSizeDisplayInts.length && this.mSizeSendInts.length != this.mSizeDisplayInts.length) {
                Log.e(EditStyledText.LOG_TAG, "--- the length of size alert params are different.");
                return false;
            }
            return true;
        }

        public boolean checkAlignAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mAlignTitle == null) {
                Log.e(EditStyledText.LOG_TAG, "--- align alert params are null.");
                return false;
            }
            return true;
        }

        public void onShowForegroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mColorTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mColorNames, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Log.d("EETVM", "mBuilder.onclick:" + which);
                    int color2 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[which], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setItemColor(color2);
                }
            });
            this.mBuilder.show();
        }

        public void onShowBackgroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mColorTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mColorNames, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Log.d("EETVM", "mBuilder.onclick:" + which);
                    int color2 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[which], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setBackgroundColor(color2);
                }
            });
            this.mBuilder.show();
        }

        public void onShowSizeAlertDialog() {
            if (!this.checkSizeAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mSizeTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mSizeNames, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Log.d(EditStyledText.LOG_TAG, "mBuilder.onclick:" + which);
                    int size = Integer.parseInt((String)StyledTextDialog.this.mSizeDisplayInts[which]);
                    StyledTextDialog.this.mEST.setItemSize(size);
                }
            });
            this.mBuilder.show();
        }

        public void onShowAlignAlertDialog() {
            if (!this.checkAlignAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mAlignTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mAlignNames, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Log.d(EditStyledText.LOG_TAG, "mBuilder.onclick:" + which);
                    Layout.Alignment align = Layout.Alignment.ALIGN_NORMAL;
                    switch (which) {
                        case 0: {
                            align = Layout.Alignment.ALIGN_NORMAL;
                            break;
                        }
                        case 1: {
                            align = Layout.Alignment.ALIGN_CENTER;
                            break;
                        }
                        case 2: {
                            align = Layout.Alignment.ALIGN_OPPOSITE;
                            break;
                        }
                    }
                    StyledTextDialog.this.mEST.setAlignment(align);
                }
            });
            this.mBuilder.show();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StyledTextConverter {
        public EditStyledText mEST;

        public StyledTextConverter(EditStyledText est) {
            this.mEST = est;
        }

        public String getHtml() {
            String htmlBody = Html.toHtml(this.mEST.getText());
            return htmlBody;
        }

        public void getUriArray(ArrayList<Uri> uris, Editable text) {
            uris.clear();
            int len = text.length();
            int i = 0;
            while (i < text.length()) {
                int next = text.nextSpanTransition(i, len, ImageSpan.class);
                ImageSpan[] images = text.getSpans(i, next, ImageSpan.class);
                for (int j = 0; j < images.length; ++j) {
                    uris.add(Uri.parse(images[j].getSource()));
                }
                i = next;
            }
        }

        public void SetHtml(String html) {
            Spanned spanned = Html.fromHtml(html, new Html.ImageGetter(){

                public Drawable getDrawable(String src) {
                    Log.d(EditStyledText.LOG_TAG, "--- sethtml: src=" + src);
                    if (src.startsWith("content://")) {
                        Uri uri = Uri.parse(src);
                        try {
                            InputStream is = StyledTextConverter.this.mEST.getContext().getContentResolver().openInputStream(uri);
                            Bitmap bitmap = BitmapFactory.decodeStream(is);
                            BitmapDrawable drawable2 = new BitmapDrawable(EditStyledText.this.getContext().getResources(), bitmap);
                            drawable2.setBounds(0, 0, ((Drawable)drawable2).getIntrinsicWidth(), ((Drawable)drawable2).getIntrinsicHeight());
                            is.close();
                            return drawable2;
                        }
                        catch (Exception e) {
                            Log.e(EditStyledText.LOG_TAG, "--- set html: Failed to loaded content " + uri, e);
                            return null;
                        }
                    }
                    Log.d(EditStyledText.LOG_TAG, "  unknown src=" + src);
                    return null;
                }
            }, null);
            this.mEST.setText(spanned);
        }
    }

    public class EditorManager {
        public boolean mEditFlag = false;
        public boolean mSoftKeyBlockFlag = false;
        public int mMode = 0;
        public int mState = 0;
        public int mCurStart = 0;
        public int mCurEnd = 0;
        public EditStyledText mEST;

        public EditorManager(EditStyledText est) {
            this.mEST = est;
        }

        public void onStartEdit() {
            Log.d(EditStyledText.LOG_TAG, "--- onstartedit:");
            this.handleResetEdit();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onEndEdit() {
            this.handleCancel();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartCopy() {
            this.handleCopy();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartCut() {
            this.handleCut();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartPaste() {
            this.handlePaste();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartSize() {
            this.handleSize();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartAlign() {
            this.handleAlign();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartColor() {
            this.handleColor();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartBackgroundColor() {
            this.mEST.onShowBackgroundColorAlert();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartSelect() {
            this.mMode = 5;
            if (this.mState == 0) {
                this.handleSelect();
            } else {
                this.unsetSelect();
                this.handleSelect();
            }
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onCursorMoved() {
            if (this.mState == 1 || this.mState == 2) {
                this.handleSelect();
                this.mEST.notifyStateChanged(this.mMode, this.mState);
            }
        }

        public void onStartSelectAll() {
            this.handleSelectAll();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onFixSelectedItem() {
            this.handleComplete();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertImage(Uri uri) {
            this.insertImageSpan(new ImageSpan(this.mEST.getContext(), uri));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertImage(int resID) {
            this.insertImageSpan(new ImageSpan(this.mEST.getContext(), resID));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertHorizontalLine() {
            this.insertImageSpan(new HorizontalLineSpan(-16777216, this.mEST));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onClearStyles() {
            Object[] styles;
            Editable txt = this.mEST.getText();
            int len = txt.length();
            for (Object style2 : styles = txt.getSpans(0, len, Object.class)) {
                if (!(style2 instanceof ParagraphStyle) && !(style2 instanceof QuoteSpan) && !(style2 instanceof CharacterStyle)) continue;
                if (style2 instanceof ImageSpan) {
                    int start = txt.getSpanStart(style2);
                    int end = txt.getSpanEnd(style2);
                    txt.replace(start, end, "");
                }
                txt.removeSpan(style2);
            }
            this.mEST.setBackgroundDrawable(this.mEST.mDefaultBackground);
            this.mEST.mBackgroundColor = 0xFFFFFF;
        }

        public void setItemSize(int size) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeSizeSelectedText(size);
                this.handleResetEdit();
            }
        }

        public void setItemColor(int color2) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeColorSelectedText(color2);
                this.handleResetEdit();
            }
        }

        public void setAlignment(Layout.Alignment align) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeAlign(align);
                this.handleResetEdit();
            }
        }

        public boolean isEditting() {
            return this.mEditFlag;
        }

        public boolean isStyledText() {
            int len;
            Editable txt = this.mEST.getText();
            return txt.getSpans(0, (len = txt.length()) - 1, ParagraphStyle.class).length > 0 || txt.getSpans(0, len - 1, QuoteSpan.class).length > 0 || txt.getSpans(0, len - 1, CharacterStyle.class).length > 0 || this.mEST.mBackgroundColor != 0xFFFFFF;
        }

        public boolean isSoftKeyBlocked() {
            return this.mSoftKeyBlockFlag;
        }

        public int getEditMode() {
            return this.mMode;
        }

        public int getSelectState() {
            return this.mState;
        }

        public int getSelectionStart() {
            return this.mCurStart;
        }

        public int getSelectionEnd() {
            return this.mCurEnd;
        }

        public void doNextHandle() {
            switch (this.mMode) {
                case 1: {
                    this.handleCopy();
                    break;
                }
                case 7: {
                    this.handleCut();
                    break;
                }
                case 2: {
                    this.handlePaste();
                    break;
                }
                case 3: {
                    this.handleSize();
                    break;
                }
                case 4: {
                    this.handleColor();
                    break;
                }
                case 6: {
                    this.handleAlign();
                    break;
                }
            }
        }

        public void handleCancel() {
            this.mMode = 0;
            this.mState = 0;
            this.mEditFlag = false;
            Log.d(EditStyledText.LOG_TAG, "--- handleCancel:" + this.mEST.getInputType());
            this.unblockSoftKey();
            this.unsetSelect();
        }

        public void handleComplete() {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mState == 2) {
                this.mState = 3;
            }
            this.doNextHandle();
        }

        public void handleTextViewFunc(int mode, int id2) {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mMode == 0 || this.mMode == 5) {
                this.mMode = mode;
                if (this.mState == 2) {
                    this.mState = 3;
                    this.handleTextViewFunc(mode, id2);
                } else {
                    this.handleSelect();
                }
            } else if (this.mMode != mode) {
                this.handleCancel();
                this.mMode = mode;
                this.handleTextViewFunc(mode, id2);
            } else if (this.mState == 3) {
                this.mEST.onTextContextMenuItem(id2);
                this.handleResetEdit();
            }
        }

        public void handleCopy() {
            this.handleTextViewFunc(1, 0x1020021);
        }

        public void handleCut() {
            this.handleTextViewFunc(7, 0x1020020);
        }

        public void handlePaste() {
            if (!this.mEditFlag) {
                return;
            }
            this.mEST.onTextContextMenuItem(0x1020022);
        }

        public void handleSetSpan(int mode) {
            if (!this.mEditFlag) {
                Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: Editing is not started.");
                return;
            }
            if (this.mMode == 0 || this.mMode == 5) {
                this.mMode = mode;
                if (this.mState == 2) {
                    this.mState = 3;
                    this.handleSetSpan(mode);
                } else {
                    this.handleSelect();
                }
            } else if (this.mMode != mode) {
                this.handleCancel();
                this.mMode = mode;
                this.handleSetSpan(mode);
            } else if (this.mState == 3) {
                this.mEST.setHintMessage(0);
                switch (mode) {
                    case 4: {
                        this.mEST.onShowForegroundColorAlert();
                        break;
                    }
                    case 3: {
                        this.mEST.onShowSizeAlert();
                        break;
                    }
                    case 6: {
                        this.mEST.onShowAlignAlert();
                        break;
                    }
                    default: {
                        Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: invalid mode.");
                        break;
                    }
                }
            } else {
                Log.d(EditStyledText.LOG_TAG, "--- handleSetSpan: do nothing.");
            }
        }

        public void handleSize() {
            this.handleSetSpan(3);
        }

        public void handleColor() {
            this.handleSetSpan(4);
        }

        public void handleAlign() {
            this.handleSetSpan(6);
        }

        public void handleSelect() {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mState == 0) {
                if (this.isTextSelected()) {
                    Log.e(EditStyledText.LOG_TAG, "Selection is off, but selected");
                }
                this.setSelectStartPos();
                this.blockSoftKey();
                this.mEST.setHintMessage(3);
            } else if (this.mState == 1) {
                if (this.isTextSelected()) {
                    Log.e(EditStyledText.LOG_TAG, "Selection now start, but selected");
                }
                this.setSelectedEndPos();
                this.mEST.setHintMessage(4);
                this.doNextHandle();
            } else if (this.mState == 2) {
                if (!this.isTextSelected()) {
                    Log.e(EditStyledText.LOG_TAG, "Selection is done, but not selected");
                }
                this.setSelectedEndPos();
                this.doNextHandle();
            }
        }

        public void handleSelectAll() {
            if (!this.mEditFlag) {
                return;
            }
            this.mEST.selectAll();
            this.mState = 2;
        }

        public void handleResetEdit() {
            this.blockSoftKey();
            this.handleCancel();
            this.mEditFlag = true;
            this.mEST.setHintMessage(2);
        }

        public void setSelection() {
            if (this.mCurStart >= 0 && this.mCurStart <= this.mEST.getText().length() && this.mCurEnd >= 0 && this.mCurEnd <= this.mEST.getText().length()) {
                if (this.mCurStart < this.mCurEnd) {
                    this.mEST.setSelection(this.mCurStart, this.mCurEnd);
                } else {
                    this.mEST.setSelection(this.mCurEnd, this.mCurStart);
                }
                this.mState = 2;
            } else {
                Log.e(EditStyledText.LOG_TAG, "Select is on, but cursor positions are illigal.:" + this.mEST.getText().length() + "," + this.mCurStart + "," + this.mCurEnd);
            }
        }

        public void unsetSelect() {
            int currpos = this.mEST.getSelectionStart();
            this.mEST.setSelection(currpos, currpos);
            this.mState = 0;
        }

        public void setSelectStartPos() {
            this.mCurStart = this.mEST.getSelectionStart();
            this.mState = 1;
        }

        public void setSelectedEndPos() {
            if (this.mEST.getSelectionStart() == this.mCurStart) {
                this.setSelectedEndPos(this.mEST.getSelectionEnd());
            } else {
                this.setSelectedEndPos(this.mEST.getSelectionStart());
            }
        }

        public void setSelectedEndPos(int pos) {
            this.mCurEnd = pos;
            this.setSelection();
        }

        public boolean isTextSelected() {
            return this.mCurStart != this.mCurEnd && (this.mState == 2 || this.mState == 3);
        }

        public void setStyledTextSpan(Object span, int start, int end) {
            if (start < end) {
                this.mEST.getText().setSpan(span, start, end, 33);
            } else {
                this.mEST.getText().setSpan(span, end, start, 33);
            }
        }

        public void changeSizeSelectedText(int size) {
            this.setStyledTextSpan(new AbsoluteSizeSpan(size), this.mCurStart, this.mCurEnd);
        }

        public void changeColorSelectedText(int color2) {
            this.setStyledTextSpan(new ForegroundColorSpan(color2), this.mCurStart, this.mCurEnd);
        }

        public void changeAlign(Layout.Alignment align) {
            this.setStyledTextSpan(new AlignmentSpan.Standard(align), this.findLineStart(this.mEST.getText(), this.mCurStart), this.findLineEnd(this.mEST.getText(), this.mCurEnd));
        }

        public int findLineStart(Editable text, int current) {
            int pos;
            for (pos = current; pos > 0 && text.charAt(pos - 1) != '\n'; --pos) {
            }
            return pos;
        }

        public void insertImageSpan(ImageSpan span) {
            if (span != null) {
                Log.d(EditStyledText.LOG_TAG, "--- insertimagespan:" + span.getDrawable().getIntrinsicHeight() + "," + span.getDrawable().getIntrinsicWidth());
                Log.d(EditStyledText.LOG_TAG, "--- insertimagespan:" + span.getDrawable().getClass());
                int curpos = this.mEST.getSelectionStart();
                this.mEST.getText().insert(curpos, "\ufffc");
                this.mEST.getText().setSpan(span, curpos, curpos + 1, 33);
                this.mEST.notifyStateChanged(this.mMode, this.mState);
            } else {
                Log.e(EditStyledText.LOG_TAG, "--- insertImageSpan: null span was inserted");
            }
        }

        public int findLineEnd(Editable text, int current) {
            int pos;
            for (pos = current; pos < text.length() && (pos <= 0 || text.charAt(pos - 1) != '\n'); ++pos) {
            }
            return pos;
        }

        public void blockSoftKey() {
            InputMethodManager imm = (InputMethodManager)this.mEST.getContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.mEST.getWindowToken(), 0);
            this.mEST.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Log.d(EditStyledText.LOG_TAG, "--- ontrackballclick:");
                    EditorManager.this.onFixSelectedItem();
                }
            });
            this.mSoftKeyBlockFlag = true;
        }

        public void unblockSoftKey() {
            this.mEST.setOnClickListener(null);
            this.mSoftKeyBlockFlag = false;
        }
    }

    public static interface EditStyledTextNotifier {
        public void notifyHintMsg(int var1);

        public void notifyStateChanged(int var1, int var2);
    }
}

