/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.os.FileObserver;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.security.MessageDigest;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Button;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockPatternUtils {
    public static final String TAG = "LockPatternUtils";
    public static final String SYSTEM_DIRECTORY = "/system/";
    public static final String LOCK_PATTERN_FILE = "gesture.key";
    public static final String LOCK_PASSWORD_FILE = "password.key";
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 3;
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public final Context mContext;
    public final ContentResolver mContentResolver;
    public DevicePolicyManager mDevicePolicyManager;
    public static String sLockPatternFilename;
    public static String sLockPasswordFilename;
    public static final AtomicBoolean sHaveNonZeroPatternFile;
    public static final AtomicBoolean sHaveNonZeroPasswordFile;
    public static FileObserver sPasswordObserver;

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        if (sLockPatternFilename == null) {
            String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
            sLockPatternFilename = dataSystemDirectory + LOCK_PATTERN_FILE;
            sLockPasswordFilename = dataSystemDirectory + LOCK_PASSWORD_FILE;
            sHaveNonZeroPatternFile.set(new File(sLockPatternFilename).length() > 0L);
            sHaveNonZeroPasswordFile.set(new File(sLockPasswordFilename).length() > 0L);
            int fileObserverMask = 904;
            sPasswordObserver = new FileObserver(dataSystemDirectory, fileObserverMask){

                public void onEvent(int event, String path) {
                    if (LockPatternUtils.LOCK_PATTERN_FILE.equals(path)) {
                        Log.d(LockPatternUtils.TAG, "lock pattern file changed");
                        sHaveNonZeroPatternFile.set(new File(sLockPatternFilename).length() > 0L);
                    } else if (LockPatternUtils.LOCK_PASSWORD_FILE.equals(path)) {
                        Log.d(LockPatternUtils.TAG, "lock password file changed");
                        sHaveNonZeroPasswordFile.set(new File(sLockPasswordFilename).length() > 0L);
                    }
                }
            };
            sPasswordObserver.startWatching();
        }
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null);
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null);
    }

    public void reportFailedPasswordAttempt() {
        this.getDevicePolicyManager().reportFailedPasswordAttempt();
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt();
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern) {
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPatternFilename, "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            return Arrays.equals(stored, LockPatternUtils.patternToHash(pattern));
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (IOException ioe) {
            return true;
        }
    }

    public boolean checkPassword(String password) {
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPasswordFilename, "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            return Arrays.equals(stored, this.passwordToHash(password));
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (IOException ioe) {
            return true;
        }
    }

    public boolean savedPatternExists() {
        return sHaveNonZeroPatternFile.get();
    }

    public boolean savedPasswordExists() {
        return sHaveNonZeroPasswordFile.get();
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY);
    }

    public int getActivePasswordQuality() {
        int activePasswordQuality = 0;
        switch (this.getKeyguardStoredPasswordQuality()) {
            case 65536: {
                if (!this.isLockPatternEnabled()) break;
                activePasswordQuality = 65536;
                break;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 131072;
                break;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 262144;
                break;
            }
            case 327680: {
                if (!this.isLockPasswordEnabled()) break;
                activePasswordQuality = 327680;
            }
        }
        return activePasswordQuality;
    }

    public void clearLock() {
        this.getDevicePolicyManager().setActivePasswordState(0, 0);
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong(PASSWORD_TYPE_KEY, 65536L);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern) {
        byte[] hash = LockPatternUtils.patternToHash(pattern);
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPatternFilename, "rw");
            if (pattern == null) {
                raf.setLength(0L);
            } else {
                raf.write(hash, 0, hash.length);
            }
            raf.close();
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (pattern != null) {
                this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true);
                this.setLong(PASSWORD_TYPE_KEY, 65536L);
                dpm.setActivePasswordState(65536, pattern.size());
            } else {
                dpm.setActivePasswordState(0, 0);
            }
        }
        catch (FileNotFoundException fnfe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
        }
        catch (IOException ioe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
        }
    }

    public static int computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return 131072;
        }
        return 0;
    }

    public void saveLockPassword(String password, int quality) {
        byte[] hash = this.passwordToHash(password);
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPasswordFilename, "rw");
            if (password == null) {
                raf.setLength(0L);
            } else {
                raf.write(hash, 0, hash.length);
            }
            raf.close();
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (password != null) {
                int computedQuality = LockPatternUtils.computePasswordQuality(password);
                this.setLong(PASSWORD_TYPE_KEY, computedQuality);
                if (computedQuality != 0) {
                    dpm.setActivePasswordState(computedQuality, password.length());
                } else {
                    dpm.setActivePasswordState(0, 0);
                }
            } else {
                dpm.setActivePasswordState(0, 0);
            }
        }
        catch (FileNotFoundException fnfe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPasswordFilename);
        }
        catch (IOException ioe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPasswordFilename);
        }
    }

    public int getKeyguardStoredPasswordQuality() {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static String patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        return new String(res);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    public String getSalt() {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt);
                Log.v(TAG, "Initialized lock password salt");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public byte[] passwordToHash(String password) {
        if (password == null) {
            return null;
        }
        String algo = null;
        byte[] hashed = null;
        try {
            byte[] saltedPassword = (password + this.getSalt()).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = (LockPatternUtils.toHex(sha1) + LockPatternUtils.toHex(md5)).getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(TAG, "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    public static String toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    public boolean isLockPasswordEnabled() {
        long mode = this.getLong(PASSWORD_TYPE_KEY, 0L);
        return this.savedPasswordExists() && (mode == 262144L || mode == 131072L || mode == 327680L);
    }

    public boolean isLockPatternEnabled() {
        return this.getBoolean("lock_pattern_autolock") && this.getLong(PASSWORD_TYPE_KEY, 65536L) == 65536L;
    }

    public void setLockPatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_autolock", enabled);
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern");
    }

    public void setVisiblePatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_visible_pattern", enabled);
    }

    public boolean isTactileFeedbackEnabled() {
        return this.getBoolean("lock_pattern_tactile_feedback_enabled");
    }

    public void setTactileFeedbackEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_tactile_feedback_enabled", enabled);
    }

    public long setLockoutAttemptDeadline() {
        long deadline = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline() {
        long now;
        long deadline = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) || deadline > now + 30000L) {
            return 0L;
        }
        return deadline;
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY);
    }

    public void setPermanentlyLocked(boolean locked) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, locked);
    }

    public String getNextAlarm() {
        String nextAlarm = Settings.System.getString(this.mContentResolver, "next_alarm_formatted");
        if (nextAlarm == null || TextUtils.isEmpty(nextAlarm)) {
            return null;
        }
        return nextAlarm;
    }

    public boolean getBoolean(String secureSettingKey) {
        return 1 == Settings.Secure.getInt(this.mContentResolver, secureSettingKey, 0);
    }

    public void setBoolean(String secureSettingKey, boolean enabled) {
        Settings.Secure.putInt(this.mContentResolver, secureSettingKey, enabled ? 1 : 0);
    }

    public long getLong(String secureSettingKey, long def) {
        return Settings.Secure.getLong(this.mContentResolver, secureSettingKey, def);
    }

    public void setLong(String secureSettingKey, long value) {
        Settings.Secure.putLong(this.mContentResolver, secureSettingKey, value);
    }

    public boolean isSecure() {
        long mode = this.getKeyguardStoredPasswordQuality();
        boolean isPattern = mode == 65536L;
        boolean isPassword = mode == 131072L || mode == 262144L || mode == 327680L;
        boolean secure = isPattern && this.isLockPatternEnabled() && this.savedPatternExists() || isPassword && this.savedPasswordExists();
        return secure;
    }

    public void updateEmergencyCallButtonState(Button button) {
        int textId;
        int newState = TelephonyManager.getDefault().getCallState();
        if (newState == 2) {
            textId = 17040017;
            int phoneCallIcon = 17301636;
            button.setCompoundDrawablesWithIntrinsicBounds(phoneCallIcon, 0, 0, 0);
        } else {
            textId = 17040016;
            int emergencyIcon = 17301910;
            button.setCompoundDrawablesWithIntrinsicBounds(emergencyIcon, 0, 0, 0);
        }
        button.setText(textId);
    }

    public boolean resumeCall() {
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        try {
            if (phone != null && phone.showCallScreen()) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    static {
        sHaveNonZeroPatternFile = new AtomicBoolean(false);
        sHaveNonZeroPasswordFile = new AtomicBoolean(false);
    }
}

