/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.android.internal.R;
import com.android.internal.widget.LockPatternUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockPatternView
extends View {
    public static final int ASPECT_SQUARE = 0;
    public static final int ASPECT_LOCK_WIDTH = 1;
    public static final int ASPECT_LOCK_HEIGHT = 2;
    public static final long[] DEFAULT_VIBE_PATTERN = new long[]{0L, 1L, 40L, 41L};
    public static final boolean PROFILE_DRAWING = false;
    public boolean mDrawingProfilingStarted = false;
    public Paint mPaint = new Paint();
    public Paint mPathPaint = new Paint();
    public static final int STATUS_BAR_HEIGHT = 25;
    public static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    public OnPatternListener mOnPatternListener;
    public ArrayList<Cell> mPattern = new ArrayList(9);
    public boolean[][] mPatternDrawLookup = new boolean[3][3];
    public float mInProgressX = -1.0f;
    public float mInProgressY = -1.0f;
    public long mAnimatingPeriodStart;
    public DisplayMode mPatternDisplayMode = DisplayMode.Correct;
    public boolean mInputEnabled = true;
    public boolean mInStealthMode = false;
    public boolean mTactileFeedbackEnabled = true;
    public boolean mPatternInProgress = false;
    public float mDiameterFactor = 0.5f;
    public float mHitFactor = 0.6f;
    public float mSquareWidth;
    public float mSquareHeight;
    public Bitmap mBitmapBtnDefault;
    public Bitmap mBitmapBtnTouched;
    public Bitmap mBitmapCircleDefault;
    public Bitmap mBitmapCircleGreen;
    public Bitmap mBitmapCircleRed;
    public Bitmap mBitmapArrowGreenUp;
    public Bitmap mBitmapArrowRedUp;
    public final Path mCurrentPath = new Path();
    public final Rect mInvalidate = new Rect();
    public int mBitmapWidth;
    public int mBitmapHeight;
    public Vibrator vibe = new Vibrator();
    public long[] mVibePattern;
    public int mAspect;

    public LockPatternView(Context context) {
        this(context, null);
    }

    public LockPatternView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LockPatternView);
        String aspect = a.getString(0);
        this.mAspect = "square".equals(aspect) ? 0 : ("lock_width".equals(aspect) ? 1 : ("lock_height".equals(aspect) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mPathPaint.setColor(-1);
        this.mPathPaint.setAlpha(128);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBitmapBtnDefault = this.getBitmapFor(17301708);
        this.mBitmapBtnTouched = this.getBitmapFor(17301709);
        this.mBitmapCircleDefault = this.getBitmapFor(17301978);
        this.mBitmapCircleGreen = this.getBitmapFor(17301979);
        this.mBitmapCircleRed = this.getBitmapFor(17301980);
        this.mBitmapArrowGreenUp = this.getBitmapFor(17301976);
        this.mBitmapArrowRedUp = this.getBitmapFor(17301977);
        this.mBitmapWidth = this.mBitmapBtnDefault.getWidth();
        this.mBitmapHeight = this.mBitmapBtnDefault.getHeight();
        this.mVibePattern = this.loadVibratePattern(0x1070011);
    }

    public long[] loadVibratePattern(int id2) {
        int[] pattern = null;
        try {
            pattern = this.getResources().getIntArray(id2);
        }
        catch (Resources.NotFoundException e) {
            Log.e("LockPatternView", "Vibrate pattern missing, using default", e);
        }
        if (pattern == null) {
            return DEFAULT_VIBE_PATTERN;
        }
        long[] tmpPattern = new long[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            tmpPattern[i] = pattern[i];
        }
        return tmpPattern;
    }

    public Bitmap getBitmapFor(int resId) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), resId);
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mTactileFeedbackEnabled;
    }

    public void setInStealthMode(boolean inStealthMode) {
        this.mInStealthMode = inStealthMode;
    }

    public void setTactileFeedbackEnabled(boolean tactileFeedbackEnabled) {
        this.mTactileFeedbackEnabled = tactileFeedbackEnabled;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(DisplayMode displayMode, List<Cell> pattern) {
        this.mPattern.clear();
        this.mPattern.addAll(pattern);
        this.clearPatternDrawLookup();
        for (Cell cell : pattern) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell first = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(first.getColumn());
            this.mInProgressY = this.getCenterYForRow(first.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void clearPattern() {
        this.resetPattern();
    }

    public void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    public void clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
            }
        }
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    @Override
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        int width = w - this.mPaddingLeft - this.mPaddingRight;
        this.mSquareWidth = (float)width / 3.0f;
        int height = h - this.mPaddingTop - this.mPaddingBottom;
        this.mSquareHeight = (float)height / 3.0f;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize(widthMeasureSpec);
        int height = View.MeasureSpec.getSize(heightMeasureSpec);
        int viewWidth = width;
        int viewHeight = height;
        switch (this.mAspect) {
            case 0: {
                viewWidth = viewHeight = Math.min(width, height);
                break;
            }
            case 1: {
                viewWidth = width;
                viewHeight = Math.min(width, height);
                break;
            }
            case 2: {
                viewWidth = Math.min(width, height);
                viewHeight = height;
            }
        }
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    public Cell detectAndAddHit(float x, float y) {
        Cell cell = this.checkForNewHit(x, y);
        if (cell != null) {
            Cell fillInGapCell = null;
            ArrayList<Cell> pattern = this.mPattern;
            if (!pattern.isEmpty()) {
                Cell lastCell = pattern.get(pattern.size() - 1);
                int dRow = cell.row - lastCell.row;
                int dColumn = cell.column - lastCell.column;
                int fillInRow = lastCell.row;
                int fillInColumn = lastCell.column;
                if (Math.abs(dRow) == 2 && Math.abs(dColumn) != 1) {
                    fillInRow = lastCell.row + (dRow > 0 ? 1 : -1);
                }
                if (Math.abs(dColumn) == 2 && Math.abs(dRow) != 1) {
                    fillInColumn = lastCell.column + (dColumn > 0 ? 1 : -1);
                }
                fillInGapCell = Cell.of(fillInRow, fillInColumn);
            }
            if (fillInGapCell != null && !this.mPatternDrawLookup[fillInGapCell.row][fillInGapCell.column]) {
                this.addCellToPattern(fillInGapCell);
            }
            this.addCellToPattern(cell);
            if (this.mTactileFeedbackEnabled) {
                this.vibe.vibrate(this.mVibePattern, -1);
            }
            return cell;
        }
        return null;
    }

    public void addCellToPattern(Cell newCell) {
        this.mPatternDrawLookup[newCell.getRow()][newCell.getColumn()] = true;
        this.mPattern.add(newCell);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
    }

    public Cell checkForNewHit(float x, float y) {
        int rowHit = this.getRowHit(y);
        if (rowHit < 0) {
            return null;
        }
        int columnHit = this.getColumnHit(x);
        if (columnHit < 0) {
            return null;
        }
        if (this.mPatternDrawLookup[rowHit][columnHit]) {
            return null;
        }
        return Cell.of(rowHit, columnHit);
    }

    public int getRowHit(float y) {
        float squareHeight = this.mSquareHeight;
        float hitSize = squareHeight * this.mHitFactor;
        float offset = (float)this.mPaddingTop + (squareHeight - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitTop = offset + squareHeight * (float)i;
            if (!(y >= hitTop) || !(y <= hitTop + hitSize)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnHit(float x) {
        float squareWidth = this.mSquareWidth;
        float hitSize = squareWidth * this.mHitFactor;
        float offset = (float)this.mPaddingLeft + (squareWidth - hitSize) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float hitLeft = offset + squareWidth * (float)i;
            if (!(x >= hitLeft) || !(x <= hitLeft + hitSize)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            return false;
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 0: {
                this.resetPattern();
                Cell hitCell = this.detectAndAddHit(x, y);
                if (hitCell != null && this.mOnPatternListener != null) {
                    this.mPatternInProgress = true;
                    this.mPatternDisplayMode = DisplayMode.Correct;
                    this.mOnPatternListener.onPatternStart();
                } else if (this.mOnPatternListener != null) {
                    this.mPatternInProgress = false;
                    this.mOnPatternListener.onPatternCleared();
                }
                if (hitCell != null) {
                    float startX = this.getCenterXForColumn(hitCell.column);
                    float startY = this.getCenterYForRow(hitCell.row);
                    float widthOffset = this.mSquareWidth / 2.0f;
                    float heightOffset = this.mSquareHeight / 2.0f;
                    this.invalidate((int)(startX - widthOffset), (int)(startY - heightOffset), (int)(startX + widthOffset), (int)(startY + heightOffset));
                }
                this.mInProgressX = x;
                this.mInProgressY = y;
                return true;
            }
            case 1: {
                if (!this.mPattern.isEmpty() && this.mOnPatternListener != null) {
                    this.mPatternInProgress = false;
                    this.mOnPatternListener.onPatternDetected(this.mPattern);
                    this.invalidate();
                }
                return true;
            }
            case 2: {
                float dy;
                float dx;
                int patternSizePreHitDetect = this.mPattern.size();
                Cell hitCell = this.detectAndAddHit(x, y);
                int patternSize = this.mPattern.size();
                if (hitCell != null && this.mOnPatternListener != null && patternSize == 1) {
                    this.mPatternInProgress = true;
                    this.mOnPatternListener.onPatternStart();
                }
                if ((dx = Math.abs(x - this.mInProgressX)) + (dy = Math.abs(y - this.mInProgressY)) > this.mSquareWidth * 0.01f) {
                    float oldX = this.mInProgressX;
                    float oldY = this.mInProgressY;
                    this.mInProgressX = x;
                    this.mInProgressY = y;
                    if (this.mPatternInProgress && patternSize > 0) {
                        float bottom;
                        float top;
                        float right;
                        float left;
                        ArrayList<Cell> pattern = this.mPattern;
                        float radius = this.mSquareWidth * this.mDiameterFactor * 0.5f;
                        Cell lastCell = pattern.get(patternSize - 1);
                        float startX = this.getCenterXForColumn(lastCell.column);
                        float startY = this.getCenterYForRow(lastCell.row);
                        Rect invalidateRect = this.mInvalidate;
                        if (startX < x) {
                            left = startX;
                            right = x;
                        } else {
                            left = x;
                            right = startX;
                        }
                        if (startY < y) {
                            top = startY;
                            bottom = y;
                        } else {
                            top = y;
                            bottom = startY;
                        }
                        invalidateRect.set((int)(left - radius), (int)(top - radius), (int)(right + radius), (int)(bottom + radius));
                        if (startX < oldX) {
                            left = startX;
                            right = oldX;
                        } else {
                            left = oldX;
                            right = startX;
                        }
                        if (startY < oldY) {
                            top = startY;
                            bottom = oldY;
                        } else {
                            top = oldY;
                            bottom = startY;
                        }
                        invalidateRect.union((int)(left - radius), (int)(top - radius), (int)(right + radius), (int)(bottom + radius));
                        if (hitCell != null) {
                            startX = this.getCenterXForColumn(hitCell.column);
                            startY = this.getCenterYForRow(hitCell.row);
                            if (patternSize >= 2) {
                                hitCell = pattern.get(patternSize - 1 - (patternSize - patternSizePreHitDetect));
                                oldX = this.getCenterXForColumn(hitCell.column);
                                oldY = this.getCenterYForRow(hitCell.row);
                                if (startX < oldX) {
                                    left = startX;
                                    right = oldX;
                                } else {
                                    left = oldX;
                                    right = startX;
                                }
                                if (startY < oldY) {
                                    top = startY;
                                    bottom = oldY;
                                } else {
                                    top = oldY;
                                    bottom = startY;
                                }
                            } else {
                                left = right = startX;
                                top = bottom = startY;
                            }
                            float widthOffset = this.mSquareWidth / 2.0f;
                            float heightOffset = this.mSquareHeight / 2.0f;
                            invalidateRect.set((int)(left - widthOffset), (int)(top - heightOffset), (int)(right + widthOffset), (int)(bottom + heightOffset));
                        }
                        this.invalidate(invalidateRect);
                    } else {
                        this.invalidate();
                    }
                }
                return true;
            }
            case 3: {
                this.resetPattern();
                if (this.mOnPatternListener != null) {
                    this.mPatternInProgress = false;
                    this.mOnPatternListener.onPatternCleared();
                }
                return true;
            }
        }
        return false;
    }

    public float getCenterXForColumn(int column) {
        return (float)this.mPaddingLeft + (float)column * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    public float getCenterYForRow(int row) {
        return (float)this.mPaddingTop + (float)row * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    @Override
    public void onDraw(Canvas canvas) {
        boolean drawPath;
        ArrayList<Cell> pattern = this.mPattern;
        int count = pattern.size();
        boolean[][] drawLookup = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            boolean needToUpdateInProgressPoint;
            int oneCycle = (count + 1) * 700;
            int spotInCycle = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % oneCycle;
            int numCircles = spotInCycle / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < numCircles; ++i) {
                Cell cell = pattern.get(i);
                drawLookup[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = needToUpdateInProgressPoint = numCircles > 0 && numCircles < count;
            if (needToUpdateInProgressPoint) {
                float percentageOfNextCircle = (float)(spotInCycle % 700) / 700.0f;
                Cell currentCell = pattern.get(numCircles - 1);
                float centerX = this.getCenterXForColumn(currentCell.column);
                float centerY = this.getCenterYForRow(currentCell.row);
                Cell nextCell = pattern.get(numCircles);
                float dx = percentageOfNextCircle * (this.getCenterXForColumn(nextCell.column) - centerX);
                float dy = percentageOfNextCircle * (this.getCenterYForRow(nextCell.row) - centerY);
                this.mInProgressX = centerX + dx;
                this.mInProgressY = centerY + dy;
            }
            this.invalidate();
        }
        float squareWidth = this.mSquareWidth;
        float squareHeight = this.mSquareHeight;
        float radius = squareWidth * this.mDiameterFactor * 0.5f;
        this.mPathPaint.setStrokeWidth(radius);
        Path currentPath = this.mCurrentPath;
        currentPath.rewind();
        boolean bl = drawPath = !this.mInStealthMode || this.mPatternDisplayMode == DisplayMode.Wrong;
        if (drawPath) {
            boolean anyCircles = false;
            for (int i = 0; i < count; ++i) {
                Cell cell = pattern.get(i);
                if (!drawLookup[cell.row][cell.column]) break;
                anyCircles = true;
                float centerX = this.getCenterXForColumn(cell.column);
                float centerY = this.getCenterYForRow(cell.row);
                if (i == 0) {
                    currentPath.moveTo(centerX, centerY);
                    continue;
                }
                currentPath.lineTo(centerX, centerY);
            }
            if ((this.mPatternInProgress || this.mPatternDisplayMode == DisplayMode.Animate) && anyCircles) {
                currentPath.lineTo(this.mInProgressX, this.mInProgressY);
            }
            canvas.drawPath(currentPath, this.mPathPaint);
        }
        int paddingTop = this.mPaddingTop;
        int paddingLeft = this.mPaddingLeft;
        for (int i = 0; i < 3; ++i) {
            float topY = (float)paddingTop + (float)i * squareHeight;
            for (int j = 0; j < 3; ++j) {
                float leftX = (float)paddingLeft + (float)j * squareWidth;
                this.drawCircle(canvas, (int)leftX, (int)topY, drawLookup[i][j]);
            }
        }
        boolean oldFlag = (this.mPaint.getFlags() & 2) != 0;
        this.mPaint.setFilterBitmap(true);
        if (drawPath) {
            for (int i = 0; i < count - 1; ++i) {
                Cell cell = pattern.get(i);
                Cell next = pattern.get(i + 1);
                if (!drawLookup[next.row][next.column]) break;
                float leftX = (float)paddingLeft + (float)cell.column * squareWidth;
                float topY = (float)paddingTop + (float)cell.row * squareHeight;
                this.drawArrow(canvas, leftX, topY, cell, next);
            }
        }
        this.mPaint.setFilterBitmap(oldFlag);
    }

    public void drawArrow(Canvas canvas, float leftX, float topY, Cell start, Cell end) {
        boolean green = this.mPatternDisplayMode != DisplayMode.Wrong;
        int endRow = end.row;
        int startRow = start.row;
        int endColumn = end.column;
        int startColumn = start.column;
        int offsetX = ((int)this.mSquareWidth - this.mBitmapWidth) / 2;
        int offsetY = ((int)this.mSquareHeight - this.mBitmapHeight) / 2;
        Bitmap arrow = green ? this.mBitmapArrowGreenUp : this.mBitmapArrowRedUp;
        Matrix matrix = new Matrix();
        int cellWidth = this.mBitmapCircleDefault.getWidth();
        int cellHeight = this.mBitmapCircleDefault.getHeight();
        float theta = (float)Math.atan2(endRow - startRow, endColumn - startColumn);
        float angle = (float)Math.toDegrees(theta) + 90.0f;
        matrix.setTranslate(leftX + (float)offsetX, topY + (float)offsetY);
        matrix.preRotate(angle, (float)cellWidth / 2.0f, (float)cellHeight / 2.0f);
        matrix.preTranslate((float)(cellWidth - arrow.getWidth()) / 2.0f, 0.0f);
        canvas.drawBitmap(arrow, matrix, this.mPaint);
    }

    public void drawCircle(Canvas canvas, int leftX, int topY, boolean partOfPattern) {
        Bitmap innerCircle;
        Bitmap outerCircle;
        if (!partOfPattern || this.mInStealthMode && this.mPatternDisplayMode != DisplayMode.Wrong) {
            outerCircle = this.mBitmapCircleDefault;
            innerCircle = this.mBitmapBtnDefault;
        } else if (this.mPatternInProgress) {
            outerCircle = this.mBitmapCircleGreen;
            innerCircle = this.mBitmapBtnTouched;
        } else if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            outerCircle = this.mBitmapCircleRed;
            innerCircle = this.mBitmapBtnDefault;
        } else if (this.mPatternDisplayMode == DisplayMode.Correct || this.mPatternDisplayMode == DisplayMode.Animate) {
            outerCircle = this.mBitmapCircleGreen;
            innerCircle = this.mBitmapBtnDefault;
        } else {
            throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
        }
        int width = this.mBitmapWidth;
        int height = this.mBitmapHeight;
        float squareWidth = this.mSquareWidth;
        float squareHeight = this.mSquareHeight;
        int offsetX = (int)((squareWidth - (float)width) / 2.0f);
        int offsetY = (int)((squareHeight - (float)height) / 2.0f);
        canvas.drawBitmap(outerCircle, leftX + offsetX, topY + offsetY, this.mPaint);
        canvas.drawBitmap(innerCircle, leftX + offsetX, topY + offsetY, this.mPaint);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mTactileFeedbackEnabled, null);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.stringToPattern(ss.getSerializedPattern()));
        this.mPatternDisplayMode = DisplayMode.values()[ss.getDisplayMode()];
        this.mInputEnabled = ss.isInputEnabled();
        this.mInStealthMode = ss.isInStealthMode();
        this.mTactileFeedbackEnabled = ss.isTactileFeedbackEnabled();
    }

    public static class 1 {
    }

    public static class SavedState
    extends View.BaseSavedState {
        public final String mSerializedPattern;
        public final int mDisplayMode;
        public final boolean mInputEnabled;
        public final boolean mInStealthMode;
        public final boolean mTactileFeedbackEnabled;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState, String serializedPattern, int displayMode, boolean inputEnabled, boolean inStealthMode, boolean tactileFeedbackEnabled) {
            super(superState);
            this.mSerializedPattern = serializedPattern;
            this.mDisplayMode = displayMode;
            this.mInputEnabled = inputEnabled;
            this.mInStealthMode = inStealthMode;
            this.mTactileFeedbackEnabled = tactileFeedbackEnabled;
        }

        public SavedState(Parcel in) {
            super(in);
            this.mSerializedPattern = in.readString();
            this.mDisplayMode = in.readInt();
            this.mInputEnabled = (Boolean)in.readValue(null);
            this.mInStealthMode = (Boolean)in.readValue(null);
            this.mTactileFeedbackEnabled = (Boolean)in.readValue(null);
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        public boolean isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.mSerializedPattern);
            dest.writeInt(this.mDisplayMode);
            dest.writeValue(this.mInputEnabled);
            dest.writeValue(this.mInStealthMode);
            dest.writeValue(this.mTactileFeedbackEnabled);
        }

        public /* synthetic */ SavedState(Parcelable x0, String x1, int x2, boolean x3, boolean x4, boolean x5, 1 x6) {
            this(x0, x1, x2, x3, x4, x5);
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnPatternListener {
        public void onPatternStart();

        public void onPatternCleared();

        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternDetected(List<Cell> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        Correct,
        Animate,
        Wrong;

    }

    public static class Cell {
        public int row;
        public int column;
        public static Cell[][] sCells = new Cell[3][3];

        public Cell(int row, int column) {
            Cell.checkRange(row, column);
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public static synchronized Cell of(int row, int column) {
            Cell.checkRange(row, column);
            return sCells[row][column];
        }

        public static void checkRange(int row, int column) {
            if (row < 0 || row > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (column < 0 || column > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        public String toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }

        static {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Cell.sCells[i][j] = new Cell(i, j);
                }
            }
        }
    }
}

