/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Handler;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.widget.PasswordEntryKeyboard;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener {
    public static final int KEYBOARD_MODE_ALPHA = 0;
    public static final int KEYBOARD_MODE_NUMERIC = 1;
    public static final int KEYBOARD_STATE_NORMAL = 0;
    public static final int KEYBOARD_STATE_SHIFTED = 1;
    public static final int KEYBOARD_STATE_CAPSLOCK = 2;
    public static final String TAG = "PasswordEntryKeyboardHelper";
    public int mKeyboardMode = 0;
    public int mKeyboardState = 0;
    public PasswordEntryKeyboard mQwertyKeyboard;
    public PasswordEntryKeyboard mQwertyKeyboardShifted;
    public PasswordEntryKeyboard mSymbolsKeyboard;
    public PasswordEntryKeyboard mSymbolsKeyboardShifted;
    public PasswordEntryKeyboard mNumericKeyboard;
    public Context mContext;
    public View mTargetView;
    public KeyboardView mKeyboardView;
    public long[] mVibratePattern;
    public Vibrator mVibrator;

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View targetView) {
        this.mContext = context;
        this.mTargetView = targetView;
        this.mKeyboardView = keyboardView;
        this.createKeyboards();
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mVibrator = new Vibrator();
    }

    public boolean isAlpha() {
        return this.mKeyboardMode == 0;
    }

    public void createKeyboards() {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, 17498116);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, 17498118, 16908851);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, 17498119, 16908851);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, 17498120);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, 17498121);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    public void setKeyboardMode(int mode) {
        switch (mode) {
            case 0: {
                this.mKeyboardView.setKeyboard(this.mQwertyKeyboard);
                this.mKeyboardState = 0;
                boolean visiblePassword = Settings.System.getInt(this.mContext.getContentResolver(), "show_password", 1) != 0;
                this.mKeyboardView.setPreviewEnabled(visiblePassword);
                break;
            }
            case 1: {
                this.mKeyboardView.setKeyboard(this.mNumericKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = mode;
    }

    public void sendKeyEventsToTarget(int character) {
        Handler handler = this.mTargetView.getHandler();
        KeyEvent[] events = KeyCharacterMap.load(3).getEvents(new char[]{(char)character});
        if (events != null) {
            for (KeyEvent event : events) {
                event = KeyEvent.changeFlags(event, event.getFlags() | 2 | 4);
                handler.sendMessage(handler.obtainMessage(1005, event));
            }
        }
    }

    public void sendDownUpKeyEvents(int keyEventCode) {
        long eventTime = SystemClock.uptimeMillis();
        Handler handler = this.mTargetView.getHandler();
        handler.sendMessage(handler.obtainMessage(1011, new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, 0, 0, 6)));
        handler.sendMessage(handler.obtainMessage(1011, new KeyEvent(eventTime, eventTime, 1, keyEventCode, 0, 0, 0, 0, 6)));
    }

    public void onKey(int primaryCode, int[] keyCodes) {
        if (primaryCode == -5) {
            this.handleBackspace();
        } else if (primaryCode == -1) {
            this.handleShift();
        } else {
            if (primaryCode == -3) {
                this.handleClose();
                return;
            }
            if (primaryCode == -2 && this.mKeyboardView != null) {
                this.handleModeChange();
            } else {
                this.handleCharacter(primaryCode, keyCodes);
                if (this.mKeyboardState == 1) {
                    this.mKeyboardState = 2;
                    this.handleShift();
                }
            }
        }
    }

    public void setVibratePattern(int id2) {
        int[] tmpArray;
        block4: {
            tmpArray = null;
            try {
                tmpArray = this.mContext.getResources().getIntArray(id2);
            }
            catch (Resources.NotFoundException e) {
                if (id2 == 0) break block4;
                Log.e(TAG, "Vibrate pattern missing", e);
            }
        }
        if (tmpArray == null) {
            this.mVibratePattern = null;
            return;
        }
        this.mVibratePattern = new long[tmpArray.length];
        for (int i = 0; i < tmpArray.length; ++i) {
            this.mVibratePattern[i] = tmpArray[i];
        }
    }

    public void handleModeChange() {
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        if (current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted) {
            next = this.mSymbolsKeyboard;
        } else if (current == this.mSymbolsKeyboard || current == this.mSymbolsKeyboardShifted) {
            next = this.mQwertyKeyboard;
        }
        if (next != null) {
            this.mKeyboardView.setKeyboard(next);
            this.mKeyboardState = 0;
        }
    }

    public void handleBackspace() {
        this.sendDownUpKeyEvents(67);
    }

    public void handleShift() {
        boolean isAlphaMode;
        if (this.mKeyboardView == null) {
            return;
        }
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        boolean bl = isAlphaMode = current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted;
        if (this.mKeyboardState == 0) {
            this.mKeyboardState = isAlphaMode ? 1 : 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 1) {
            this.mKeyboardState = 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 2) {
            this.mKeyboardState = 0;
            PasswordEntryKeyboard passwordEntryKeyboard = next = isAlphaMode ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
        }
        if (next != null) {
            if (next != current) {
                this.mKeyboardView.setKeyboard(next);
            }
            next.setShiftLocked(this.mKeyboardState == 2);
            this.mKeyboardView.setShifted(this.mKeyboardState != 0);
        }
    }

    public void handleCharacter(int primaryCode, int[] keyCodes) {
        if (this.mKeyboardView.isShifted() && primaryCode != 32 && primaryCode != 10) {
            primaryCode = Character.toUpperCase(primaryCode);
        }
        this.sendKeyEventsToTarget(primaryCode);
    }

    public void handleClose() {
    }

    public void onPress(int primaryCode) {
        if (this.mVibratePattern != null) {
            this.mVibrator.vibrate(this.mVibratePattern, -1);
        }
    }

    public void onRelease(int primaryCode) {
    }

    public void onText(CharSequence text) {
    }

    public void swipeDown() {
    }

    public void swipeLeft() {
    }

    public void swipeRight() {
    }

    public void swipeUp() {
    }
}

