/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserFactory {
    private static final String ENCODING = "UTF-8";
    public static final boolean LOG_PARSER = false;

    public static XmlPullParser create(File f) throws XmlPullParserException, FileNotFoundException {
        KXmlParser parser = ParserFactory.instantiateParser(f.getName());
        parser.setInput((InputStream)new FileInputStream(f), ENCODING);
        return parser;
    }

    public static XmlPullParser create(InputStream stream, String name) throws XmlPullParserException {
        KXmlParser parser = ParserFactory.instantiateParser(name);
        parser.setInput(stream, ENCODING);
        return parser;
    }

    private static KXmlParser instantiateParser(String name) throws XmlPullParserException {
        KXmlParser parser = name != null ? new CustomParser(name) : new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    private static class CustomParser
    extends KXmlParser {
        private final String mName;

        CustomParser(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

