/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListAdapter;
import android.widget.HeterogeneousExpandableList;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.impl.binding.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeExpandableAdapter
extends BaseAdapter
implements ExpandableListAdapter,
HeterogeneousExpandableList {
    private final List<ResourceReference> mGroupTypes = new ArrayList<ResourceReference>();
    private final List<ResourceReference> mChildrenTypes = new ArrayList<ResourceReference>();

    public FakeExpandableAdapter(ResourceReference adapterRef, AdapterBinding binding, IProjectCallback callback) {
        super(adapterRef, binding, callback);
        this.createItems((Iterable<DataBindingItem>)binding, binding.getItemCount(), binding.getRepeatCount(), this.mGroupTypes, 1);
    }

    private void createItems(Iterable<DataBindingItem> iterable, int itemCount, int repeatCount, List<ResourceReference> types, int depth) {
        int[] typeCount = new int[itemCount];
        for (int r = 0; r < repeatCount; ++r) {
            for (DataBindingItem dataBindingItem : iterable) {
                ResourceReference viewRef = dataBindingItem.getViewReference();
                int typeIndex = types.indexOf(viewRef);
                if (typeIndex == -1) {
                    typeIndex = types.size();
                    types.add(viewRef);
                }
                List children = dataBindingItem.getChildren();
                int count = dataBindingItem.getCount();
                if (children.size() > 0) {
                    count = 1;
                }
                int index = typeCount[typeIndex];
                int n = typeIndex;
                typeCount[n] = typeCount[n] + count;
                for (int k = 0; k < count; ++k) {
                    BaseAdapter.AdapterItem item = new BaseAdapter.AdapterItem(dataBindingItem, typeIndex, this.mItems.size(), index++);
                    this.mItems.add(item);
                    if (children.size() <= 0) continue;
                    this.createItems(dataBindingItem, depth + 1);
                }
            }
        }
    }

    private void createItems(DataBindingItem item, int depth) {
        if (depth == 2) {
            this.createItems((Iterable<DataBindingItem>)item, item.getChildren().size(), item.getCount(), this.mChildrenTypes, depth);
        }
    }

    private BaseAdapter.AdapterItem getChildItem(int groupPosition, int childPosition) {
        BaseAdapter.AdapterItem item = (BaseAdapter.AdapterItem)this.mItems.get(groupPosition);
        List<BaseAdapter.AdapterItem> children = item.getChildren();
        return children.get(childPosition);
    }

    @Override
    public int getGroupCount() {
        return this.mItems.size();
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        BaseAdapter.AdapterItem item = (BaseAdapter.AdapterItem)this.mItems.get(groupPosition);
        return item.getChildren().size();
    }

    @Override
    public Object getGroup(int groupPosition) {
        return this.mItems.get(groupPosition);
    }

    @Override
    public Object getChild(int groupPosition, int childPosition) {
        return this.getChildItem(groupPosition, childPosition);
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        BaseAdapter.AdapterItem item = (BaseAdapter.AdapterItem)this.mItems.get(groupPosition);
        return this.getView(item, null, convertView, parent);
    }

    @Override
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        BaseAdapter.AdapterItem parentItem = (BaseAdapter.AdapterItem)this.mItems.get(groupPosition);
        BaseAdapter.AdapterItem item = this.getChildItem(groupPosition, childPosition);
        return this.getView(item, parentItem, convertView, parent);
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public long getCombinedGroupId(long groupId) {
        return groupId << 16 | 0xFFFFL;
    }

    @Override
    public long getCombinedChildId(long groupId, long childId) {
        return groupId << 16 | childId;
    }

    @Override
    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public void onGroupCollapsed(int groupPosition) {
    }

    @Override
    public void onGroupExpanded(int groupPosition) {
    }

    @Override
    public int getChildType(int groupPosition, int childPosition) {
        return this.getChildItem(groupPosition, childPosition).getType();
    }

    @Override
    public int getChildTypeCount() {
        return this.mChildrenTypes.size();
    }

    @Override
    public int getGroupType(int groupPosition) {
        return ((BaseAdapter.AdapterItem)this.mItems.get(groupPosition)).getType();
    }

    @Override
    public int getGroupTypeCount() {
        return this.mGroupTypes.size();
    }
}

