/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseWeakArray<E> {
    private static final Object DELETED_REF = new Object();
    private static final WeakReference<?> DELETED = new WeakReference<Object>(DELETED_REF);
    private boolean mGarbage = false;
    private int[] mKeys;
    private WeakReference<?>[] mValues;
    private int mSize;

    public SparseWeakArray() {
        this(10);
    }

    public SparseWeakArray(int initialCapacity) {
        initialCapacity = ArrayUtils.idealIntArraySize(initialCapacity);
        this.mKeys = new int[initialCapacity];
        this.mValues = new WeakReference[initialCapacity];
        this.mSize = 0;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED || this.mValues[i].get() == null) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i].get();
    }

    public void delete(int key) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    public void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        WeakReference<?>[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            WeakReference<?> val = values[i];
            if (val == DELETED || val.get() == null) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
        int newSize = ArrayUtils.idealIntArraySize(this.mSize);
        if (newSize < this.mKeys.length) {
            int[] nkeys = new int[newSize];
            WeakReference[] nvalues = new WeakReference[newSize];
            System.arraycopy(this.mKeys, 0, nkeys, 0, newSize);
            System.arraycopy(this.mValues, 0, nvalues, 0, newSize);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
    }

    public void put(int key, E value) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = new WeakReference<E>(value);
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && (this.mValues[i] == DELETED || this.mValues[i].get() == null)) {
                this.mKeys[i] = key;
                this.mValues[i] = new WeakReference<E>(value);
                return;
            }
            if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
                this.gc();
                i = ~SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                WeakReference[] nvalues = new WeakReference[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = new WeakReference<E>(value);
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index].get();
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = new WeakReference<E>(value);
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int n = this.mSize;
        WeakReference<?>[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n = ArrayUtils.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n];
            WeakReference[] nvalues = new WeakReference[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = new WeakReference<E>(value);
        this.mSize = pos + 1;
    }

    private boolean hasReclaimedRefs() {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != null) continue;
            return true;
        }
        return false;
    }

    private static int binarySearch(int[] a, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a[high] == key) {
            return high;
        }
        return ~high;
    }
}

