/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import libcore.io.IoUtils;
import org.apache.harmony.luni.internal.util.TimezoneGetter;
import org.apache.harmony.luni.internal.util.ZoneInfo;

public class ZoneInfoDB {
    public static final String ZONE_DIRECTORY_NAME = System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/";
    public static final String ZONE_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.dat";
    public static final String INDEX_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.idx";
    public static final Object LOCK = new Object();
    public static final String VERSION = ZoneInfoDB.readVersion();
    public static String[] ids;
    public static int[] byteOffsets;
    public static int[] rawUtcOffsets;
    public static ByteBuffer mappedData;

    public static String readVersion() {
        String string2;
        RandomAccessFile versionFile = null;
        try {
            versionFile = new RandomAccessFile(ZONE_DIRECTORY_NAME + "zoneinfo.version", "r");
            byte[] buf = new byte[(int)versionFile.length()];
            versionFile.readFully(buf);
            string2 = new String(buf, 0, buf.length, Charsets.ISO_8859_1).trim();
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(versionFile);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(versionFile);
        return string2;
    }

    public static void readIndex() {
        RandomAccessFile indexFile = null;
        try {
            indexFile = new RandomAccessFile(INDEX_FILE_NAME, "r");
            int SIZEOF_TZNAME = 40;
            int SIZEOF_TZINT = 4;
            byte[] idBytes = new byte[40];
            int numEntries = (int)(indexFile.length() / 52L);
            char[] idChars = new char[numEntries * 40];
            int[] idEnd = new int[numEntries];
            int idOffset = 0;
            byteOffsets = new int[numEntries];
            rawUtcOffsets = new int[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                indexFile.readFully(idBytes);
                ZoneInfoDB.byteOffsets[i] = indexFile.readInt();
                int length = indexFile.readInt();
                if (length < 44) {
                    throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
                }
                ZoneInfoDB.rawUtcOffsets[i] = indexFile.readInt();
                int len = idBytes.length;
                for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                    idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
                }
                idEnd[i] = idOffset;
            }
            String allIds = new String(idChars, 0, idOffset);
            ids = new String[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                ZoneInfoDB.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
            }
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(indexFile);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(indexFile);
    }

    public static ByteBuffer mapData() {
        MappedByteBuffer mappedByteBuffer;
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(ZONE_FILE_NAME, "r");
            FileChannel channel = file.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            buffer.order(ByteOrder.BIG_ENDIAN);
            mappedByteBuffer = buffer;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(file);
        return mappedByteBuffer;
    }

    public static TimeZone makeTimeZone(String id2) throws IOException {
        int index = Arrays.binarySearch(ids, id2);
        if (index < 0) {
            return null;
        }
        int start = byteOffsets[index];
        ByteBuffer data = mappedData.duplicate();
        data.position(start);
        if (data.getInt() != 1415211366) {
            return null;
        }
        data.position(start + 32);
        int tzh_timecnt = data.getInt();
        int tzh_typecnt = data.getInt();
        int tzh_charcnt = data.getInt();
        int[] transitions = new int[tzh_timecnt];
        for (int i = 0; i < tzh_timecnt; ++i) {
            transitions[i] = data.getInt();
        }
        byte[] type = new byte[tzh_timecnt];
        data.get(type);
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        byte[] abbreviationIndexes = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = data.getInt();
            isDsts[i] = data.get();
            abbreviationIndexes[i] = data.get();
        }
        byte[] abbreviationList = new byte[tzh_charcnt];
        data.get(abbreviationList);
        return new ZoneInfo(id2, transitions, type, gmtOffsets, isDsts, abbreviationIndexes, abbreviationList);
    }

    public static String[] getAvailableIDs() {
        return (String[])ids.clone();
    }

    public static String[] getAvailableIDs(int rawOffset) {
        ArrayList<String> matches = new ArrayList<String>();
        int end = rawUtcOffsets.length;
        for (int i = 0; i < end; ++i) {
            if (rawUtcOffsets[i] != rawOffset) continue;
            matches.add(ids[i]);
        }
        return matches.toArray(new String[matches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone getSystemDefault() {
        Object object = LOCK;
        synchronized (object) {
            String zoneName;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            String string2 = zoneName = tzGetter != null ? tzGetter.getId() : null;
            if (zoneName != null) {
                zoneName = zoneName.trim();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                zoneName = "localtime";
            }
            return TimeZone.getTimeZone(zoneName);
        }
    }

    public static TimeZone getTimeZone(String id2) {
        if (id2 == null) {
            return null;
        }
        try {
            return ZoneInfoDB.makeTimeZone(id2);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    static {
        ZoneInfoDB.readIndex();
        mappedData = ZoneInfoDB.mapData();
    }
}

