/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.GeneralSecurityException;
import java.util.Hashtable;
import javax.crypto.Cipher;

public class CipherSuite {
    public boolean supported = true;
    public final int keyExchange;
    public final String authType;
    public final String cipherName;
    public final int keyMaterial;
    public final int expandedKeyMaterial;
    public final int effectiveKeyBytes;
    public final int ivSize;
    public final int blockSize;
    public final byte[] cipherSuiteCode;
    public final String name;
    public final boolean isExportable;
    public final String hashName;
    public final String hmacName;
    public final int hashSize;
    public static final int KEY_EXCHANGE_RSA = 1;
    public static final int KEY_EXCHANGE_RSA_EXPORT = 2;
    public static final int KEY_EXCHANGE_DHE_DSS = 3;
    public static final int KEY_EXCHANGE_DHE_DSS_EXPORT = 4;
    public static final int KEY_EXCHANGE_DHE_RSA = 5;
    public static final int KEY_EXCHANGE_DHE_RSA_EXPORT = 6;
    public static final int KEY_EXCHANGE_DH_DSS = 7;
    public static final int KEY_EXCHANGE_DH_RSA = 8;
    public static final int KEY_EXCHANGE_DH_anon = 9;
    public static final int KEY_EXCHANGE_DH_anon_EXPORT = 10;
    public static final int KEY_EXCHANGE_DH_DSS_EXPORT = 11;
    public static final int KEY_EXCHANGE_DH_RSA_EXPORT = 12;
    public static final byte[] CODE_SSL_NULL_WITH_NULL_NULL;
    public static final byte[] CODE_SSL_RSA_WITH_NULL_MD5;
    public static final byte[] CODE_SSL_RSA_WITH_NULL_SHA;
    public static final byte[] CODE_SSL_RSA_EXPORT_WITH_RC4_40_MD5;
    public static final byte[] CODE_SSL_RSA_WITH_RC4_128_MD5;
    public static final byte[] CODE_SSL_RSA_WITH_RC4_128_SHA;
    public static final byte[] CODE_SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5;
    public static final byte[] CODE_SSL_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final byte[] CODE_SSL_RSA_WITH_DES_CBC_SHA;
    public static final byte[] CODE_SSL_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_DSS_WITH_DES_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_RSA_WITH_DES_CBC_SHA;
    public static final byte[] CODE_SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final byte[] CODE_SSL_DH_anon_EXPORT_WITH_RC4_40_MD5;
    public static final byte[] CODE_SSL_DH_anon_WITH_RC4_128_MD5;
    public static final byte[] CODE_SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
    public static final byte[] CODE_SSL_DH_anon_WITH_DES_CBC_SHA;
    public static final byte[] CODE_SSL_DH_anon_WITH_3DES_EDE_CBC_SHA;
    public static final byte[] CODE_TLS_RSA_WITH_AES_128_CBC_SHA;
    public static final byte[] CODE_TLS_DHE_DSS_WITH_AES_128_CBC_SHA;
    public static final byte[] CODE_TLS_DHE_RSA_WITH_AES_128_CBC_SHA;
    public static final byte[] CODE_TLS_DH_anon_WITH_AES_128_CBC_SHA;
    public static final byte[] CODE_TLS_RSA_WITH_AES_256_CBC_SHA;
    public static final byte[] CODE_TLS_DHE_DSS_WITH_AES_256_CBC_SHA;
    public static final byte[] CODE_TLS_DHE_RSA_WITH_AES_256_CBC_SHA;
    public static final byte[] CODE_TLS_DH_anon_WITH_AES_256_CBC_SHA;
    public static final CipherSuite SSL_NULL_WITH_NULL_NULL;
    public static final CipherSuite SSL_RSA_WITH_NULL_MD5;
    public static final CipherSuite SSL_RSA_WITH_NULL_SHA;
    public static final CipherSuite SSL_RSA_EXPORT_WITH_RC4_40_MD5;
    public static final CipherSuite SSL_RSA_WITH_RC4_128_MD5;
    public static final CipherSuite SSL_RSA_WITH_RC4_128_SHA;
    public static final CipherSuite SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5;
    public static final CipherSuite SSL_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite SSL_RSA_WITH_DES_CBC_SHA;
    public static final CipherSuite SSL_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite SSL_DHE_DSS_WITH_DES_CBC_SHA;
    public static final CipherSuite SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite SSL_DHE_RSA_WITH_DES_CBC_SHA;
    public static final CipherSuite SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite SSL_DH_anon_EXPORT_WITH_RC4_40_MD5;
    public static final CipherSuite SSL_DH_anon_WITH_RC4_128_MD5;
    public static final CipherSuite SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite SSL_DH_anon_WITH_DES_CBC_SHA;
    public static final CipherSuite SSL_DH_anon_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA;
    public static final CipherSuite[] SUITES_BY_CODE;
    public static final Hashtable<String, CipherSuite> SUITES_BY_NAME;
    public static final CipherSuite[] SUPPORTED_CIPHER_SUITES;
    public static final String[] SUPPORTED_CIPHER_SUITE_NAMES;
    public static final CipherSuite[] DEFAULT_CIPHER_SUITES;

    public static CipherSuite getByName(String name) {
        return SUITES_BY_NAME.get(name);
    }

    public static CipherSuite getByCode(byte b1, byte b2) {
        if (b1 != 0 || (b2 & 0xFF) > SUITES_BY_CODE.length) {
            return new CipherSuite("UNKNOWN_" + b1 + "_" + b2, false, 0, null, null, null, new byte[]{b1, b2});
        }
        return SUITES_BY_CODE[b2];
    }

    public static CipherSuite getByCode(byte b1, byte b2, byte b3) {
        if (b1 == 0 && b2 == 0 && (b3 & 0xFF) <= SUITES_BY_CODE.length) {
            return SUITES_BY_CODE[b3];
        }
        return new CipherSuite("UNKNOWN_" + b1 + "_" + b2 + "_" + b3, false, 0, null, null, null, new byte[]{b1, b2, b3});
    }

    public CipherSuite(String name, boolean isExportable, int keyExchange, String authType, String cipherName, String hash, byte[] code) {
        this.name = name;
        this.keyExchange = keyExchange;
        this.authType = authType;
        this.isExportable = isExportable;
        if (cipherName == null) {
            this.cipherName = null;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.ivSize = 0;
            this.blockSize = 0;
        } else if ("RC4_40".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 5;
            this.ivSize = 0;
            this.blockSize = 0;
        } else if ("RC4_128".equals(cipherName)) {
            this.cipherName = "RC4";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.ivSize = 0;
            this.blockSize = 0;
        } else if ("DES40_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 5;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 5;
            this.ivSize = 8;
            this.blockSize = 8;
        } else if ("DES_CBC".equals(cipherName)) {
            this.cipherName = "DES/CBC/NoPadding";
            this.keyMaterial = 8;
            this.expandedKeyMaterial = 8;
            this.effectiveKeyBytes = 7;
            this.ivSize = 8;
            this.blockSize = 8;
        } else if ("3DES_EDE_CBC".equals(cipherName)) {
            this.cipherName = "DESede/CBC/NoPadding";
            this.keyMaterial = 24;
            this.expandedKeyMaterial = 24;
            this.effectiveKeyBytes = 24;
            this.ivSize = 8;
            this.blockSize = 8;
        } else if ("AES_128".equals(cipherName)) {
            this.cipherName = "AES/CBC/NoPadding";
            this.keyMaterial = 16;
            this.expandedKeyMaterial = 16;
            this.effectiveKeyBytes = 16;
            this.ivSize = 16;
            this.blockSize = 16;
        } else if ("AES_256".equals(cipherName)) {
            this.cipherName = "AES/CBC/NoPadding";
            this.keyMaterial = 32;
            this.expandedKeyMaterial = 32;
            this.effectiveKeyBytes = 32;
            this.ivSize = 16;
            this.blockSize = 16;
        } else {
            this.cipherName = cipherName;
            this.keyMaterial = 0;
            this.expandedKeyMaterial = 0;
            this.effectiveKeyBytes = 0;
            this.ivSize = 0;
            this.blockSize = 0;
        }
        if ("MD5".equals(hash)) {
            this.hmacName = "HmacMD5";
            this.hashName = "MD5";
            this.hashSize = 16;
        } else if ("SHA".equals(hash)) {
            this.hmacName = "HmacSHA1";
            this.hashName = "SHA-1";
            this.hashSize = 20;
        } else {
            this.hmacName = null;
            this.hashName = null;
            this.hashSize = 0;
        }
        this.cipherSuiteCode = code;
        if (this.cipherName != null) {
            try {
                Cipher.getInstance(this.cipherName);
            }
            catch (GeneralSecurityException e) {
                this.supported = false;
            }
        }
    }

    public boolean isAnonymous() {
        return this.keyExchange == 9 || this.keyExchange == 10;
    }

    public static CipherSuite[] getSupported() {
        return SUPPORTED_CIPHER_SUITES;
    }

    public static String[] getSupportedCipherSuiteNames() {
        return (String[])SUPPORTED_CIPHER_SUITE_NAMES.clone();
    }

    public String getName() {
        return this.name;
    }

    public byte[] toBytes() {
        return this.cipherSuiteCode;
    }

    public String toString() {
        return this.name + ": " + this.cipherSuiteCode[0] + " " + this.cipherSuiteCode[1];
    }

    public boolean equals(Object obj) {
        return obj instanceof CipherSuite && this.cipherSuiteCode[0] == ((CipherSuite)obj).cipherSuiteCode[0] && this.cipherSuiteCode[1] == ((CipherSuite)obj).cipherSuiteCode[1];
    }

    public String getBulkEncryptionAlgorithm() {
        return this.cipherName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getHmacName() {
        return this.hmacName;
    }

    public String getHashName() {
        return this.hashName;
    }

    public int getMACLength() {
        return this.hashSize;
    }

    public boolean isExportable() {
        return this.isExportable;
    }

    static {
        int i;
        int i2;
        CODE_SSL_NULL_WITH_NULL_NULL = new byte[]{0, 0};
        CODE_SSL_RSA_WITH_NULL_MD5 = new byte[]{0, 1};
        CODE_SSL_RSA_WITH_NULL_SHA = new byte[]{0, 2};
        CODE_SSL_RSA_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 3};
        CODE_SSL_RSA_WITH_RC4_128_MD5 = new byte[]{0, 4};
        CODE_SSL_RSA_WITH_RC4_128_SHA = new byte[]{0, 5};
        CODE_SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new byte[]{0, 6};
        CODE_SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 8};
        CODE_SSL_RSA_WITH_DES_CBC_SHA = new byte[]{0, 9};
        CODE_SSL_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 10};
        CODE_SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 17};
        CODE_SSL_DHE_DSS_WITH_DES_CBC_SHA = new byte[]{0, 18};
        CODE_SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 19};
        CODE_SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 20};
        CODE_SSL_DHE_RSA_WITH_DES_CBC_SHA = new byte[]{0, 21};
        CODE_SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 22};
        CODE_SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = new byte[]{0, 23};
        CODE_SSL_DH_anon_WITH_RC4_128_MD5 = new byte[]{0, 24};
        CODE_SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new byte[]{0, 25};
        CODE_SSL_DH_anon_WITH_DES_CBC_SHA = new byte[]{0, 26};
        CODE_SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = new byte[]{0, 27};
        CODE_TLS_RSA_WITH_AES_128_CBC_SHA = new byte[]{0, 47};
        CODE_TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new byte[]{0, 50};
        CODE_TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new byte[]{0, 51};
        CODE_TLS_DH_anon_WITH_AES_128_CBC_SHA = new byte[]{0, 52};
        CODE_TLS_RSA_WITH_AES_256_CBC_SHA = new byte[]{0, 53};
        CODE_TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new byte[]{0, 56};
        CODE_TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new byte[]{0, 57};
        CODE_TLS_DH_anon_WITH_AES_256_CBC_SHA = new byte[]{0, 58};
        SSL_NULL_WITH_NULL_NULL = new CipherSuite("SSL_NULL_WITH_NULL_NULL", true, 0, null, null, null, CODE_SSL_NULL_WITH_NULL_NULL);
        SSL_RSA_WITH_NULL_MD5 = new CipherSuite("SSL_RSA_WITH_NULL_MD5", true, 1, "RSA", null, "MD5", CODE_SSL_RSA_WITH_NULL_MD5);
        SSL_RSA_WITH_NULL_SHA = new CipherSuite("SSL_RSA_WITH_NULL_SHA", true, 1, "RSA", null, "SHA", CODE_SSL_RSA_WITH_NULL_SHA);
        SSL_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("SSL_RSA_EXPORT_WITH_RC4_40_MD5", true, 2, "RSA", "RC4_40", "MD5", CODE_SSL_RSA_EXPORT_WITH_RC4_40_MD5);
        SSL_RSA_WITH_RC4_128_MD5 = new CipherSuite("SSL_RSA_WITH_RC4_128_MD5", false, 1, "RSA", "RC4_128", "MD5", CODE_SSL_RSA_WITH_RC4_128_MD5);
        SSL_RSA_WITH_RC4_128_SHA = new CipherSuite("SSL_RSA_WITH_RC4_128_SHA", false, 1, "RSA", "RC4_128", "SHA", CODE_SSL_RSA_WITH_RC4_128_SHA);
        SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = new CipherSuite("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", true, 2, "RSA", "RC2_CBC_40", "MD5", CODE_SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5);
        SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", true, 2, "RSA", "DES40_CBC", "SHA", CODE_SSL_RSA_EXPORT_WITH_DES40_CBC_SHA);
        SSL_RSA_WITH_DES_CBC_SHA = new CipherSuite("SSL_RSA_WITH_DES_CBC_SHA", false, 1, "RSA", "DES_CBC", "SHA", CODE_SSL_RSA_WITH_DES_CBC_SHA);
        SSL_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_RSA_WITH_3DES_EDE_CBC_SHA", false, 1, "RSA", "3DES_EDE_CBC", "SHA", CODE_SSL_RSA_WITH_3DES_EDE_CBC_SHA);
        SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", true, 4, "DSA", "DES40_CBC", "SHA", CODE_SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
        SSL_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("SSL_DHE_DSS_WITH_DES_CBC_SHA", false, 3, "DSA", "DES_CBC", "SHA", CODE_SSL_DHE_DSS_WITH_DES_CBC_SHA);
        SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", false, 3, "DSA", "3DES_EDE_CBC", "SHA", CODE_SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", true, 6, "RSA", "DES40_CBC", "SHA", CODE_SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
        SSL_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("SSL_DHE_RSA_WITH_DES_CBC_SHA", false, 5, "RSA", "DES_CBC", "SHA", CODE_SSL_DHE_RSA_WITH_DES_CBC_SHA);
        SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", false, 5, "RSA", "3DES_EDE_CBC", "SHA", CODE_SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", true, 10, "DH", "RC4_40", "MD5", CODE_SSL_DH_anon_EXPORT_WITH_RC4_40_MD5);
        SSL_DH_anon_WITH_RC4_128_MD5 = new CipherSuite("SSL_DH_anon_WITH_RC4_128_MD5", false, 9, "DH", "RC4_128", "MD5", CODE_SSL_DH_anon_WITH_RC4_128_MD5);
        SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", true, 10, "DH", "DES40_CBC", "SHA", CODE_SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
        SSL_DH_anon_WITH_DES_CBC_SHA = new CipherSuite("SSL_DH_anon_WITH_DES_CBC_SHA", false, 9, "DH", "DES_CBC", "SHA", CODE_SSL_DH_anon_WITH_DES_CBC_SHA);
        SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = new CipherSuite("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", false, 9, "DH", "3DES_EDE_CBC", "SHA", CODE_SSL_DH_anon_WITH_3DES_EDE_CBC_SHA);
        TLS_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA", false, 1, "RSA", "AES_128", "SHA", CODE_TLS_RSA_WITH_AES_128_CBC_SHA);
        TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", false, 3, "DSA", "AES_128", "SHA", CODE_TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
        TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", false, 5, "RSA", "AES_128", "SHA", CODE_TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
        TLS_DH_anon_WITH_AES_128_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_AES_128_CBC_SHA", false, 9, "DH", "AES_128", "SHA", CODE_TLS_DH_anon_WITH_AES_128_CBC_SHA);
        TLS_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_RSA_WITH_AES_256_CBC_SHA", false, 1, "RSA", "AES_256", "SHA", CODE_TLS_RSA_WITH_AES_256_CBC_SHA);
        TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", false, 3, "DSA", "AES_256", "SHA", CODE_TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
        TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", false, 5, "RSA", "AES_256", "SHA", CODE_TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
        TLS_DH_anon_WITH_AES_256_CBC_SHA = new CipherSuite("TLS_DH_anon_WITH_AES_256_CBC_SHA", false, 9, "DH", "AES_256", "SHA", CODE_TLS_DH_anon_WITH_AES_256_CBC_SHA);
        SUITES_BY_CODE = new CipherSuite[]{SSL_NULL_WITH_NULL_NULL, SSL_RSA_WITH_NULL_MD5, SSL_RSA_WITH_NULL_SHA, SSL_RSA_EXPORT_WITH_RC4_40_MD5, SSL_RSA_WITH_RC4_128_MD5, SSL_RSA_WITH_RC4_128_SHA, null, null, SSL_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_RSA_WITH_DES_CBC_SHA, SSL_RSA_WITH_3DES_EDE_CBC_SHA, null, null, null, null, null, null, SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_DSS_WITH_DES_CBC_SHA, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_RSA_WITH_DES_CBC_SHA, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, SSL_DH_anon_EXPORT_WITH_RC4_40_MD5, SSL_DH_anon_WITH_RC4_128_MD5, SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA, SSL_DH_anon_WITH_DES_CBC_SHA, SSL_DH_anon_WITH_3DES_EDE_CBC_SHA, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, TLS_RSA_WITH_AES_128_CBC_SHA, null, null, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DH_anon_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_CBC_SHA, null, null, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DH_anon_WITH_AES_256_CBC_SHA};
        int count = 0;
        SUITES_BY_NAME = new Hashtable();
        for (i2 = 0; i2 < SUITES_BY_CODE.length; ++i2) {
            if (SUITES_BY_CODE[i2] == SSL_NULL_WITH_NULL_NULL || SUITES_BY_CODE[i2] == null) continue;
            SUITES_BY_NAME.put(SUITES_BY_CODE[i2].getName(), SUITES_BY_CODE[i2]);
            if (!CipherSuite.SUITES_BY_CODE[i2].supported) continue;
            ++count;
        }
        SUPPORTED_CIPHER_SUITES = new CipherSuite[count];
        SUPPORTED_CIPHER_SUITE_NAMES = new String[count];
        count = 0;
        for (i2 = 0; i2 < SUITES_BY_CODE.length; ++i2) {
            if (SUITES_BY_CODE[i2] == SSL_NULL_WITH_NULL_NULL || SUITES_BY_CODE[i2] == null || !CipherSuite.SUITES_BY_CODE[i2].supported) continue;
            CipherSuite.SUPPORTED_CIPHER_SUITES[count] = SUITES_BY_CODE[i2];
            CipherSuite.SUPPORTED_CIPHER_SUITE_NAMES[count] = SUPPORTED_CIPHER_SUITES[count].getName();
            ++count;
        }
        CipherSuite[] defaultCipherSuites = new CipherSuite[]{SSL_RSA_WITH_RC4_128_MD5, SSL_RSA_WITH_RC4_128_SHA, TLS_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, SSL_RSA_WITH_3DES_EDE_CBC_SHA, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, SSL_RSA_WITH_DES_CBC_SHA, SSL_DHE_RSA_WITH_DES_CBC_SHA, SSL_DHE_DSS_WITH_DES_CBC_SHA, SSL_RSA_EXPORT_WITH_RC4_40_MD5, SSL_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA};
        count = 0;
        for (i = 0; i < defaultCipherSuites.length; ++i) {
            if (!defaultCipherSuites[i].supported) continue;
            ++count;
        }
        DEFAULT_CIPHER_SUITES = new CipherSuite[count];
        count = 0;
        for (i = 0; i < defaultCipherSuites.length; ++i) {
            if (!defaultCipherSuites[i].supported) continue;
            CipherSuite.DEFAULT_CIPHER_SUITES[count++] = defaultCipherSuites[i];
        }
    }
}

