/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;

public class OpenSSLServerSocketImpl
extends SSLServerSocket {
    public final SSLParametersImpl sslParameters;
    public String[] enabledProtocols = NativeCrypto.getSupportedProtocols();
    public String[] enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    public String[] enabledCompressionMethods = NativeCrypto.getDefaultCompressionMethods();

    public OpenSSLServerSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.sslParameters = sslParameters;
    }

    public OpenSSLServerSocketImpl(int port, SSLParametersImpl sslParameters) throws IOException {
        super(port);
        this.sslParameters = sslParameters;
    }

    public OpenSSLServerSocketImpl(int port, int backlog, SSLParametersImpl sslParameters) throws IOException {
        super(port, backlog);
        this.sslParameters = sslParameters;
    }

    public OpenSSLServerSocketImpl(int port, int backlog, InetAddress iAddress, SSLParametersImpl sslParameters) throws IOException {
        super(port, backlog, iAddress);
        this.sslParameters = sslParameters;
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = NativeCrypto.checkEnabledProtocols(protocols);
    }

    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = NativeCrypto.checkEnabledCipherSuites(suites);
    }

    public String[] getSupportedCompressionMethods() {
        return NativeCrypto.getSupportedCompressionMethods();
    }

    public String[] getEnabledCompressionMethods() {
        return (String[])this.enabledCompressionMethods.clone();
    }

    public void setEnabledCompressionMethods(String[] methods) {
        this.enabledCompressionMethods = NativeCrypto.checkEnabledCompressionMethods(methods);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public void setUseClientMode(boolean mode) {
        this.sslParameters.setUseClientMode(mode);
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public Socket accept() throws IOException {
        if (!this.sslParameters.getUseClientMode()) {
            this.checkEnabledCipherSuites();
        }
        OpenSSLSocketImpl socket = new OpenSSLSocketImpl(this.sslParameters, (String[])this.enabledProtocols.clone(), (String[])this.enabledCipherSuites.clone(), (String[])this.enabledCompressionMethods.clone());
        this.implAccept(socket);
        return socket;
    }

    public void checkEnabledCipherSuites() throws SSLException {
        block5: for (String enabledCipherSuite : this.enabledCipherSuites) {
            CipherSuite cipherSuite = CipherSuite.getByName(enabledCipherSuite);
            int keyExchange = cipherSuite == null ? (enabledCipherSuite.contains("_RSA_") ? 1 : (enabledCipherSuite.contains("_DSS_") ? 7 : (enabledCipherSuite.contains("_anon_") ? 9 : -1))) : cipherSuite.keyExchange;
            switch (keyExchange) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 12: {
                    if (!this.checkForPrivateKey("RSA", RSAPrivateKey.class)) continue block5;
                    return;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    if (!this.checkForPrivateKey("DSA", DSAPrivateKey.class)) continue block5;
                    return;
                }
                case 9: 
                case 10: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        throw new SSLException("Could not find any key store entries to support the enabled cipher suites.");
    }

    public boolean checkForPrivateKey(String keyType, Class keyClass) {
        String alias = this.sslParameters.getKeyManager().chooseServerAlias(keyType, null, null);
        if (alias == null) {
            return false;
        }
        PrivateKey key = this.sslParameters.getKeyManager().getPrivateKey(alias);
        return key != null && keyClass.isAssignableFrom(key.getClass());
    }
}

