/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import libcore.base.Objects;
import org.apache.harmony.luni.util.TwoKeyHashMap;
import org.apache.harmony.xnet.provider.jsse.AbstractSessionContext;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;

public class OpenSSLSessionImpl
implements SSLSession {
    public long creationTime = 0L;
    public long lastAccessedTime = 0L;
    public final java.security.cert.X509Certificate[] localCertificates;
    public final java.security.cert.X509Certificate[] peerCertificates;
    public boolean isValid = true;
    public TwoKeyHashMap values = new TwoKeyHashMap();
    public volatile X509Certificate[] peerCertificateChain;
    public int sslSessionNativePointer;
    public String peerHost;
    public int peerPort = -1;
    public String cipherSuite;
    public String protocol;
    public String compressionMethod;
    public AbstractSessionContext sessionContext;
    public byte[] id;

    public OpenSSLSessionImpl(int sslSessionNativePointer, java.security.cert.X509Certificate[] localCertificates, java.security.cert.X509Certificate[] peerCertificates, String peerHost, int peerPort, AbstractSessionContext sessionContext) {
        this.sslSessionNativePointer = sslSessionNativePointer;
        this.localCertificates = localCertificates;
        this.peerCertificates = peerCertificates;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.sessionContext = sessionContext;
    }

    public OpenSSLSessionImpl(byte[] derData, String peerHost, int peerPort, java.security.cert.X509Certificate[] peerCertificates, AbstractSessionContext sessionContext) throws IOException {
        this(NativeCrypto.d2i_SSL_SESSION(derData), null, peerCertificates, peerHost, peerPort, sessionContext);
        if (this.sslSessionNativePointer == 0) {
            throw new IOException("Invalid session data");
        }
    }

    public byte[] getId() {
        if (this.id == null) {
            this.resetId();
        }
        return this.id;
    }

    public void resetId() {
        this.id = NativeCrypto.SSL_SESSION_session_id(this.sslSessionNativePointer);
    }

    public byte[] getEncoded() {
        return NativeCrypto.i2d_SSL_SESSION(this.sslSessionNativePointer);
    }

    public long getCreationTime() {
        if (this.creationTime == 0L) {
            this.creationTime = NativeCrypto.SSL_SESSION_get_time(this.sslSessionNativePointer);
        }
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime == 0L ? this.getCreationTime() : this.lastAccessedTime;
    }

    public int getApplicationBufferSize() {
        return SSLRecordProtocol.MAX_DATA_LENGTH;
    }

    public int getPacketBufferSize() {
        return SSLRecordProtocol.MAX_SSL_PACKET_SIZE;
    }

    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        X509Certificate[] result = this.peerCertificateChain;
        if (result == null) {
            result = this.createPeerCertificateChain();
            this.peerCertificateChain = result;
        }
        return result;
    }

    public X509Certificate[] createPeerCertificateChain() throws SSLPeerUnverifiedException {
        try {
            X509Certificate[] chain = new X509Certificate[this.peerCertificates.length];
            for (int i = 0; i < this.peerCertificates.length; ++i) {
                byte[] encoded = this.peerCertificates[i].getEncoded();
                chain[i] = X509Certificate.getInstance(encoded);
            }
            return chain;
        }
        catch (CertificateEncodingException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
        catch (CertificateException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.peerCertificates;
    }

    public void checkPeerCertificatesPresent() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null || this.peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            String name = NativeCrypto.SSL_SESSION_cipher(this.sslSessionNativePointer);
            this.cipherSuite = NativeCrypto.OPENSSL_TO_STANDARD_CIPHER_SUITES.get(name);
            if (this.cipherSuite == null) {
                this.cipherSuite = name;
            }
        }
        return this.cipherSuite;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = NativeCrypto.SSL_SESSION_get_version(this.sslSessionNativePointer);
        }
        return this.protocol;
    }

    public String getCompressionMethod() {
        if (this.compressionMethod == null) {
            this.compressionMethod = NativeCrypto.SSL_SESSION_compress_meth(this.sessionContext.sslCtxNativePointer, this.sslSessionNativePointer);
        }
        return this.compressionMethod;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sessionContext;
    }

    public boolean isValid() {
        AbstractSessionContext context = this.sessionContext;
        if (this.isValid && context != null && context.getSessionTimeout() != 0 && this.getCreationTime() + (long)(context.getSessionTimeout() * 1000) < System.currentTimeMillis()) {
            this.isValid = false;
        }
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
        this.sessionContext = null;
    }

    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        return this.values.get(name, AccessController.getContext());
    }

    public String[] getValueNames() {
        Vector v = new Vector();
        AccessControlContext current = AccessController.getContext();
        Set set = this.values.entrySet();
        for (Map.Entry o : set) {
            TwoKeyHashMap.Entry entry = (TwoKeyHashMap.Entry)o;
            AccessControlContext cont = (AccessControlContext)entry.getKey2();
            if (!Objects.equal(current, cont)) continue;
            v.add(entry.getKey1());
        }
        return v.toArray(new String[v.size()]);
    }

    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        Object old = this.values.put(name, AccessController.getContext(), value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        Object old = this.values.remove(name, AccessController.getContext());
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            NativeCrypto.SSL_SESSION_free(this.sslSessionNativePointer);
        }
        finally {
            super.finalize();
        }
    }
}

