/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.Appendable;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;
import org.apache.harmony.xnet.provider.jsse.SSLSocketImpl;

public class SSLSocketInputStream
extends InputStream {
    public final int size = SSLRecordProtocol.MAX_DATA_LENGTH;
    public byte[] buffer = new byte[this.size];
    public int pos;
    public int end;
    public final SSLSocketImpl owner;
    public boolean end_reached = false;
    public Adapter dataPoint = new Adapter(null);

    public SSLSocketInputStream(SSLSocketImpl owner) {
        this.owner = owner;
    }

    public void setEnd() {
        this.end_reached = true;
    }

    public int available() throws IOException {
        return this.end - this.pos;
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream was closed.");
        }
        while (this.pos == this.end) {
            if (this.end_reached) {
                return -1;
            }
            this.owner.needAppData();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        do {
            int read_b;
            if ((read_b = this.read()) == -1) {
                return i == 0 ? -1 : i;
            }
            b[off + i] = (byte)read_b;
        } while (this.available() != 0 && ++i < len);
        return i;
    }

    public long skip(long n) throws IOException {
        long i = 0L;
        int av = this.available();
        if ((long)av < n) {
            n = av;
        }
        while (i < n && this.read() != -1) {
            ++i;
        }
        return i;
    }

    public static class 1 {
    }

    public class Adapter
    implements Appendable {
        public Adapter() {
        }

        public void append(byte[] src) {
            int length = src.length;
            if (SSLSocketInputStream.this.size - (SSLSocketInputStream.this.end - SSLSocketInputStream.this.pos) < length) {
                throw new AlertException(80, new SSLException("Could not accept income app data."));
            }
            if (SSLSocketInputStream.this.end + length > SSLSocketInputStream.this.size) {
                System.arraycopy(SSLSocketInputStream.this.buffer, SSLSocketInputStream.this.pos, SSLSocketInputStream.this.buffer, 0, SSLSocketInputStream.this.end - SSLSocketInputStream.this.pos);
                SSLSocketInputStream.this.end -= SSLSocketInputStream.this.pos;
                SSLSocketInputStream.this.pos = 0;
            }
            System.arraycopy(src, 0, SSLSocketInputStream.this.buffer, SSLSocketInputStream.this.end, length);
            SSLSocketInputStream.this.end = SSLSocketInputStream.this.end + length;
        }

        public /* synthetic */ Adapter(1 x1) {
            this();
        }
    }
}

