/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.util.Log;
import java.lang.reflect.Method;

public class ObjectAnimator
extends ValueAnimator {
    public static final boolean DBG = false;
    public Object mTarget;
    public String mPropertyName;

    public void setPropertyName(String propertyName) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setPropertyName(propertyName);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(propertyName, valuesHolder);
        }
        this.mPropertyName = propertyName;
        this.mInitialized = false;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public Method getPropertyFunction(String prefix, Class valueType) {
        Method returnVal = null;
        String firstLetter = this.mPropertyName.substring(0, 1);
        String theRest = this.mPropertyName.substring(1);
        firstLetter = firstLetter.toUpperCase();
        String setterName = prefix + firstLetter + theRest;
        Class[] args = null;
        if (valueType != null) {
            args = new Class[]{valueType};
        }
        try {
            returnVal = this.mTarget.getClass().getMethod(setterName, args);
        }
        catch (NoSuchMethodException e) {
            Log.e("ObjectAnimator", "Couldn't find setter/getter for property " + this.mPropertyName + ": " + e);
        }
        return returnVal;
    }

    public ObjectAnimator() {
    }

    public ObjectAnimator(Object target, String propertyName) {
        this.mTarget = target;
        this.setPropertyName(propertyName);
    }

    public static ObjectAnimator ofInt(Object target, String propertyName, int ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setIntValues(values);
        return anim2;
    }

    public static ObjectAnimator ofFloat(Object target, String propertyName, float ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setFloatValues(values);
        return anim2;
    }

    public static ObjectAnimator ofObject(Object target, String propertyName, TypeEvaluator evaluator, Object ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object target, PropertyValuesHolder ... values) {
        ObjectAnimator anim2 = new ObjectAnimator();
        anim2.mTarget = target;
        anim2.setValues(values);
        return anim2;
    }

    public void setIntValues(int ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, values));
        } else {
            super.setIntValues(values);
        }
    }

    public void setFloatValues(float ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, values));
        } else {
            super.setFloatValues(values);
        }
    }

    public void setObjectValues(Object ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, null, values));
        } else {
            super.setObjectValues(values);
        }
    }

    public void start() {
        super.start();
    }

    public void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupSetterAndGetter(this.mTarget);
            }
            super.initAnimation();
        }
    }

    public ObjectAnimator setDuration(long duration) {
        super.setDuration(duration);
        return this;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    public void setTarget(Object target) {
        if (this.mTarget != target) {
            Object oldTarget = this.mTarget;
            this.mTarget = target;
            if (oldTarget != null && target != null && oldTarget.getClass() == target.getClass()) {
                return;
            }
            this.mInitialized = false;
        }
    }

    public void setupStartValues() {
        this.initAnimation();
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setupStartValue(this.mTarget);
        }
    }

    public void setupEndValues() {
        this.initAnimation();
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setupEndValue(this.mTarget);
        }
    }

    public void animateValue(float fraction2) {
        super.animateValue(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setAnimatedValue(this.mTarget);
        }
    }

    public ObjectAnimator clone() {
        ObjectAnimator anim2 = (ObjectAnimator)super.clone();
        return anim2;
    }
}

