/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.app.Activity;
import android.app.FragmentManager;
import android.app.Fragment_Delegate;
import android.app.LoaderManager;
import android.app.LoaderManagerImpl;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.DebugUtils;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;

public class Fragment
implements ComponentCallbacks,
View.OnCreateContextMenuListener {
    public static final HashMap<String, Class<?>> sClassMap = new HashMap();
    public static final int INITIALIZING = 0;
    public static final int CREATED = 1;
    public static final int ACTIVITY_CREATED = 2;
    public static final int STARTED = 3;
    public static final int RESUMED = 4;
    public int mState = 0;
    public Animator mAnimatingAway;
    public int mStateAfterAnimating;
    public Bundle mSavedFragmentState;
    public SparseArray<Parcelable> mSavedViewState;
    public int mIndex = -1;
    public String mWho;
    public Bundle mArguments;
    public Fragment mTarget;
    public int mTargetRequestCode;
    public boolean mAdded;
    public boolean mRemoving;
    public boolean mResumed;
    public boolean mFromLayout;
    public boolean mInLayout;
    public boolean mRestored;
    public int mBackStackNesting;
    public FragmentManager mFragmentManager;
    public Activity mImmediateActivity;
    public Activity mActivity;
    public int mFragmentId;
    public int mContainerId;
    public String mTag;
    public boolean mHidden;
    public boolean mRetainInstance;
    public boolean mRetaining;
    public boolean mHasMenu;
    public boolean mCalled;
    public int mNextAnim;
    public ViewGroup mContainer;
    public View mView;
    public LoaderManagerImpl mLoaderManager;
    public boolean mLoadersStarted;
    public boolean mCheckedForLoaderManager;

    @LayoutlibDelegate
    public static Fragment instantiate(Context context, String string2) {
        return Fragment_Delegate.instantiate(context, string2);
    }

    @LayoutlibDelegate
    public static Fragment instantiate(Context context, String string2, Bundle bundle) {
        return Fragment_Delegate.instantiate(context, string2, bundle);
    }

    public void restoreViewState() {
        if (this.mSavedViewState != null) {
            this.mView.restoreHierarchyState(this.mSavedViewState);
            this.mSavedViewState = null;
        }
    }

    public void setIndex(int index) {
        this.mIndex = index;
        this.mWho = "android:fragment:" + this.mIndex;
    }

    public void clearIndex() {
        this.mIndex = -1;
        this.mWho = null;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        DebugUtils.buildShortClassTag(this, sb);
        if (this.mIndex >= 0) {
            sb.append(" #");
            sb.append(this.mIndex);
        }
        if (this.mFragmentId != 0) {
            sb.append(" id=0x");
            sb.append(Integer.toHexString(this.mFragmentId));
        }
        if (this.mTag != null) {
            sb.append(" ");
            sb.append(this.mTag);
        }
        sb.append('}');
        return sb.toString();
    }

    public int getId() {
        return this.mFragmentId;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setArguments(Bundle args) {
        if (this.mIndex >= 0) {
            throw new IllegalStateException("Fragment already active");
        }
        this.mArguments = args;
    }

    public Bundle getArguments() {
        return this.mArguments;
    }

    public void setTargetFragment(Fragment fragment, int requestCode) {
        this.mTarget = fragment;
        this.mTargetRequestCode = requestCode;
    }

    public Fragment getTargetFragment() {
        return this.mTarget;
    }

    public int getTargetRequestCode() {
        return this.mTargetRequestCode;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public Resources getResources() {
        if (this.mActivity == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        return this.mActivity.getResources();
    }

    public CharSequence getText(int resId) {
        return this.getResources().getText(resId);
    }

    public String getString(int resId) {
        return this.getResources().getString(resId);
    }

    public String getString(int resId, Object ... formatArgs) {
        return this.getResources().getString(resId, formatArgs);
    }

    public FragmentManager getFragmentManager() {
        return this.mFragmentManager;
    }

    public boolean isAdded() {
        return this.mActivity != null && this.mAdded;
    }

    public boolean isRemoving() {
        return this.mRemoving;
    }

    public boolean isInLayout() {
        return this.mInLayout;
    }

    public boolean isResumed() {
        return this.mResumed;
    }

    public boolean isVisible() {
        return this.isAdded() && !this.isHidden() && this.mView != null && this.mView.getWindowToken() != null && this.mView.getVisibility() == 0;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public void onHiddenChanged(boolean hidden) {
    }

    public void setRetainInstance(boolean retain) {
        this.mRetainInstance = retain;
    }

    public boolean getRetainInstance() {
        return this.mRetainInstance;
    }

    public void setHasOptionsMenu(boolean hasMenu) {
        if (this.mHasMenu != hasMenu) {
            this.mHasMenu = hasMenu;
            if (this.isAdded() && !this.isHidden()) {
                this.mActivity.invalidateOptionsMenu();
            }
        }
    }

    public LoaderManager getLoaderManager() {
        if (this.mLoaderManager != null) {
            return this.mLoaderManager;
        }
        if (this.mActivity == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.mCheckedForLoaderManager = true;
        this.mLoaderManager = this.mActivity.getLoaderManager(this.mIndex, this.mLoadersStarted, true);
        return this.mLoaderManager;
    }

    public void startActivity(Intent intent) {
        if (this.mActivity == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.mActivity.startActivityFromFragment(this, intent, -1);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (this.mActivity == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.mActivity.startActivityFromFragment(this, intent, requestCode);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public LayoutInflater getLayoutInflater(Bundle savedInstanceState) {
        return this.mActivity.getLayoutInflater();
    }

    public void onInflate(AttributeSet attrs, Bundle savedInstanceState) {
        this.mCalled = true;
    }

    public void onAttach(Activity activity) {
        this.mCalled = true;
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return null;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.mCalled = true;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return null;
    }

    public View getView() {
        return this.mView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        this.mCalled = true;
    }

    public void onStart() {
        this.mCalled = true;
        if (!this.mLoadersStarted) {
            this.mLoadersStarted = true;
            if (!this.mCheckedForLoaderManager) {
                this.mCheckedForLoaderManager = true;
                this.mLoaderManager = this.mActivity.getLoaderManager(this.mIndex, this.mLoadersStarted, false);
            }
            if (this.mLoaderManager != null) {
                this.mLoaderManager.doStart();
            }
        }
    }

    public void onResume() {
        this.mCalled = true;
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mCalled = true;
    }

    public void onPause() {
        this.mCalled = true;
    }

    public void onStop() {
        this.mCalled = true;
    }

    public void onLowMemory() {
        this.mCalled = true;
    }

    public void onDestroyView() {
        this.mCalled = true;
    }

    public void onDestroy() {
        this.mCalled = true;
        if (!this.mCheckedForLoaderManager) {
            this.mCheckedForLoaderManager = true;
            this.mLoaderManager = this.mActivity.getLoaderManager(this.mIndex, this.mLoadersStarted, false);
        }
        if (this.mLoaderManager != null) {
            this.mLoaderManager.doDestroy();
        }
    }

    public void onDetach() {
        this.mCalled = true;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
    }

    public void onPrepareOptionsMenu(Menu menu2) {
    }

    public void onDestroyOptionsMenu() {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu2) {
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        this.getActivity().onCreateContextMenu(menu2, v, menuInfo);
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    public boolean onContextItemSelected(MenuItem item) {
        return false;
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.print("mFragmentId=#");
        writer.print(Integer.toHexString(this.mFragmentId));
        writer.print(" mContainerId#=");
        writer.print(Integer.toHexString(this.mContainerId));
        writer.print(" mTag=");
        writer.println(this.mTag);
        writer.print(prefix);
        writer.print("mState=");
        writer.print(this.mState);
        writer.print(" mIndex=");
        writer.print(this.mIndex);
        writer.print(" mWho=");
        writer.print(this.mWho);
        writer.print(" mBackStackNesting=");
        writer.println(this.mBackStackNesting);
        writer.print(prefix);
        writer.print("mAdded=");
        writer.print(this.mAdded);
        writer.print(" mRemoving=");
        writer.print(this.mRemoving);
        writer.print(" mResumed=");
        writer.print(this.mResumed);
        writer.print(" mFromLayout=");
        writer.print(this.mFromLayout);
        writer.print(" mInLayout=");
        writer.println(this.mInLayout);
        writer.print(prefix);
        writer.print("mHidden=");
        writer.print(this.mHidden);
        writer.print(" mRetainInstance=");
        writer.print(this.mRetainInstance);
        writer.print(" mRetaining=");
        writer.print(this.mRetaining);
        writer.print(" mHasMenu=");
        writer.println(this.mHasMenu);
        if (this.mFragmentManager != null) {
            writer.print(prefix);
            writer.print("mFragmentManager=");
            writer.println(this.mFragmentManager);
        }
        if (this.mImmediateActivity != null) {
            writer.print(prefix);
            writer.print("mImmediateActivity=");
            writer.println(this.mImmediateActivity);
        }
        if (this.mActivity != null) {
            writer.print(prefix);
            writer.print("mActivity=");
            writer.println(this.mActivity);
        }
        if (this.mArguments != null) {
            writer.print(prefix);
            writer.print("mArguments=");
            writer.println(this.mArguments);
        }
        if (this.mSavedFragmentState != null) {
            writer.print(prefix);
            writer.print("mSavedFragmentState=");
            writer.println(this.mSavedFragmentState);
        }
        if (this.mSavedViewState != null) {
            writer.print(prefix);
            writer.print("mSavedViewState=");
            writer.println(this.mSavedViewState);
        }
        if (this.mTarget != null) {
            writer.print(prefix);
            writer.print("mTarget=");
            writer.print(this.mTarget);
            writer.print(" mTargetRequestCode=");
            writer.println(this.mTargetRequestCode);
        }
        if (this.mNextAnim != 0) {
            writer.print(prefix);
            writer.print("mNextAnim=");
            writer.println(this.mNextAnim);
        }
        if (this.mContainer != null) {
            writer.print(prefix);
            writer.print("mContainer=");
            writer.println(this.mContainer);
        }
        if (this.mView != null) {
            writer.print(prefix);
            writer.print("mView=");
            writer.println(this.mView);
        }
        if (this.mAnimatingAway != null) {
            writer.print(prefix);
            writer.print("mAnimatingAway=");
            writer.println(this.mAnimatingAway);
            writer.print(prefix);
            writer.print("mStateAfterAnimating=");
            writer.println(this.mStateAfterAnimating);
        }
        if (this.mLoaderManager != null) {
            writer.print(prefix);
            writer.println("Loader Manager:");
            this.mLoaderManager.dump(prefix + "  ", fd, writer, args);
        }
    }

    public void performStop() {
        this.onStop();
        if (this.mLoadersStarted) {
            this.mLoadersStarted = false;
            if (!this.mCheckedForLoaderManager) {
                this.mCheckedForLoaderManager = true;
                this.mLoaderManager = this.mActivity.getLoaderManager(this.mIndex, this.mLoadersStarted, false);
            }
            if (this.mLoaderManager != null) {
                if (this.mActivity == null || !this.mActivity.mChangingConfigurations) {
                    this.mLoaderManager.doStop();
                } else {
                    this.mLoaderManager.doRetain();
                }
            }
        }
    }

    public static class InstantiationException
    extends AndroidRuntimeException {
        public InstantiationException(String msg, Exception cause) {
            super(msg, cause);
        }
    }
}

