/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class BackupManager {
    public static final String TAG = "BackupManager";
    public Context mContext;
    public static IBackupManager sService;

    public static void checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    public BackupManager(Context context) {
        this.mContext = context;
    }

    public void dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.d(TAG, "dataChanged() couldn't connect");
            }
        }
    }

    public static void dataChanged(String packageName) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                sService.dataChanged(packageName);
            }
            catch (RemoteException e) {
                Log.d(TAG, "dataChanged(pkg) couldn't connect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestRestore(RestoreObserver observer) {
        int result = -1;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            RestoreSession session = null;
            try {
                IRestoreSession binder = sService.beginRestoreSession(this.mContext.getPackageName(), null);
                session = new RestoreSession(this.mContext, binder);
                result = session.restorePackage(this.mContext.getPackageName(), observer);
            }
            catch (RemoteException e) {
                Log.w(TAG, "restoreSelf() unable to contact service");
            }
            finally {
                if (session != null) {
                    session.endRestoreSession();
                }
            }
        }
        return result;
    }

    public RestoreSession beginRestoreSession() {
        RestoreSession session = null;
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                IRestoreSession binder = sService.beginRestoreSession(null, null);
                session = new RestoreSession(this.mContext, binder);
            }
            catch (RemoteException e) {
                Log.w(TAG, "beginRestoreSession() couldn't connect");
            }
        }
        return session;
    }
}

