/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;

public class RestoreSession {
    public static final String TAG = "RestoreSession";
    public final Context mContext;
    public IRestoreSession mBinder;
    public RestoreObserverWrapper mObserver = null;

    public int getAvailableRestoreSets(RestoreObserver observer) {
        int err = -1;
        RestoreObserverWrapper obsWrapper = new RestoreObserverWrapper(this.mContext, observer);
        try {
            err = this.mBinder.getAvailableRestoreSets(obsWrapper);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Can't contact server to get available sets");
        }
        return err;
    }

    public int restoreAll(long token, RestoreObserver observer) {
        int err = -1;
        if (this.mObserver != null) {
            Log.d(TAG, "restoreAll() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this.mContext, observer);
        try {
            err = this.mBinder.restoreAll(token, this.mObserver);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Can't contact server to restore");
        }
        return err;
    }

    public int restorePackage(String packageName, RestoreObserver observer) {
        int err = -1;
        if (this.mObserver != null) {
            Log.d(TAG, "restorePackage() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this.mContext, observer);
        try {
            err = this.mBinder.restorePackage(packageName, this.mObserver);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Can't contact server to restore package");
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRestoreSession() {
        try {
            try {
                this.mBinder.endRestoreSession();
            }
            catch (RemoteException e) {
                Log.d(TAG, "Can't contact server to get available sets");
                Object var3_2 = null;
                this.mBinder = null;
            }
            Object var3_1 = null;
            this.mBinder = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mBinder = null;
            throw throwable;
        }
    }

    public RestoreSession(Context context, IRestoreSession binder) {
        this.mContext = context;
        this.mBinder = binder;
    }

    public class RestoreObserverWrapper
    extends IRestoreObserver.Stub {
        public final Handler mHandler;
        public final RestoreObserver mAppObserver;
        public static final int MSG_RESTORE_STARTING = 1;
        public static final int MSG_UPDATE = 2;
        public static final int MSG_RESTORE_FINISHED = 3;
        public static final int MSG_RESTORE_SETS_AVAILABLE = 4;

        public RestoreObserverWrapper(Context context, RestoreObserver appObserver) {
            this.mHandler = new Handler(context.getMainLooper()){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            RestoreObserverWrapper.this.mAppObserver.restoreStarting(msg.arg1);
                            break;
                        }
                        case 2: {
                            RestoreObserverWrapper.this.mAppObserver.onUpdate(msg.arg1, (String)msg.obj);
                            break;
                        }
                        case 3: {
                            RestoreObserverWrapper.this.mAppObserver.restoreFinished(msg.arg1);
                            break;
                        }
                        case 4: {
                            RestoreObserverWrapper.this.mAppObserver.restoreSetsAvailable((RestoreSet[])msg.obj);
                        }
                    }
                }
            };
            this.mAppObserver = appObserver;
        }

        public void restoreSetsAvailable(RestoreSet[] result) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, result));
        }

        public void restoreStarting(int numPackages) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, numPackages, 0));
        }

        public void onUpdate(int nowBeingRestored, String currentPackage) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, nowBeingRestored, 0, currentPackage));
        }

        public void restoreFinished(int error) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, error, 0));
        }
    }
}

