/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

public class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    public static final String TAG = "BulkCursor";
    public AbstractCursor.SelfContentObserver mObserverBridge;
    public IBulkCursor mBulkCursor;
    public int mCount;
    public String[] mColumns;
    public boolean mWantsAllOnMoveCalls;

    public void set(IBulkCursor bulkCursor) {
        this.mBulkCursor = bulkCursor;
        try {
            this.mCount = this.mBulkCursor.count();
            this.mWantsAllOnMoveCalls = this.mBulkCursor.getWantsAllOnMoveCalls();
            this.mColumns = this.mBulkCursor.getColumnNames();
            this.mRowIdColumnIndex = BulkCursorToCursorAdaptor.findRowIdColumnIndex(this.mColumns);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Setup failed because the remote process is dead");
        }
    }

    public void set(IBulkCursor bulkCursor, int count, int idIndex) {
        this.mBulkCursor = bulkCursor;
        this.mColumns = null;
        this.mCount = count;
        this.mRowIdColumnIndex = idIndex;
    }

    public static int findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    public synchronized IContentObserver getObserver() {
        if (this.mObserverBridge == null) {
            this.mObserverBridge = new AbstractCursor.SelfContentObserver(this);
        }
        return this.mObserverBridge.getContentObserver();
    }

    public int getCount() {
        return this.mCount;
    }

    public boolean onMove(int oldPosition, int newPosition) {
        try {
            if (this.mWindow != null) {
                if (newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                    this.mWindow = this.mBulkCursor.getWindow(newPosition);
                } else if (this.mWantsAllOnMoveCalls) {
                    this.mBulkCursor.onMove(newPosition);
                }
            } else {
                this.mWindow = this.mBulkCursor.getWindow(newPosition);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    public void deactivate() {
        super.deactivate();
        try {
            this.mBulkCursor.deactivate();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Remote process exception when deactivating");
        }
        this.mWindow = null;
    }

    public void close() {
        super.close();
        try {
            this.mBulkCursor.close();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Remote process exception when closing");
        }
        this.mWindow = null;
    }

    public boolean requery() {
        try {
            int oldCount = this.mCount;
            this.mCount = this.mBulkCursor.requery(this.getObserver(), new CursorWindow(false));
            if (this.mCount != -1) {
                this.mPos = -1;
                if (this.mWindow != null) {
                    this.mWindow.close();
                    this.mWindow = null;
                }
                super.requery();
                return true;
            }
            this.deactivate();
            return false;
        }
        catch (Exception ex) {
            Log.e(TAG, "Unable to requery because the remote process exception " + ex.getMessage());
            this.deactivate();
            return false;
        }
    }

    public String[] getColumnNames() {
        if (this.mColumns == null) {
            try {
                this.mColumns = this.mBulkCursor.getColumnNames();
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Unable to fetch column names because the remote process is dead");
                return null;
            }
        }
        return this.mColumns;
    }

    public Bundle getExtras() {
        try {
            return this.mBulkCursor.getExtras();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public Bundle respond(Bundle extras) {
        try {
            return this.mBulkCursor.respond(extras);
        }
        catch (RemoteException e) {
            Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", e);
            return Bundle.EMPTY;
        }
    }
}

