/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteDatabase;
import android.os.StrictMode;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteCompiledSql {
    public static final String TAG = "SQLiteCompiledSql";
    public final SQLiteDatabase mDatabase;
    public final int nHandle;
    public int nStatement = 0;
    public String mSqlStmt = null;
    public Throwable mStackTrace = null;
    public boolean mInUse = false;

    public SQLiteCompiledSql(SQLiteDatabase db, String sql) {
        db.verifyDbIsOpen();
        db.verifyLockOwner();
        this.mDatabase = db;
        this.mSqlStmt = sql;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = db.mNativeHandle;
        this.native_compile(sql);
    }

    public void releaseSqlStatement() {
        if (this.nStatement != 0) {
            this.mDatabase.finalizeStatementLater(this.nStatement);
            this.nStatement = 0;
        }
    }

    public synchronized boolean acquire() {
        if (this.mInUse) {
            return false;
        }
        this.mInUse = true;
        return true;
    }

    public synchronized void release() {
        this.mInUse = false;
    }

    public synchronized void releaseIfNotInUse() {
        if (!this.mInUse) {
            this.releaseSqlStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.nStatement == 0) {
                return;
            }
            if (this.mInUse && StrictMode.vmSqliteObjectLeaksEnabled()) {
                int len = this.mSqlStmt.length();
                StrictMode.onSqliteObjectLeaked("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: " + this.mSqlStmt.substring(0, len > 1000 ? 1000 : len), this.mStackTrace);
            }
            this.releaseSqlStatement();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SQLiteCompiledSql sQLiteCompiledSql = this;
        synchronized (sQLiteCompiledSql) {
            StringBuilder buff = new StringBuilder();
            buff.append(" nStatement=");
            buff.append(this.nStatement);
            buff.append(", mInUse=");
            buff.append(this.mInUse);
            buff.append(", db=");
            buff.append(this.mDatabase.getPath());
            buff.append(", db_connectionNum=");
            buff.append(this.mDatabase.mConnectionNum);
            buff.append(", sql=");
            int len = this.mSqlStmt.length();
            buff.append(this.mSqlStmt.substring(0, len > 100 ? 100 : len));
            return buff.toString();
        }
    }

    public void native_compile(String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteCompiledSql#native_compile(Ljava/lang/String;)V", true, this);
    }
}

