/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteProgram;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.BlockGuard;
import java.io.IOException;

public class SQLiteStatement
extends SQLiteProgram {
    public static final String TAG = "SQLiteStatement";
    public static final boolean READ = true;
    public static final boolean WRITE = false;
    public SQLiteDatabase mOrigDb;
    public int mState;
    public static final int TRANS_STARTED = 1;
    public static final int LOCK_ACQUIRED = 2;

    public SQLiteStatement(SQLiteDatabase db, String sql, Object[] bindArgs) {
        super(db, sql, bindArgs, false);
    }

    public void execute() {
        this.executeUpdateDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateDelete() {
        try {
            long timeStart = this.acquireAndLock(false);
            int numChanges = 0;
            if ((this.mStatementType & 0x20) > 0) {
                this.native_executeSql(this.mSql);
            } else {
                numChanges = this.native_execute();
            }
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            int n = numChanges;
            Object var6_4 = null;
            this.releaseAndUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseAndUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        try {
            long timeStart = this.acquireAndLock(false);
            long lastInsertedRowId = this.native_executeInsert();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            long l = lastInsertedRowId;
            Object var8_4 = null;
            this.releaseAndUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.releaseAndUnlock();
            throw throwable;
        }
    }

    public long simpleQueryForLong() {
        long l;
        try {
            long timeStart = this.acquireAndLock(true);
            long retValue = this.native_1x1_long();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            l = retValue;
            Object var8_5 = null;
        }
        catch (SQLiteDoneException e) {
            try {
                throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                this.releaseAndUnlock();
                throw throwable;
            }
        }
        this.releaseAndUnlock();
        return l;
    }

    public String simpleQueryForString() {
        String string2;
        try {
            long timeStart = this.acquireAndLock(true);
            String retValue = this.native_1x1_string();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            string2 = retValue;
            Object var6_5 = null;
        }
        catch (SQLiteDoneException e) {
            try {
                throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.releaseAndUnlock();
                throw throwable;
            }
        }
        this.releaseAndUnlock();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelFileDescriptor simpleQueryForBlobFileDescriptor() {
        try {
            ParcelFileDescriptor parcelFileDescriptor;
            try {
                long timeStart = this.acquireAndLock(true);
                ParcelFileDescriptor retValue = this.native_1x1_blob_ashmem();
                this.mDatabase.logTimeStat(this.mSql, timeStart);
                parcelFileDescriptor = retValue;
                Object var6_6 = null;
            }
            catch (IOException ex) {
                Log.e(TAG, "simpleQueryForBlobFileDescriptor() failed", ex);
                ParcelFileDescriptor parcelFileDescriptor2 = null;
                Object var6_7 = null;
                this.releaseAndUnlock();
                return parcelFileDescriptor2;
            }
            catch (SQLiteDoneException e) {
                throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
            }
            this.releaseAndUnlock();
            return parcelFileDescriptor;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseAndUnlock();
            throw throwable;
        }
    }

    public long acquireAndLock(boolean rwFlag) {
        this.mState = 0;
        this.mDatabase.verifyDbIsOpen();
        SQLiteDatabase db = (this.mStatementType & 0x40) > 0 ? this.mDatabase.getDbConnection(this.mSql) : this.mDatabase;
        this.mOrigDb = this.mDatabase;
        this.mDatabase = db;
        this.setNativeHandle(this.mDatabase.mNativeHandle);
        if (!rwFlag) {
            BlockGuard.getThreadPolicy().onWriteToDisk();
        } else {
            BlockGuard.getThreadPolicy().onReadFromDisk();
        }
        if ((this.mStatementType & 0xF) == 4) {
            if (!this.mDatabase.isDbLockedByCurrentThread()) {
                this.mDatabase.setTransactionUsingExecSqlFlag();
            }
        } else if ((this.mStatementType & 0xF) == 2 && !this.mDatabase.inTransaction()) {
            this.mDatabase.beginTransactionNonExclusive();
            this.mState = 1;
        }
        if (!this.mDatabase.isDbLockedByCurrentThread()) {
            this.mDatabase.lock();
            this.mState = 2;
        }
        this.acquireReference();
        long startTime = SystemClock.uptimeMillis();
        this.mDatabase.closePendingStatements();
        this.compileAndbindAllArgs();
        return startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAndUnlock() {
        this.releaseReference();
        if (this.mState == 1) {
            try {
                this.mDatabase.setTransactionSuccessful();
                Object var2_1 = null;
                this.mDatabase.endTransaction();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.mDatabase.endTransaction();
                throw throwable;
            }
        } else if (this.mState == 2) {
            this.mDatabase.unlock();
        }
        if ((this.mStatementType & 0xF) == 5 || (this.mStatementType & 0xF) == 6) {
            this.mDatabase.resetTransactionUsingExecSqlFlag();
        }
        this.clearBindings();
        this.release();
        this.mDatabase = this.mOrigDb;
        this.setNativeHandle(this.mDatabase.mNativeHandle);
    }

    public int native_execute() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteStatement#native_execute()I", true, this);
    }

    public long native_executeInsert() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteStatement#native_executeInsert()J", true, this);
    }

    public long native_1x1_long() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteStatement#native_1x1_long()J", true, this);
    }

    public String native_1x1_string() {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteStatement#native_1x1_string()Ljava/lang/String;", true, this);
    }

    public ParcelFileDescriptor native_1x1_blob_ashmem() throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.database.sqlite.SQLiteStatement#native_1x1_blob_ashmem()Landroid/os/ParcelFileDescriptor;", true, this);
    }

    public void native_executeSql(String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteStatement#native_executeSql(Ljava/lang/String;)V", true, this);
    }
}

