/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap_Delegate;
import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class BitmapShader_Delegate
extends Shader_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    public boolean isSupported() {
        return true;
    }

    public String getSupportMessage() {
        return null;
    }

    @LayoutlibDelegate
    static int nativeCreate(int n, int n2, int n3) {
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n);
        if (bitmap_Delegate == null) {
            return 0;
        }
        BitmapShader_Delegate bitmapShader_Delegate = new BitmapShader_Delegate(bitmap_Delegate.getImage(), Shader_Delegate.getTileMode(n2), Shader_Delegate.getTileMode(n3));
        return sManager.addNewDelegate(bitmapShader_Delegate);
    }

    @LayoutlibDelegate
    static int nativePostCreate(int n, int n2, int n3, int n4) {
        return 0;
    }

    private BitmapShader_Delegate(BufferedImage bufferedImage, Shader.TileMode tileMode, Shader.TileMode tileMode2) {
        this.mJavaPaint = new BitmapShaderPaint(bufferedImage, tileMode, tileMode2);
    }

    private class BitmapShaderPaint
    implements Paint {
        private final BufferedImage mImage;
        private final Shader.TileMode mTileModeX;
        private final Shader.TileMode mTileModeY;

        BitmapShaderPaint(BufferedImage bufferedImage, Shader.TileMode tileMode, Shader.TileMode tileMode2) {
            this.mImage = bufferedImage;
            this.mTileModeX = tileMode;
            this.mTileModeY = tileMode2;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            AffineTransform affineTransform2;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in BitmapShader", (Throwable)noninvertibleTransformException, null);
                affineTransform2 = new AffineTransform();
            }
            AffineTransform affineTransform3 = BitmapShader_Delegate.this.getLocalMatrix();
            try {
                affineTransform3 = affineTransform3.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in BitmapShader", (Throwable)noninvertibleTransformException, null);
                affineTransform3 = new AffineTransform();
            }
            return new BitmapShaderContext(affineTransform2, affineTransform3, colorModel);
        }

        private int getColor(float f, float f2) {
            int n = this.getCoordinate(Math.round(f), this.mImage.getWidth(), this.mTileModeX);
            int n2 = this.getCoordinate(Math.round(f2), this.mImage.getHeight(), this.mTileModeY);
            return this.mImage.getRGB(n, n2);
        }

        private int getCoordinate(int n, int n2, Shader.TileMode tileMode) {
            if (n < 0) {
                switch (tileMode) {
                    case CLAMP: {
                        n = 0;
                        break;
                    }
                    case REPEAT: {
                        n = n2 - 1 - -n % n2;
                        break;
                    }
                    case MIRROR: {
                        n = -n;
                        int n3 = n / n2;
                        n %= n2;
                        if (n3 % 2 != 1) break;
                        n = n2 - 1 - n;
                    }
                }
            } else if (n >= n2) {
                switch (tileMode) {
                    case CLAMP: {
                        n = n2 - 1;
                        break;
                    }
                    case REPEAT: {
                        n %= n2;
                        break;
                    }
                    case MIRROR: {
                        int n4 = n / n2;
                        n %= n2;
                        if (n4 % 2 != 1) break;
                        n = n2 - 1 - n;
                    }
                }
            }
            return n;
        }

        public int getTransparency() {
            return 3;
        }

        private class BitmapShaderContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            public BitmapShaderContext(AffineTransform affineTransform, AffineTransform affineTransform2, ColorModel colorModel) {
                this.mCanvasMatrix = affineTransform;
                this.mLocalMatrix = affineTransform2;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int n, int n2, int n3, int n4) {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                int[] nArray = new int[n3 * n4];
                int n5 = 0;
                float[] fArray = new float[2];
                float[] fArray2 = new float[2];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        fArray[0] = n + j;
                        fArray[1] = n2 + i;
                        this.mCanvasMatrix.transform(fArray, 0, fArray2, 0, 1);
                        fArray[0] = fArray2[0];
                        fArray[1] = fArray2[1];
                        this.mLocalMatrix.transform(fArray, 0, fArray2, 0, 1);
                        nArray[n5++] = BitmapShaderPaint.this.getColor(fArray2[0], fArray2[1]);
                    }
                }
                bufferedImage.setRGB(0, 0, n3, n4, nArray, 0, n3);
                return bufferedImage.getRaster();
            }
        }
    }
}

