/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;

public class DrawableContainer
extends Drawable
implements Drawable.Callback {
    public static final boolean DEBUG = false;
    public static final String TAG = "DrawableContainer";
    public static final boolean DEFAULT_DITHER = true;
    public DrawableContainerState mDrawableContainerState;
    public Drawable mCurrDrawable;
    public int mAlpha = 255;
    public ColorFilter mColorFilter;
    public int mCurIndex = -1;
    public boolean mMutated;
    public Runnable mAnimationRunnable;
    public long mEnterAnimationEnd;
    public long mExitAnimationEnd;
    public Drawable mLastDrawable;

    public void draw(Canvas canvas) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.draw(canvas);
        }
        if (this.mLastDrawable != null) {
            this.mLastDrawable.draw(canvas);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mDrawableContainerState.mChangingConfigurations | this.mDrawableContainerState.mChildrenChangingConfigurations;
    }

    public boolean getPadding(Rect padding) {
        Rect r = this.mDrawableContainerState.getConstantPadding();
        if (r != null) {
            padding.set(r);
            return true;
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getPadding(padding);
        }
        return super.getPadding(padding);
    }

    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            if (this.mCurrDrawable != null) {
                if (this.mEnterAnimationEnd == 0L) {
                    this.mCurrDrawable.setAlpha(alpha);
                } else {
                    this.animate(false);
                }
            }
        }
    }

    public void setDither(boolean dither) {
        if (this.mDrawableContainerState.mDither != dither) {
            this.mDrawableContainerState.mDither = dither;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setDither(this.mDrawableContainerState.mDither);
            }
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter != cf) {
            this.mColorFilter = cf;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setColorFilter(cf);
            }
        }
    }

    public void setEnterFadeDuration(int ms) {
        this.mDrawableContainerState.mEnterFadeDuration = ms;
    }

    public void setExitFadeDuration(int ms) {
        this.mDrawableContainerState.mExitFadeDuration = ms;
    }

    public void onBoundsChange(Rect bounds) {
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setBounds(bounds);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setBounds(bounds);
        }
    }

    public boolean isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    public void jumpToCurrentState() {
        boolean changed = false;
        if (this.mLastDrawable != null) {
            this.mLastDrawable.jumpToCurrentState();
            this.mLastDrawable = null;
            changed = true;
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.jumpToCurrentState();
        }
        if (this.mExitAnimationEnd != 0L) {
            this.mExitAnimationEnd = 0L;
            changed = true;
        }
        if (this.mEnterAnimationEnd != 0L) {
            this.mEnterAnimationEnd = 0L;
            changed = true;
        }
        if (changed) {
            this.invalidateSelf();
        }
    }

    public boolean onStateChange(int[] state) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setState(state);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setState(state);
        }
        return false;
    }

    public boolean onLevelChange(int level) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setLevel(level);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setLevel(level);
        }
        return false;
    }

    public int getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicWidth() : -1;
    }

    public int getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicHeight() : -1;
    }

    public int getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumWidth() : 0;
    }

    public int getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumHeight() : 0;
    }

    public void invalidateDrawable(Drawable who) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setVisible(visible, restart);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    public int getOpacity() {
        return this.mCurrDrawable == null || !this.mCurrDrawable.isVisible() ? -2 : this.mDrawableContainerState.getOpacity();
    }

    public boolean selectDrawable(int idx) {
        if (idx == this.mCurIndex) {
            return false;
        }
        long now = SystemClock.uptimeMillis();
        if (this.mDrawableContainerState.mExitFadeDuration > 0) {
            if (this.mLastDrawable != null) {
                this.mLastDrawable.setVisible(false, false);
            }
            if (this.mCurrDrawable != null) {
                this.mLastDrawable = this.mCurrDrawable;
                this.mExitAnimationEnd = now + (long)this.mDrawableContainerState.mExitFadeDuration;
            } else {
                this.mLastDrawable = null;
                this.mExitAnimationEnd = 0L;
            }
        } else if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(false, false);
        }
        if (idx >= 0 && idx < this.mDrawableContainerState.mNumChildren) {
            Drawable d;
            this.mCurrDrawable = d = this.mDrawableContainerState.mDrawables[idx];
            this.mCurIndex = idx;
            if (d != null) {
                if (this.mDrawableContainerState.mEnterFadeDuration > 0) {
                    this.mEnterAnimationEnd = now + (long)this.mDrawableContainerState.mEnterFadeDuration;
                } else {
                    d.setAlpha(this.mAlpha);
                }
                d.setVisible(this.isVisible(), true);
                d.setDither(this.mDrawableContainerState.mDither);
                d.setColorFilter(this.mColorFilter);
                d.setState(this.getState());
                d.setLevel(this.getLevel());
                d.setBounds(this.getBounds());
            }
        } else {
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        if (this.mEnterAnimationEnd != 0L || this.mExitAnimationEnd != 0L) {
            if (this.mAnimationRunnable == null) {
                this.mAnimationRunnable = new Runnable(){

                    public void run() {
                        DrawableContainer.this.animate(true);
                        DrawableContainer.this.invalidateSelf();
                    }
                };
            } else {
                this.unscheduleSelf(this.mAnimationRunnable);
            }
            this.animate(true);
        }
        this.invalidateSelf();
        return true;
    }

    public void animate(boolean schedule) {
        int animAlpha;
        long now = SystemClock.uptimeMillis();
        boolean animating = false;
        if (this.mCurrDrawable != null) {
            if (this.mEnterAnimationEnd != 0L) {
                if (this.mEnterAnimationEnd <= now) {
                    this.mCurrDrawable.setAlpha(this.mAlpha);
                    this.mEnterAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mEnterAnimationEnd - now) * 255L) / this.mDrawableContainerState.mEnterFadeDuration;
                    this.mCurrDrawable.setAlpha((255 - animAlpha) * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mEnterAnimationEnd = 0L;
        }
        if (this.mLastDrawable != null) {
            if (this.mExitAnimationEnd != 0L) {
                if (this.mExitAnimationEnd <= now) {
                    this.mLastDrawable.setVisible(false, false);
                    this.mLastDrawable = null;
                    this.mExitAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mExitAnimationEnd - now) * 255L) / this.mDrawableContainerState.mExitFadeDuration;
                    this.mLastDrawable.setAlpha(animAlpha * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mExitAnimationEnd = 0L;
        }
        if (schedule && animating) {
            this.scheduleSelf(this.mAnimationRunnable, now + 16L);
        }
    }

    public Drawable getCurrent() {
        return this.mCurrDrawable;
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mDrawableContainerState.canConstantState()) {
            this.mDrawableContainerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mDrawableContainerState;
        }
        return null;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int N = this.mDrawableContainerState.getChildCount();
            Drawable[] drawables = this.mDrawableContainerState.getChildren();
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    public void setConstantState(DrawableContainerState state) {
        this.mDrawableContainerState = state;
    }

    public static abstract class DrawableContainerState
    extends Drawable.ConstantState {
        public final DrawableContainer mOwner;
        public int mChangingConfigurations;
        public int mChildrenChangingConfigurations;
        public Drawable[] mDrawables;
        public int mNumChildren;
        public boolean mVariablePadding = false;
        public Rect mConstantPadding = null;
        public boolean mConstantSize = false;
        public boolean mComputedConstantSize = false;
        public int mConstantWidth;
        public int mConstantHeight;
        public int mConstantMinimumWidth;
        public int mConstantMinimumHeight;
        public boolean mHaveOpacity = false;
        public int mOpacity;
        public boolean mHaveStateful = false;
        public boolean mStateful;
        public boolean mCheckedConstantState;
        public boolean mCanConstantState;
        public boolean mPaddingChecked = false;
        public boolean mDither = true;
        public int mEnterFadeDuration;
        public int mExitFadeDuration;

        public DrawableContainerState(DrawableContainerState orig, DrawableContainer owner, Resources res) {
            this.mOwner = owner;
            if (orig != null) {
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                Drawable[] origDr = orig.mDrawables;
                this.mDrawables = new Drawable[origDr.length];
                int N = this.mNumChildren = orig.mNumChildren;
                for (int i = 0; i < N; ++i) {
                    this.mDrawables[i] = res != null ? origDr[i].getConstantState().newDrawable(res) : origDr[i].getConstantState().newDrawable();
                    this.mDrawables[i].setCallback(owner);
                }
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
                this.mVariablePadding = orig.mVariablePadding;
                if (orig.mConstantPadding != null) {
                    this.mConstantPadding = new Rect(orig.mConstantPadding);
                }
                this.mConstantSize = orig.mConstantSize;
                this.mComputedConstantSize = orig.mComputedConstantSize;
                this.mConstantWidth = orig.mConstantWidth;
                this.mConstantHeight = orig.mConstantHeight;
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveStateful = orig.mHaveStateful;
                this.mStateful = orig.mStateful;
                this.mDither = orig.mDither;
                this.mEnterFadeDuration = orig.mEnterFadeDuration;
                this.mExitFadeDuration = orig.mExitFadeDuration;
            } else {
                this.mDrawables = new Drawable[10];
                this.mNumChildren = 0;
                this.mCanConstantState = false;
                this.mCheckedConstantState = false;
            }
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public int addChild(Drawable dr) {
            int pos = this.mNumChildren;
            if (pos >= this.mDrawables.length) {
                this.growArray(pos, pos + 10);
            }
            dr.setVisible(false, true);
            dr.setCallback(this.mOwner);
            this.mDrawables[pos] = dr;
            ++this.mNumChildren;
            this.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
            this.mHaveOpacity = false;
            this.mHaveStateful = false;
            this.mConstantPadding = null;
            this.mPaddingChecked = false;
            this.mComputedConstantSize = false;
            return pos;
        }

        public int getChildCount() {
            return this.mNumChildren;
        }

        public Drawable[] getChildren() {
            return this.mDrawables;
        }

        public void setVariablePadding(boolean variable) {
            this.mVariablePadding = variable;
        }

        public Rect getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null || this.mPaddingChecked) {
                return this.mConstantPadding;
            }
            Rect r = null;
            Rect t = new Rect();
            int N = this.getChildCount();
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (!drawables[i].getPadding(t)) continue;
                if (r == null) {
                    r = new Rect(0, 0, 0, 0);
                }
                if (t.left > r.left) {
                    r.left = t.left;
                }
                if (t.top > r.top) {
                    r.top = t.top;
                }
                if (t.right > r.right) {
                    r.right = t.right;
                }
                if (t.bottom <= r.bottom) continue;
                r.bottom = t.bottom;
            }
            this.mPaddingChecked = true;
            this.mConstantPadding = r;
            return this.mConstantPadding;
        }

        public void setConstantSize(boolean constant) {
            this.mConstantSize = constant;
        }

        public boolean isConstantSize() {
            return this.mConstantSize;
        }

        public int getConstantWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        public int getConstantHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        public int getConstantMinimumWidth() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        public int getConstantMinimumHeight() {
            if (!this.mComputedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        public void computeConstantSize() {
            this.mComputedConstantSize = true;
            int N = this.getChildCount();
            Drawable[] drawables = this.mDrawables;
            this.mConstantHeight = -1;
            this.mConstantWidth = -1;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            for (int i = 0; i < N; ++i) {
                Drawable dr = drawables[i];
                int s = dr.getIntrinsicWidth();
                if (s > this.mConstantWidth) {
                    this.mConstantWidth = s;
                }
                if ((s = dr.getIntrinsicHeight()) > this.mConstantHeight) {
                    this.mConstantHeight = s;
                }
                if ((s = dr.getMinimumWidth()) > this.mConstantMinimumWidth) {
                    this.mConstantMinimumWidth = s;
                }
                if ((s = dr.getMinimumHeight()) <= this.mConstantMinimumHeight) continue;
                this.mConstantMinimumHeight = s;
            }
        }

        public void setEnterFadeDuration(int duration) {
            this.mEnterFadeDuration = duration;
        }

        public int getEnterFadeDuration() {
            return this.mEnterFadeDuration;
        }

        public void setExitFadeDuration(int duration) {
            this.mExitFadeDuration = duration;
        }

        public int getExitFadeDuration() {
            return this.mExitFadeDuration;
        }

        public int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            int N = this.getChildCount();
            Drawable[] drawables = this.mDrawables;
            int op = N > 0 ? drawables[0].getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, drawables[i].getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        public boolean isStateful() {
            if (this.mHaveStateful) {
                return this.mStateful;
            }
            boolean stateful = false;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!this.mDrawables[i].isStateful()) continue;
                stateful = true;
                break;
            }
            this.mStateful = stateful;
            this.mHaveStateful = true;
            return stateful;
        }

        public void growArray(int oldSize, int newSize) {
            Drawable[] newDrawables = new Drawable[newSize];
            System.arraycopy(this.mDrawables, 0, newDrawables, 0, oldSize);
            this.mDrawables = newDrawables;
        }

        public synchronized boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = true;
                int N = this.mNumChildren;
                for (int i = 0; i < N; ++i) {
                    if (this.mDrawables[i].getConstantState() != null) continue;
                    this.mCanConstantState = false;
                    break;
                }
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

