/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManager;

public class SoftInputWindow
extends Dialog {
    public final KeyEvent.DispatcherState mDispatcherState;
    public final Rect mBounds = new Rect();

    public void setToken(IBinder token) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.token = token;
        this.getWindow().setAttributes(lp);
    }

    public SoftInputWindow(Context context, int theme, KeyEvent.DispatcherState dispatcherState) {
        super(context, theme);
        this.mDispatcherState = dispatcherState;
        this.initDockWindow();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mDispatcherState.reset();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.getWindow().getDecorView().getHitRect(this.mBounds);
        MotionEvent event = SoftInputWindow.clipMotionEvent(ev, this.mBounds);
        return super.dispatchTouchEvent(event);
    }

    public int getSize() {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        if (lp.gravity == 48 || lp.gravity == 80) {
            return lp.height;
        }
        return lp.width;
    }

    public void setSize(int size) {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        if (lp.gravity == 48 || lp.gravity == 80) {
            lp.width = -1;
            lp.height = size;
        } else {
            lp.width = size;
            lp.height = -1;
        }
        this.getWindow().setAttributes(lp);
    }

    public void setGravity(int gravity) {
        boolean newIsVertical;
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        boolean oldIsVertical = lp.gravity == 48 || lp.gravity == 80;
        lp.gravity = gravity;
        boolean bl = newIsVertical = lp.gravity == 48 || lp.gravity == 80;
        if (oldIsVertical != newIsVertical) {
            int tmp = lp.width;
            lp.width = lp.height;
            lp.height = tmp;
            this.getWindow().setAttributes(lp);
        }
    }

    public void initDockWindow() {
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.type = 2011;
        lp.setTitle("InputMethod");
        lp.gravity = 80;
        lp.width = -1;
        this.getWindow().setAttributes(lp);
        this.getWindow().setFlags(264, 266);
    }

    public static MotionEvent clipMotionEvent(MotionEvent me, Rect bounds) {
        int pointerCount = me.getPointerCount();
        boolean shouldClip = false;
        for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            int y;
            int x = (int)me.getX(pointerIndex);
            if (bounds.contains(x, y = (int)me.getY(pointerIndex))) continue;
            shouldClip = true;
            break;
        }
        if (!shouldClip) {
            return me;
        }
        if (pointerCount == 1) {
            int x = (int)me.getX();
            int y = (int)me.getY();
            me.setLocation(Math.max(bounds.left, Math.min(x, bounds.right - 1)), Math.max(bounds.top, Math.min(y, bounds.bottom - 1)));
            return me;
        }
        int[] pointerIds = new int[pointerCount];
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[pointerCount];
        for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            pointerIds[pointerIndex] = me.getPointerId(pointerIndex);
            MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
            me.getPointerCoords(pointerIndex, coords);
            pointerCoords[pointerIndex] = coords;
            int x = (int)coords.x;
            int y = (int)coords.y;
            if (bounds.contains(x, y)) continue;
            coords.x = Math.max(bounds.left, Math.min(x, bounds.right - 1));
            coords.y = Math.max(bounds.top, Math.min(y, bounds.bottom - 1));
        }
        return MotionEvent.obtain(me.getDownTime(), me.getEventTime(), me.getAction(), pointerCount, pointerIds, pointerCoords, me.getMetaState(), me.getXPrecision(), me.getYPrecision(), me.getDeviceId(), me.getEdgeFlags(), me.getSource(), me.getFlags());
    }
}

