/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;

public class Country
implements Parcelable {
    public static final int COUNTRY_SOURCE_NETWORK = 0;
    public static final int COUNTRY_SOURCE_LOCATION = 1;
    public static final int COUNTRY_SOURCE_SIM = 2;
    public static final int COUNTRY_SOURCE_LOCALE = 3;
    public final String mCountryIso;
    public final int mSource;
    public int mHashCode;
    public static final Parcelable.Creator<Country> CREATOR = new Parcelable.Creator<Country>(){

        @Override
        public Country createFromParcel(Parcel in) {
            return new Country(in.readString(), in.readInt());
        }

        public Country[] newArray(int size) {
            return new Country[size];
        }
    };

    public Country(String countryIso, int source) {
        if (countryIso == null || source < 0 || source > 3) {
            throw new IllegalArgumentException();
        }
        this.mCountryIso = countryIso.toLowerCase();
        this.mSource = source;
    }

    public Country(Country country) {
        this.mCountryIso = country.mCountryIso;
        this.mSource = country.mSource;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }

    public int getSource() {
        return this.mSource;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mCountryIso);
        parcel.writeInt(this.mSource);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Country) {
            Country c = (Country)object;
            return this.mCountryIso.equals(c.getCountryIso()) && this.mSource == c.getSource();
        }
        return false;
    }

    public int hashCode() {
        int hash = this.mHashCode;
        if (hash == 0) {
            hash = 17;
            hash = hash * 13 + this.mCountryIso.hashCode();
            this.mHashCode = hash = hash * 13 + this.mSource;
        }
        return this.mHashCode;
    }

    public boolean equalsIgnoreSource(Country country) {
        return country != null && this.mCountryIso.equals(country.getCountryIso());
    }
}

