/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class LinkAddress
implements Parcelable {
    public final InetAddress address;
    public final int prefixLength;
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        @Override
        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            int prefixLength = 0;
            if (in.readByte() == 1) {
                try {
                    address = InetAddress.getByAddress(in.createByteArray());
                    prefixLength = in.readInt();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            return new LinkAddress(address, prefixLength);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    public LinkAddress(InetAddress address, InetAddress mask) {
        this.address = address;
        this.prefixLength = LinkAddress.computeprefixLength(mask);
    }

    public LinkAddress(InetAddress address, int prefixLength) {
        this.address = address;
        this.prefixLength = prefixLength;
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this.address = interfaceAddress.getAddress();
        this.prefixLength = interfaceAddress.getNetworkPrefixLength();
    }

    public static int computeprefixLength(InetAddress mask) {
        int count = 0;
        for (byte b : mask.getAddress()) {
            for (int i = 0; i < 8; ++i) {
                if ((b & 1 << i) == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public String toString() {
        return this.address == null ? "" : this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getNetworkPrefixLength() {
        return this.prefixLength;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.address != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.address.getAddress());
            dest.writeInt(this.prefixLength);
        } else {
            dest.writeByte((byte)0);
        }
    }
}

