/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    public static final int MODE_LAST = 3;
    public final Map<AudioStream, Integer> mStreams = new HashMap<AudioStream, Integer>();
    public int mMode = 0;
    public int mNative;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream[] getStreams() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            return this.mStreams.keySet().toArray(new AudioStream[this.mStreams.size()]);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("Invalid mode");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSetMode(mode);
            this.mMode = mode;
        }
    }

    public void nativeSetMode(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeSetMode(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AudioStream stream, AudioCodec codec, int dtmfType) {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            if (!this.mStreams.containsKey(stream)) {
                try {
                    int socket = stream.dup();
                    String codecSpec = String.format("%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                    this.nativeAdd(stream.getMode(), socket, stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, dtmfType);
                    this.mStreams.put(stream, socket);
                }
                catch (NullPointerException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public void nativeAdd(int n, int n2, String string2, int n3, String string3, int n4) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeAdd(IILjava/lang/String;ILjava/lang/String;I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AudioStream stream) {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            Integer socket = this.mStreams.remove(stream);
            if (socket != null) {
                this.nativeRemove(socket);
            }
        }
    }

    public void nativeRemove(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeRemove(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(int event) {
        if (event < 0 || event > 15) {
            throw new IllegalArgumentException("Invalid event");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSendDtmf(event);
        }
    }

    public void nativeSendDtmf(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeSendDtmf(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.mStreams.clear();
            this.nativeRemove(-1);
        }
    }

    public void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

