/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.LinkProperties;
import android.net.wifi.WifiConfiguration;
import android.os.Parcel;
import android.os.Parcelable;

public class WpsConfiguration
implements Parcelable {
    public Setup setup;
    public String BSSID;
    public String pin;
    public WifiConfiguration.IpAssignment ipAssignment;
    public WifiConfiguration.ProxySettings proxySettings;
    public LinkProperties linkProperties;
    public static final Parcelable.Creator<WpsConfiguration> CREATOR = new Parcelable.Creator<WpsConfiguration>(){

        @Override
        public WpsConfiguration createFromParcel(Parcel in) {
            WpsConfiguration config = new WpsConfiguration();
            config.setup = Setup.valueOf(in.readString());
            config.BSSID = in.readString();
            config.pin = in.readString();
            config.ipAssignment = WifiConfiguration.IpAssignment.valueOf(in.readString());
            config.proxySettings = WifiConfiguration.ProxySettings.valueOf(in.readString());
            config.linkProperties = (LinkProperties)in.readParcelable(null);
            return config;
        }

        public WpsConfiguration[] newArray(int size) {
            return new WpsConfiguration[size];
        }
    };

    public WpsConfiguration() {
        this.setup = Setup.INVALID;
        this.BSSID = null;
        this.pin = null;
        this.ipAssignment = WifiConfiguration.IpAssignment.UNASSIGNED;
        this.proxySettings = WifiConfiguration.ProxySettings.UNASSIGNED;
        this.linkProperties = new LinkProperties();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(" setup: ").append(this.setup.toString());
        sbuf.append('\n');
        sbuf.append(" BSSID: ").append(this.BSSID);
        sbuf.append('\n');
        sbuf.append(" pin: ").append(this.pin);
        sbuf.append('\n');
        sbuf.append("IP assignment: " + this.ipAssignment.toString());
        sbuf.append("\n");
        sbuf.append("Proxy settings: " + this.proxySettings.toString());
        sbuf.append("\n");
        sbuf.append(this.linkProperties.toString());
        sbuf.append("\n");
        return sbuf.toString();
    }

    public int describeContents() {
        return 0;
    }

    public WpsConfiguration(WpsConfiguration source) {
        if (source != null) {
            this.setup = source.setup;
            this.BSSID = source.BSSID;
            this.pin = source.pin;
            this.ipAssignment = source.ipAssignment;
            this.proxySettings = source.proxySettings;
            this.linkProperties = new LinkProperties(source.linkProperties);
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.setup.name());
        dest.writeString(this.BSSID);
        dest.writeString(this.pin);
        dest.writeString(this.ipAssignment.name());
        dest.writeString(this.proxySettings.name());
        dest.writeParcelable(this.linkProperties, flags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Setup {
        PBC,
        PIN_FROM_ACCESS_POINT,
        PIN_FROM_DEVICE,
        INVALID;

    }
}

