/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MifareClassic
extends BasicTagTechnology {
    public static final byte[] KEY_DEFAULT = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final byte[] KEY_MIFARE_APPLICATION_DIRECTORY = new byte[]{-96, -95, -94, -93, -92, -91};
    public static final byte[] KEY_NFC_FORUM = new byte[]{-45, -9, -45, -9, -45, -9};
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_CLASSIC = 0;
    public static final int TYPE_PLUS = 1;
    public static final int TYPE_PRO = 2;
    public static final int SIZE_1K = 1024;
    public static final int SIZE_2K = 2048;
    public static final int SIZE_4K = 4096;
    public static final int SIZE_MINI = 320;
    public static final int BLOCK_SIZE = 16;
    public static final int MAX_BLOCK_COUNT = 256;
    public static final int MAX_SECTOR_COUNT = 40;
    public boolean mIsEmulated;
    public int mType;
    public int mSize;

    public static MifareClassic get(Tag tag) {
        if (!tag.hasTech(8)) {
            return null;
        }
        try {
            return new MifareClassic(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public MifareClassic(Tag tag) throws RemoteException {
        super(tag, 8);
        NfcA a = NfcA.get(tag);
        this.mIsEmulated = false;
        switch (a.getSak()) {
            case 8: {
                this.mType = 0;
                this.mSize = 1024;
                break;
            }
            case 9: {
                this.mType = 0;
                this.mSize = 320;
                break;
            }
            case 16: {
                this.mType = 1;
                this.mSize = 2048;
                break;
            }
            case 17: {
                this.mType = 1;
                this.mSize = 4096;
                break;
            }
            case 24: {
                this.mType = 0;
                this.mSize = 4096;
                break;
            }
            case 40: {
                this.mType = 0;
                this.mSize = 1024;
                this.mIsEmulated = true;
                break;
            }
            case 56: {
                this.mType = 0;
                this.mSize = 4096;
                this.mIsEmulated = true;
                break;
            }
            case 136: {
                this.mType = 0;
                this.mSize = 1024;
                break;
            }
            case 152: 
            case 184: {
                this.mType = 2;
                this.mSize = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Tag incorrectly enumerated as Mifare Classic, SAK = " + a.getSak());
            }
        }
    }

    public int getType() {
        return this.mType;
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isEmulated() {
        return this.mIsEmulated;
    }

    public int getSectorCount() {
        switch (this.mSize) {
            case 1024: {
                return 16;
            }
            case 2048: {
                return 32;
            }
            case 4096: {
                return 40;
            }
            case 320: {
                return 5;
            }
        }
        return 0;
    }

    public int getBlockCount() {
        return this.mSize / 16;
    }

    public int getBlockCountInSector(int sectorIndex) {
        MifareClassic.validateSector(sectorIndex);
        if (sectorIndex < 32) {
            return 4;
        }
        return 16;
    }

    public int blockToSector(int blockIndex) {
        MifareClassic.validateBlock(blockIndex);
        if (blockIndex < 128) {
            return blockIndex / 4;
        }
        return 32 + (blockIndex - 128) / 16;
    }

    public int sectorToBlock(int sectorIndex) {
        if (sectorIndex < 32) {
            return sectorIndex * 4;
        }
        return 128 + (sectorIndex - 32) * 16;
    }

    public boolean authenticateSectorWithKeyA(int sectorIndex, byte[] key) throws IOException {
        return this.authenticate(sectorIndex, key, true);
    }

    public boolean authenticateSectorWithKeyB(int sectorIndex, byte[] key) throws IOException {
        return this.authenticate(sectorIndex, key, false);
    }

    public boolean authenticate(int sector, byte[] key, boolean keyA) throws IOException {
        MifareClassic.validateSector(sector);
        this.checkConnected();
        byte[] cmd = new byte[12];
        cmd[0] = keyA ? 96 : 97;
        cmd[1] = (byte)this.sectorToBlock(sector);
        byte[] uid = this.getTag().getId();
        System.arraycopy(uid, uid.length - 4, cmd, 2, 4);
        System.arraycopy(key, 0, cmd, 6, 6);
        try {
            if (this.transceive(cmd, false) != null) {
                return true;
            }
        }
        catch (TagLostException e) {
            throw e;
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    public byte[] readBlock(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{48, (byte)blockIndex};
        return this.transceive(cmd, false);
    }

    public void writeBlock(int blockIndex, byte[] data) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        if (data.length != 16) {
            throw new IllegalArgumentException("must write 16-bytes");
        }
        byte[] cmd = new byte[data.length + 2];
        cmd[0] = -96;
        cmd[1] = (byte)blockIndex;
        System.arraycopy(data, 0, cmd, 2, data.length);
        this.transceive(cmd, false);
    }

    public void increment(int blockIndex, int value) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        MifareClassic.validateValueOperand(value);
        this.checkConnected();
        ByteBuffer cmd = ByteBuffer.allocate(6);
        cmd.order(ByteOrder.LITTLE_ENDIAN);
        cmd.put((byte)-63);
        cmd.put((byte)blockIndex);
        cmd.putInt(value);
        this.transceive(cmd.array(), false);
    }

    public void decrement(int blockIndex, int value) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        MifareClassic.validateValueOperand(value);
        this.checkConnected();
        ByteBuffer cmd = ByteBuffer.allocate(6);
        cmd.order(ByteOrder.LITTLE_ENDIAN);
        cmd.put((byte)-64);
        cmd.put((byte)blockIndex);
        cmd.putInt(value);
        this.transceive(cmd.array(), false);
    }

    public void transfer(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{-80, (byte)blockIndex};
        this.transceive(cmd, false);
    }

    public void restore(int blockIndex) throws IOException {
        MifareClassic.validateBlock(blockIndex);
        this.checkConnected();
        byte[] cmd = new byte[]{-62, (byte)blockIndex};
        this.transceive(cmd, false);
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }

    public static void validateSector(int sector) {
        if (sector < 0 || sector >= 40) {
            throw new IndexOutOfBoundsException("sector out of bounds: " + sector);
        }
    }

    public static void validateBlock(int block) {
        if (block < 0 || block >= 256) {
            throw new IndexOutOfBoundsException("block out of bounds: " + block);
        }
    }

    public static void validateValueOperand(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value operand negative");
        }
    }
}

