/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

public class Element
extends BaseObj {
    public int mSize;
    public Element[] mElements;
    public String[] mElementNames;
    public int[] mArraySizes;
    public DataType mType;
    public DataKind mKind;
    public boolean mNormalized;
    public int mVectorSize;

    public int getSizeBytes() {
        return this.mSize;
    }

    public boolean isComplex() {
        if (this.mElements == null) {
            return false;
        }
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            if (this.mElements[ct].mElements == null) continue;
            return true;
        }
        return false;
    }

    public static Element BOOLEAN(RenderScript rs) {
        if (rs.mElement_BOOLEAN == null) {
            rs.mElement_BOOLEAN = Element.createUser(rs, DataType.BOOLEAN);
        }
        return rs.mElement_BOOLEAN;
    }

    public static Element U8(RenderScript rs) {
        if (rs.mElement_U8 == null) {
            rs.mElement_U8 = Element.createUser(rs, DataType.UNSIGNED_8);
        }
        return rs.mElement_U8;
    }

    public static Element I8(RenderScript rs) {
        if (rs.mElement_I8 == null) {
            rs.mElement_I8 = Element.createUser(rs, DataType.SIGNED_8);
        }
        return rs.mElement_I8;
    }

    public static Element U16(RenderScript rs) {
        if (rs.mElement_U16 == null) {
            rs.mElement_U16 = Element.createUser(rs, DataType.UNSIGNED_16);
        }
        return rs.mElement_U16;
    }

    public static Element I16(RenderScript rs) {
        if (rs.mElement_I16 == null) {
            rs.mElement_I16 = Element.createUser(rs, DataType.SIGNED_16);
        }
        return rs.mElement_I16;
    }

    public static Element U32(RenderScript rs) {
        if (rs.mElement_U32 == null) {
            rs.mElement_U32 = Element.createUser(rs, DataType.UNSIGNED_32);
        }
        return rs.mElement_U32;
    }

    public static Element I32(RenderScript rs) {
        if (rs.mElement_I32 == null) {
            rs.mElement_I32 = Element.createUser(rs, DataType.SIGNED_32);
        }
        return rs.mElement_I32;
    }

    public static Element U64(RenderScript rs) {
        if (rs.mElement_U64 == null) {
            rs.mElement_U64 = Element.createUser(rs, DataType.UNSIGNED_64);
        }
        return rs.mElement_U64;
    }

    public static Element I64(RenderScript rs) {
        if (rs.mElement_I64 == null) {
            rs.mElement_I64 = Element.createUser(rs, DataType.SIGNED_64);
        }
        return rs.mElement_I64;
    }

    public static Element F32(RenderScript rs) {
        if (rs.mElement_F32 == null) {
            rs.mElement_F32 = Element.createUser(rs, DataType.FLOAT_32);
        }
        return rs.mElement_F32;
    }

    public static Element F64(RenderScript rs) {
        if (rs.mElement_F64 == null) {
            rs.mElement_F64 = Element.createUser(rs, DataType.FLOAT_64);
        }
        return rs.mElement_F64;
    }

    public static Element ELEMENT(RenderScript rs) {
        if (rs.mElement_ELEMENT == null) {
            rs.mElement_ELEMENT = Element.createUser(rs, DataType.RS_ELEMENT);
        }
        return rs.mElement_ELEMENT;
    }

    public static Element TYPE(RenderScript rs) {
        if (rs.mElement_TYPE == null) {
            rs.mElement_TYPE = Element.createUser(rs, DataType.RS_TYPE);
        }
        return rs.mElement_TYPE;
    }

    public static Element ALLOCATION(RenderScript rs) {
        if (rs.mElement_ALLOCATION == null) {
            rs.mElement_ALLOCATION = Element.createUser(rs, DataType.RS_ALLOCATION);
        }
        return rs.mElement_ALLOCATION;
    }

    public static Element SAMPLER(RenderScript rs) {
        if (rs.mElement_SAMPLER == null) {
            rs.mElement_SAMPLER = Element.createUser(rs, DataType.RS_SAMPLER);
        }
        return rs.mElement_SAMPLER;
    }

    public static Element SCRIPT(RenderScript rs) {
        if (rs.mElement_SCRIPT == null) {
            rs.mElement_SCRIPT = Element.createUser(rs, DataType.RS_SCRIPT);
        }
        return rs.mElement_SCRIPT;
    }

    public static Element MESH(RenderScript rs) {
        if (rs.mElement_MESH == null) {
            rs.mElement_MESH = Element.createUser(rs, DataType.RS_MESH);
        }
        return rs.mElement_MESH;
    }

    public static Element PROGRAM_FRAGMENT(RenderScript rs) {
        if (rs.mElement_PROGRAM_FRAGMENT == null) {
            rs.mElement_PROGRAM_FRAGMENT = Element.createUser(rs, DataType.RS_PROGRAM_FRAGMENT);
        }
        return rs.mElement_PROGRAM_FRAGMENT;
    }

    public static Element PROGRAM_VERTEX(RenderScript rs) {
        if (rs.mElement_PROGRAM_VERTEX == null) {
            rs.mElement_PROGRAM_VERTEX = Element.createUser(rs, DataType.RS_PROGRAM_VERTEX);
        }
        return rs.mElement_PROGRAM_VERTEX;
    }

    public static Element PROGRAM_RASTER(RenderScript rs) {
        if (rs.mElement_PROGRAM_RASTER == null) {
            rs.mElement_PROGRAM_RASTER = Element.createUser(rs, DataType.RS_PROGRAM_RASTER);
        }
        return rs.mElement_PROGRAM_RASTER;
    }

    public static Element PROGRAM_STORE(RenderScript rs) {
        if (rs.mElement_PROGRAM_STORE == null) {
            rs.mElement_PROGRAM_STORE = Element.createUser(rs, DataType.RS_PROGRAM_STORE);
        }
        return rs.mElement_PROGRAM_STORE;
    }

    public static Element A_8(RenderScript rs) {
        if (rs.mElement_A_8 == null) {
            rs.mElement_A_8 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_A);
        }
        return rs.mElement_A_8;
    }

    public static Element RGB_565(RenderScript rs) {
        if (rs.mElement_RGB_565 == null) {
            rs.mElement_RGB_565 = Element.createPixel(rs, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
        }
        return rs.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript rs) {
        if (rs.mElement_RGB_888 == null) {
            rs.mElement_RGB_888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
        }
        return rs.mElement_RGB_888;
    }

    public static Element RGBA_5551(RenderScript rs) {
        if (rs.mElement_RGBA_5551 == null) {
            rs.mElement_RGBA_5551 = Element.createPixel(rs, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_5551;
    }

    public static Element RGBA_4444(RenderScript rs) {
        if (rs.mElement_RGBA_4444 == null) {
            rs.mElement_RGBA_4444 = Element.createPixel(rs, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_4444;
    }

    public static Element RGBA_8888(RenderScript rs) {
        if (rs.mElement_RGBA_8888 == null) {
            rs.mElement_RGBA_8888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_8888;
    }

    public static Element F32_2(RenderScript rs) {
        if (rs.mElement_FLOAT_2 == null) {
            rs.mElement_FLOAT_2 = Element.createVector(rs, DataType.FLOAT_32, 2);
        }
        return rs.mElement_FLOAT_2;
    }

    public static Element F32_3(RenderScript rs) {
        if (rs.mElement_FLOAT_3 == null) {
            rs.mElement_FLOAT_3 = Element.createVector(rs, DataType.FLOAT_32, 3);
        }
        return rs.mElement_FLOAT_3;
    }

    public static Element F32_4(RenderScript rs) {
        if (rs.mElement_FLOAT_4 == null) {
            rs.mElement_FLOAT_4 = Element.createVector(rs, DataType.FLOAT_32, 4);
        }
        return rs.mElement_FLOAT_4;
    }

    public static Element U8_4(RenderScript rs) {
        if (rs.mElement_UCHAR_4 == null) {
            rs.mElement_UCHAR_4 = Element.createVector(rs, DataType.UNSIGNED_8, 4);
        }
        return rs.mElement_UCHAR_4;
    }

    public static Element MATRIX_4X4(RenderScript rs) {
        if (rs.mElement_MATRIX_4X4 == null) {
            rs.mElement_MATRIX_4X4 = Element.createUser(rs, DataType.MATRIX_4X4);
        }
        return rs.mElement_MATRIX_4X4;
    }

    public static Element MATRIX4X4(RenderScript rs) {
        return Element.MATRIX_4X4(rs);
    }

    public static Element MATRIX_3X3(RenderScript rs) {
        if (rs.mElement_MATRIX_3X3 == null) {
            rs.mElement_MATRIX_3X3 = Element.createUser(rs, DataType.MATRIX_3X3);
        }
        return rs.mElement_MATRIX_4X4;
    }

    public static Element MATRIX_2X2(RenderScript rs) {
        if (rs.mElement_MATRIX_2X2 == null) {
            rs.mElement_MATRIX_2X2 = Element.createUser(rs, DataType.MATRIX_2X2);
        }
        return rs.mElement_MATRIX_2X2;
    }

    public Element(int id2, RenderScript rs, Element[] e, String[] n, int[] as) {
        super(id2, rs);
        this.mSize = 0;
        this.mElements = e;
        this.mElementNames = n;
        this.mArraySizes = as;
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            this.mSize += this.mElements[ct].mSize * this.mArraySizes[ct];
        }
    }

    public Element(int id2, RenderScript rs, DataType dt, DataKind dk, boolean norm, int size) {
        super(id2, rs);
        this.mSize = dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1 ? dt.mSize * size : dt.mSize;
        this.mType = dt;
        this.mKind = dk;
        this.mNormalized = norm;
        this.mVectorSize = size;
    }

    public Element(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void updateFromNative() {
        super.updateFromNative();
        int[] dataBuffer = new int[5];
        this.mRS.nElementGetNativeData(this.getID(), dataBuffer);
        this.mNormalized = dataBuffer[2] == 1;
        this.mVectorSize = dataBuffer[3];
        this.mSize = 0;
        for (DataType dataType : DataType.values()) {
            if (dataType.mID != dataBuffer[0]) continue;
            this.mType = dataType;
            this.mSize = this.mType.mSize * this.mVectorSize;
        }
        for (Enum enum_ : DataKind.values()) {
            if (((DataKind)enum_).mID != dataBuffer[1]) continue;
            this.mKind = enum_;
        }
        int numSubElements = dataBuffer[4];
        if (numSubElements > 0) {
            this.mElements = new Element[numSubElements];
            this.mElementNames = new String[numSubElements];
            int[] subElementIds = new int[numSubElements];
            this.mRS.nElementGetSubElements(this.getID(), subElementIds, this.mElementNames);
            for (int i = 0; i < numSubElements; ++i) {
                this.mElements[i] = new Element(subElementIds[i], this.mRS);
                this.mElements[i].updateFromNative();
                this.mSize += this.mElements[i].mSize;
            }
        }
    }

    public static Element createUser(RenderScript rs, DataType dt) {
        DataKind dk = DataKind.USER;
        boolean norm = false;
        int vecSize = 1;
        int id2 = rs.nElementCreate(dt.mID, dk.mID, norm, vecSize);
        return new Element(id2, rs, dt, dk, norm, vecSize);
    }

    public static Element createVector(RenderScript rs, DataType dt, int size) {
        if (size < 2 || size > 4) {
            throw new RSIllegalArgumentException("Vector size out of range 2-4.");
        }
        DataKind dk = DataKind.USER;
        boolean norm = false;
        int id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
        return new Element(id2, rs, dt, dk, norm, size);
    }

    public static Element createPixel(RenderScript rs, DataType dt, DataKind dk) {
        if (dk != DataKind.PIXEL_L && dk != DataKind.PIXEL_A && dk != DataKind.PIXEL_LA && dk != DataKind.PIXEL_RGB && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Unsupported DataKind");
        }
        if (dt != DataType.UNSIGNED_8 && dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1) {
            throw new RSIllegalArgumentException("Unsupported DataType");
        }
        if (dt == DataType.UNSIGNED_5_6_5 && dk != DataKind.PIXEL_RGB) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_5_5_5_1 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_4_4_4_4 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        int size = 1;
        if (dk == DataKind.PIXEL_LA) {
            size = 2;
        }
        if (dk == DataKind.PIXEL_RGB) {
            size = 3;
        }
        if (dk == DataKind.PIXEL_RGBA) {
            size = 4;
        }
        boolean norm = true;
        int id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
        return new Element(id2, rs, dt, dk, norm, size);
    }

    public static class Builder {
        public RenderScript mRS;
        public Element[] mElements;
        public String[] mElementNames;
        public int[] mArraySizes;
        public int mCount;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
            this.mArraySizes = new int[8];
        }

        public Builder add(Element element, String name, int arraySize) {
            if (arraySize < 1) {
                throw new RSIllegalArgumentException("Array size cannot be less than 1.");
            }
            if (this.mCount == this.mElements.length) {
                Element[] e = new Element[this.mCount + 8];
                String[] s = new String[this.mCount + 8];
                int[] as = new int[this.mCount + 8];
                System.arraycopy(this.mElements, 0, e, 0, this.mCount);
                System.arraycopy(this.mElementNames, 0, s, 0, this.mCount);
                System.arraycopy(this.mArraySizes, 0, as, 0, this.mCount);
                this.mElements = e;
                this.mElementNames = s;
                this.mArraySizes = as;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = name;
            this.mArraySizes[this.mCount] = arraySize;
            ++this.mCount;
            return this;
        }

        public Builder add(Element element, String name) {
            return this.add(element, name, 1);
        }

        public Element create() {
            this.mRS.validate();
            Element[] ein = new Element[this.mCount];
            String[] sin = new String[this.mCount];
            int[] asin = new int[this.mCount];
            System.arraycopy(this.mElements, 0, ein, 0, this.mCount);
            System.arraycopy(this.mElementNames, 0, sin, 0, this.mCount);
            System.arraycopy(this.mArraySizes, 0, asin, 0, this.mCount);
            int[] ids = new int[ein.length];
            for (int ct = 0; ct < ein.length; ++ct) {
                ids[ct] = ein[ct].getID();
            }
            int id2 = this.mRS.nElementCreate2(ids, sin, asin);
            return new Element(id2, this.mRS, ein, sin, asin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataKind {
        USER(0),
        PIXEL_L(7),
        PIXEL_A(8),
        PIXEL_LA(9),
        PIXEL_RGB(10),
        PIXEL_RGBA(11);

        public int mID;

        public DataKind(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        FLOAT_32(2, 4),
        FLOAT_64(3, 8),
        SIGNED_8(4, 1),
        SIGNED_16(5, 2),
        SIGNED_32(6, 4),
        SIGNED_64(7, 8),
        UNSIGNED_8(8, 1),
        UNSIGNED_16(9, 2),
        UNSIGNED_32(10, 4),
        UNSIGNED_64(11, 8),
        BOOLEAN(12, 1),
        UNSIGNED_5_6_5(13, 2),
        UNSIGNED_5_5_5_1(14, 2),
        UNSIGNED_4_4_4_4(15, 2),
        MATRIX_4X4(16, 64),
        MATRIX_3X3(17, 36),
        MATRIX_2X2(18, 16),
        RS_ELEMENT(1000, 4),
        RS_TYPE(1001, 4),
        RS_ALLOCATION(1002, 4),
        RS_SAMPLER(1003, 4),
        RS_SCRIPT(1004, 4),
        RS_MESH(1005, 4),
        RS_PROGRAM_FRAGMENT(1006, 4),
        RS_PROGRAM_VERTEX(1007, 4),
        RS_PROGRAM_RASTER(1008, 4),
        RS_PROGRAM_STORE(1009, 4);

        public int mID;
        public int mSize;

        public DataType(int id2, int size) {
            this.mID = id2;
            this.mSize = size;
        }
    }
}

