/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Byte2;
import android.renderscript.Byte3;
import android.renderscript.Byte4;
import android.renderscript.Float2;
import android.renderscript.Float3;
import android.renderscript.Float4;
import android.renderscript.Int2;
import android.renderscript.Int3;
import android.renderscript.Int4;
import android.renderscript.Long2;
import android.renderscript.Long3;
import android.renderscript.Long4;
import android.renderscript.Matrix2f;
import android.renderscript.Matrix3f;
import android.renderscript.Matrix4f;
import android.renderscript.Short2;
import android.renderscript.Short3;
import android.renderscript.Short4;
import android.util.Log;

public class FieldPacker {
    public final byte[] mData;
    public int mPos = 0;

    public FieldPacker(int len) {
        this.mData = new byte[len];
    }

    public void align(int v) {
        while ((this.mPos & v - 1) != 0) {
            this.mData[this.mPos++] = 0;
        }
    }

    public void reset() {
        this.mPos = 0;
    }

    public void reset(int i) {
        this.mPos = i;
    }

    public void skip(int i) {
        this.mPos += i;
    }

    public void addI8(byte v) {
        this.mData[this.mPos++] = v;
    }

    public void addI16(short v) {
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addI32(int v) {
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFF);
    }

    public void addI64(long v) {
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addU8(short v) {
        if (v < 0 || v > 255) {
            Log.e("rs", "FieldPacker.addU8( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.mData[this.mPos++] = (byte)v;
    }

    public void addU16(int v) {
        if (v < 0 || v > 65535) {
            Log.e("rs", "FieldPacker.addU16( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addU32(long v) {
        if (v < 0L || v > 0xFFFFFFFFL) {
            Log.e("rs", "FieldPacker.addU32( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
    }

    public void addU64(long v) {
        if (v < 0L) {
            Log.e("rs", "FieldPacker.addU64( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addF32(float v) {
        this.addI32(Float.floatToRawIntBits(v));
    }

    public void addF64(double v) {
        this.addI64(Double.doubleToRawLongBits(v));
    }

    public void addObj(BaseObj obj) {
        if (obj != null) {
            this.addI32(obj.getID());
        } else {
            this.addI32(0);
        }
    }

    public void addF32(Float2 v) {
        this.addF32(v.x);
        this.addF32(v.y);
    }

    public void addF32(Float3 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
    }

    public void addF32(Float4 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
        this.addF32(v.w);
    }

    public void addI8(Byte2 v) {
        this.addI8(v.x);
        this.addI8(v.y);
    }

    public void addI8(Byte3 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
    }

    public void addI8(Byte4 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
        this.addI8(v.w);
    }

    public void addU8(Short2 v) {
        this.addU8(v.x);
        this.addU8(v.y);
    }

    public void addU8(Short3 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
    }

    public void addU8(Short4 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
        this.addU8(v.w);
    }

    public void addI16(Short2 v) {
        this.addI16(v.x);
        this.addI16(v.y);
    }

    public void addI16(Short3 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
    }

    public void addI16(Short4 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
        this.addI16(v.w);
    }

    public void addU16(Int2 v) {
        this.addU16(v.x);
        this.addU16(v.y);
    }

    public void addU16(Int3 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
    }

    public void addU16(Int4 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
        this.addU16(v.w);
    }

    public void addI32(Int2 v) {
        this.addI32(v.x);
        this.addI32(v.y);
    }

    public void addI32(Int3 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
    }

    public void addI32(Int4 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
        this.addI32(v.w);
    }

    public void addU32(Long2 v) {
        this.addU32(v.x);
        this.addU32(v.y);
    }

    public void addU32(Long3 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
    }

    public void addU32(Long4 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
        this.addU32(v.w);
    }

    public void addMatrix(Matrix4f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addMatrix(Matrix3f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addMatrix(Matrix2f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public void addBoolean(boolean v) {
        this.addI8((byte)(v ? 1 : 0));
    }

    public byte[] getData() {
        return this.mData;
    }
}

