/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class ProgramStore
extends BaseObj {
    public ProgramStore(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static ProgramStore BLEND_NONE_DEPTH_TEST(RenderScript rs) {
        if (rs.mProgramStore_BLEND_NONE_DEPTH_TEST == null) {
            Builder builder = new Builder(rs);
            builder.setDepthFunc(DepthFunc.LESS);
            builder.setBlendFunc(BlendSrcFunc.ONE, BlendDstFunc.ZERO);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(true);
            rs.mProgramStore_BLEND_NONE_DEPTH_TEST = builder.create();
        }
        return rs.mProgramStore_BLEND_NONE_DEPTH_TEST;
    }

    public static ProgramStore BLEND_NONE_DEPTH_NONE(RenderScript rs) {
        if (rs.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH == null) {
            Builder builder = new Builder(rs);
            builder.setDepthFunc(DepthFunc.ALWAYS);
            builder.setBlendFunc(BlendSrcFunc.ONE, BlendDstFunc.ZERO);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(false);
            rs.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH = builder.create();
        }
        return rs.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    }

    public static ProgramStore BLEND_ALPHA_DEPTH_TEST(RenderScript rs) {
        if (rs.mProgramStore_BLEND_ALPHA_DEPTH_TEST == null) {
            Builder builder = new Builder(rs);
            builder.setDepthFunc(DepthFunc.LESS);
            builder.setBlendFunc(BlendSrcFunc.SRC_ALPHA, BlendDstFunc.ONE_MINUS_SRC_ALPHA);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(true);
            rs.mProgramStore_BLEND_ALPHA_DEPTH_TEST = builder.create();
        }
        return rs.mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    }

    public static ProgramStore BLEND_ALPHA_DEPTH_NONE(RenderScript rs) {
        if (rs.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH == null) {
            Builder builder = new Builder(rs);
            builder.setDepthFunc(DepthFunc.ALWAYS);
            builder.setBlendFunc(BlendSrcFunc.SRC_ALPHA, BlendDstFunc.ONE_MINUS_SRC_ALPHA);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(false);
            rs.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH = builder.create();
        }
        return rs.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    }

    public static class Builder {
        public RenderScript mRS;
        public DepthFunc mDepthFunc;
        public boolean mDepthMask;
        public boolean mColorMaskR;
        public boolean mColorMaskG;
        public boolean mColorMaskB;
        public boolean mColorMaskA;
        public BlendSrcFunc mBlendSrc;
        public BlendDstFunc mBlendDst;
        public boolean mDither;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mDepthFunc = DepthFunc.ALWAYS;
            this.mDepthMask = false;
            this.mColorMaskR = true;
            this.mColorMaskG = true;
            this.mColorMaskB = true;
            this.mColorMaskA = true;
            this.mBlendSrc = BlendSrcFunc.ONE;
            this.mBlendDst = BlendDstFunc.ZERO;
        }

        public Builder setDepthFunc(DepthFunc func) {
            this.mDepthFunc = func;
            return this;
        }

        public Builder setDepthMaskEnabled(boolean enable) {
            this.mDepthMask = enable;
            return this;
        }

        public Builder setColorMaskEnabled(boolean r, boolean g, boolean b, boolean a) {
            this.mColorMaskR = r;
            this.mColorMaskG = g;
            this.mColorMaskB = b;
            this.mColorMaskA = a;
            return this;
        }

        public Builder setBlendFunc(BlendSrcFunc src, BlendDstFunc dst) {
            this.mBlendSrc = src;
            this.mBlendDst = dst;
            return this;
        }

        public Builder setDitherEnabled(boolean enable) {
            this.mDither = enable;
            return this;
        }

        public static synchronized ProgramStore internalCreate(RenderScript rs, Builder b) {
            rs.nProgramStoreBegin(0, 0);
            rs.nProgramStoreDepthFunc(b.mDepthFunc.mID);
            rs.nProgramStoreDepthMask(b.mDepthMask);
            rs.nProgramStoreColorMask(b.mColorMaskR, b.mColorMaskG, b.mColorMaskB, b.mColorMaskA);
            rs.nProgramStoreBlendFunc(b.mBlendSrc.mID, b.mBlendDst.mID);
            rs.nProgramStoreDither(b.mDither);
            int id2 = rs.nProgramStoreCreate();
            return new ProgramStore(id2, rs);
        }

        public ProgramStore create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendDstFunc {
        ZERO(0),
        ONE(1),
        SRC_COLOR(2),
        ONE_MINUS_SRC_COLOR(3),
        SRC_ALPHA(4),
        ONE_MINUS_SRC_ALPHA(5),
        DST_ALPHA(6),
        ONE_MINUS_DST_ALPHA(7);

        public int mID;

        public BlendDstFunc(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendSrcFunc {
        ZERO(0),
        ONE(1),
        DST_COLOR(2),
        ONE_MINUS_DST_COLOR(3),
        SRC_ALPHA(4),
        ONE_MINUS_SRC_ALPHA(5),
        DST_ALPHA(6),
        ONE_MINUS_DST_ALPHA(7),
        SRC_ALPHA_SATURATE(8);

        public int mID;

        public BlendSrcFunc(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DepthFunc {
        ALWAYS(0),
        LESS(1),
        LESS_OR_EQUAL(2),
        GREATER(3),
        GREATER_OR_EQUAL(4),
        EQUAL(5),
        NOT_EQUAL(6);

        public int mID;

        public DepthFunc(int id2) {
            this.mID = id2;
        }
    }
}

