/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.view.Surface;
import android.view.SurfaceHolder;

public class RenderScriptGL
extends RenderScript {
    public Surface mSurface;
    public int mWidth;
    public int mHeight;
    public SurfaceConfig mSurfaceConfig;

    public RenderScriptGL(Context ctx, SurfaceConfig sc) {
        super(ctx);
        this.mSurfaceConfig = new SurfaceConfig(sc);
        this.mSurface = null;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mDev = this.nDeviceCreate();
        this.mContext = this.nContextCreateGL(this.mDev, 0, this.mSurfaceConfig.mColorMin, this.mSurfaceConfig.mColorPref, this.mSurfaceConfig.mAlphaMin, this.mSurfaceConfig.mAlphaPref, this.mSurfaceConfig.mDepthMin, this.mSurfaceConfig.mDepthPref, this.mSurfaceConfig.mStencilMin, this.mSurfaceConfig.mStencilPref, this.mSurfaceConfig.mSamplesMin, this.mSurfaceConfig.mSamplesPref, this.mSurfaceConfig.mSamplesQ);
        if (this.mContext == 0) {
            throw new RSDriverException("Failed to create RS context.");
        }
        this.mMessageThread = new RenderScript.MessageThread(this);
        this.mMessageThread.start();
    }

    public void setSurface(SurfaceHolder sur, int w, int h) {
        this.validate();
        this.mSurface = sur != null ? sur.getSurface() : null;
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, this.mSurface);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void pause() {
        this.validate();
        this.nContextPause();
    }

    public void resume() {
        this.validate();
        this.nContextResume();
    }

    public void bindRootScript(Script s) {
        this.validate();
        this.nContextBindRootScript(this.safeID(s));
    }

    public void bindProgramStore(ProgramStore p) {
        this.validate();
        this.nContextBindProgramStore(this.safeID(p));
    }

    public void bindProgramFragment(ProgramFragment p) {
        this.validate();
        this.nContextBindProgramFragment(this.safeID(p));
    }

    public void bindProgramRaster(ProgramRaster p) {
        this.validate();
        this.nContextBindProgramRaster(this.safeID(p));
    }

    public void bindProgramVertex(ProgramVertex p) {
        this.validate();
        this.nContextBindProgramVertex(this.safeID(p));
    }

    public static class SurfaceConfig {
        public int mDepthMin = 0;
        public int mDepthPref = 0;
        public int mStencilMin = 0;
        public int mStencilPref = 0;
        public int mColorMin = 8;
        public int mColorPref = 8;
        public int mAlphaMin = 0;
        public int mAlphaPref = 0;
        public int mSamplesMin = 1;
        public int mSamplesPref = 1;
        public float mSamplesQ = 1.0f;

        public SurfaceConfig() {
        }

        public SurfaceConfig(SurfaceConfig sc) {
            this.mDepthMin = sc.mDepthMin;
            this.mDepthPref = sc.mDepthPref;
            this.mStencilMin = sc.mStencilMin;
            this.mStencilPref = sc.mStencilPref;
            this.mColorMin = sc.mColorMin;
            this.mColorPref = sc.mColorPref;
            this.mAlphaMin = sc.mAlphaMin;
            this.mAlphaPref = sc.mAlphaPref;
            this.mSamplesMin = sc.mSamplesMin;
            this.mSamplesPref = sc.mSamplesPref;
            this.mSamplesQ = sc.mSamplesQ;
        }

        public void validateRange(int umin, int upref, int rmin, int rmax) {
            if (umin < rmin || umin > rmax) {
                throw new RSIllegalArgumentException("Minimum value provided out of range.");
            }
            if (upref < umin) {
                throw new RSIllegalArgumentException("preferred must be >= Minimum.");
            }
        }

        public void setColor(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 5, 8);
            this.mColorMin = minimum;
            this.mColorPref = preferred;
        }

        public void setAlpha(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 8);
            this.mAlphaMin = minimum;
            this.mAlphaPref = preferred;
        }

        public void setDepth(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 24);
            this.mDepthMin = minimum;
            this.mDepthPref = preferred;
        }

        public void setSamples(int minimum, int preferred, float Q) {
            this.validateRange(minimum, preferred, 1, 32);
            if (Q < 0.0f || Q > 1.0f) {
                throw new RSIllegalArgumentException("Quality out of 0-1 range.");
            }
            this.mSamplesMin = minimum;
            this.mSamplesPref = preferred;
            this.mSamplesQ = Q;
        }
    }
}

