/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.speech.tts.ITts;
import android.speech.tts.ITtsCallback;
import android.util.Log;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextToSpeech {
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int QUEUE_FLUSH = 0;
    public static final int QUEUE_ADD = 1;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_MISSING_DATA = -1;
    public static final int LANG_NOT_SUPPORTED = -2;
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    public ServiceConnection mServiceConnection;
    public ITts mITts = null;
    public ITtsCallback mITtscallback = null;
    public Context mContext = null;
    public String mPackageName = "";
    public OnInitListener mInitListener = null;
    public boolean mStarted = false;
    public final Object mStartLock = new Object();
    public String[] mCachedParams;

    public TextToSpeech(Context context, OnInitListener listener) {
        this.mContext = context;
        this.mPackageName = this.mContext.getPackageName();
        this.mInitListener = listener;
        this.mCachedParams = new String[40];
        this.mCachedParams[0] = "rate";
        this.mCachedParams[2] = "language";
        this.mCachedParams[4] = "country";
        this.mCachedParams[6] = "variant";
        this.mCachedParams[8] = "streamType";
        this.mCachedParams[10] = "utteranceId";
        this.mCachedParams[12] = "engine";
        this.mCachedParams[14] = "pitch";
        this.mCachedParams[16] = "volume";
        this.mCachedParams[18] = "pan";
        this.mCachedParams[1] = "";
        this.mCachedParams[3] = "";
        this.mCachedParams[5] = "";
        this.mCachedParams[7] = "";
        this.mCachedParams[9] = String.valueOf(3);
        this.mCachedParams[11] = "";
        this.mCachedParams[13] = "";
        this.mCachedParams[15] = "100";
        this.mCachedParams[17] = "1.0";
        this.mCachedParams[19] = "0.0";
        this.initTts();
    }

    public void initTts() {
        this.mStarted = false;
        this.mServiceConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    TextToSpeech.this.mITts = ITts.Stub.asInterface(service);
                    TextToSpeech.this.mStarted = true;
                    TextToSpeech.this.setEngineByPackageName(TextToSpeech.this.getDefaultEngine());
                    TextToSpeech.this.setLanguage(TextToSpeech.this.getLanguage());
                    if (TextToSpeech.this.mInitListener != null) {
                        TextToSpeech.this.mInitListener.onInit(0);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName name) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    TextToSpeech.this.mITts = null;
                    TextToSpeech.this.mInitListener = null;
                    TextToSpeech.this.mStarted = false;
                }
            }
        };
        Intent intent = new Intent("android.intent.action.START_TTS_SERVICE");
        intent.addCategory("android.intent.category.TTS");
        boolean bound = this.mContext.bindService(intent, this.mServiceConnection, 1);
        if (!bound) {
            Log.e("TextToSpeech.java", "initTts() failed to bind to service");
            if (this.mInitListener != null) {
                this.mInitListener.onInit(-1);
            }
        } else {
            Log.i("TextToSpeech.java", "initTts() successfully bound to service");
        }
    }

    public void shutdown() {
        try {
            this.mContext.unbindService(this.mServiceConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                this.mITts.addSpeech(this.mPackageName, text, packagename, resourceId);
                return 0;
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - addSpeech", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - addSpeech", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - addSpeech", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                this.mITts.addSpeechFile(this.mPackageName, text, filename);
                return 0;
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - addSpeech", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - addSpeech", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - addSpeech", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                this.mITts.addEarcon(this.mPackageName, earcon, packagename, resourceId);
                return 0;
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - addEarcon", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - addEarcon", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - addEarcon", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                this.mITts.addEarconFile(this.mPackageName, earcon, filename);
                return 0;
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - addEarcon", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - addEarcon", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - addEarcon", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int speak(String text, int queueMode, HashMap<String, String> params) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            Log.i("TextToSpeech.java - speak", "speak text of length " + text.length());
            if (!this.mStarted) {
                Log.e("TextToSpeech.java - speak", "service isn't started");
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        this.setCachedParam(params, "streamType", 8);
                        this.setCachedParam(params, "utteranceId", 10);
                        this.setCachedParam(params, "engine", 12);
                        this.setCachedParam(params, "volume", 16);
                        this.setCachedParam(params, "pan", 18);
                    }
                    result = this.mITts.speak(this.mPackageName, text, queueMode, this.mCachedParams);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - speak", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_7 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - speak", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_8 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - speak", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_9 = null;
                    this.resetCachedParams();
                    return result;
                }
                Object var8_6 = null;
                this.resetCachedParams();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.resetCachedParams();
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int playEarcon(String earcon, int queueMode, HashMap<String, String> params) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        String extra = params.get("streamType");
                        if (extra != null) {
                            this.mCachedParams[9] = extra;
                        }
                        this.setCachedParam(params, "streamType", 8);
                        this.setCachedParam(params, "utteranceId", 10);
                    }
                    result = this.mITts.playEarcon(this.mPackageName, earcon, queueMode, null);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - playEarcon", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_11 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - playEarcon", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_12 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - playEarcon", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_13 = null;
                    this.resetCachedParams();
                    return result;
                }
                Object var8_10 = null;
                this.resetCachedParams();
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                this.resetCachedParams();
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int playSilence(long durationInMs, int queueMode, HashMap<String, String> params) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        this.setCachedParam(params, "utteranceId", 10);
                    }
                    result = this.mITts.playSilence(this.mPackageName, durationInMs, queueMode, this.mCachedParams);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - playSilence", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var9_7 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - playSilence", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var9_8 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - playSilence", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var9_9 = null;
                    this.resetCachedParams();
                    return result;
                }
                Object var9_6 = null;
                this.resetCachedParams();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.resetCachedParams();
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSpeaking() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return false;
            }
            try {
                return this.mITts.isSpeaking();
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - isSpeaking", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - isSpeaking", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - isSpeaking", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int stop() {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    return this.mITts.stop(this.mPackageName);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - stop", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - stop", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - stop", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
            }
            catch (Throwable throwable) {
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setSpeechRate(float speechRate) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (speechRate > 0.0f) {
                        int rate = (int)(speechRate * 100.0f);
                        this.mCachedParams[1] = String.valueOf(rate);
                        if (!(speechRate > 0.0f)) return -1;
                        return 0;
                    }
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - setSpeechRate", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - setSpeechRate", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setPitch(float pitch) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    if (pitch > 0.0f) {
                        int p = (int)(pitch * 100.0f);
                        this.mCachedParams[15] = String.valueOf(p);
                        return 0;
                    }
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - setPitch", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - setPitch", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setLanguage(Locale loc) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -2;
            if (!this.mStarted) {
                return result;
            }
            if (loc == null) {
                return result;
            }
            try {
                try {
                    String language = loc.getISO3Language();
                    String country = loc.getISO3Country();
                    String variant = loc.getVariant();
                    result = this.mITts.isLanguageAvailable(language, country, variant, this.mCachedParams);
                    if (result >= 0) {
                        this.mCachedParams[3] = language;
                        this.mCachedParams[5] = result >= 1 ? country : "";
                        this.mCachedParams[7] = result >= 2 ? variant : "";
                    }
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - setLanguage", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - setLanguage", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - setLanguage", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLanguage() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return null;
            }
            try {
                if (this.mCachedParams[3].length() < 1) {
                    String[] locStrings = this.mITts.getLanguage();
                    if (locStrings != null && locStrings.length == 3) {
                        return new Locale(locStrings[0], locStrings[1], locStrings[2]);
                    }
                    return null;
                }
                return new Locale(this.mCachedParams[3], this.mCachedParams[5], this.mCachedParams[7]);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeech.java - getLanguage", "RemoteException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (NullPointerException e) {
                Log.e("TextToSpeech.java - getLanguage", "NullPointerException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            catch (IllegalStateException e) {
                Log.e("TextToSpeech.java - getLanguage", "IllegalStateException");
                e.printStackTrace();
                this.mStarted = false;
                this.initTts();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isLanguageAvailable(Locale loc) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -2;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    return this.mITts.isLanguageAvailable(loc.getISO3Language(), loc.getISO3Country(), loc.getVariant(), this.mCachedParams);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - isLanguageAvailable", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - isLanguageAvailable", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - isLanguageAvailable", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
            }
            catch (Throwable throwable) {
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int synthesizeToFile(String text, HashMap<String, String> params, String filename) {
        Log.i("TextToSpeech.java", "synthesizeToFile()");
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            Log.i("TextToSpeech.java - synthesizeToFile", "synthesizeToFile text of length " + text.length());
            if (!this.mStarted) {
                Log.e("TextToSpeech.java - synthesizeToFile", "service isn't started");
                return result;
            }
            try {
                try {
                    if (params != null && !params.isEmpty()) {
                        this.setCachedParam(params, "utteranceId", 10);
                        this.setCachedParam(params, "engine", 12);
                    }
                    result = this.mITts.synthesizeToFile(this.mPackageName, text, this.mCachedParams, filename) ? 0 : -1;
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - synthesizeToFile", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_7 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - synthesizeToFile", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_8 = null;
                    this.resetCachedParams();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - synthesizeToFile", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    Object var8_9 = null;
                    this.resetCachedParams();
                    return result;
                }
                Object var8_6 = null;
                this.resetCachedParams();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.resetCachedParams();
                return result;
            }
            return result;
        }
    }

    public void resetCachedParams() {
        this.mCachedParams[9] = String.valueOf(3);
        this.mCachedParams[11] = "";
        this.mCachedParams[17] = "1.0";
        this.mCachedParams[19] = "0.0";
    }

    public void setCachedParam(HashMap<String, String> params, String key, int keyIndex) {
        String extra = params.get(key);
        if (extra != null) {
            this.mCachedParams[keyIndex + 1] = extra;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setOnUtteranceCompletedListener(final OnUtteranceCompletedListener listener) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            this.mITtscallback = new ITtsCallback.Stub(){

                public void utteranceCompleted(String utteranceId) throws RemoteException {
                    if (listener != null) {
                        listener.onUtteranceCompleted(utteranceId);
                    }
                }
            };
            try {
                try {
                    return this.mITts.registerCallback(this.mPackageName, this.mITtscallback);
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - registerCallback", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - registerCallback", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - registerCallback", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
            }
            catch (Throwable throwable) {
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setEngineByPackageName(String enginePackageName) {
        Object object = this.mStartLock;
        synchronized (object) {
            int result = -1;
            if (!this.mStarted) {
                return result;
            }
            try {
                try {
                    result = this.mITts.setEngineByPackageName(enginePackageName);
                    if (result == 0) {
                        this.mCachedParams[13] = enginePackageName;
                    }
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return result;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                return result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDefaultEngine() {
        Object object = this.mStartLock;
        synchronized (object) {
            String engineName = "";
            if (!this.mStarted) {
                return engineName;
            }
            try {
                try {
                    return this.mITts.getDefaultEngine();
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return engineName;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return engineName;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - setEngineByPackageName", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return engineName;
                }
            }
            catch (Throwable throwable) {
                return engineName;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areDefaultsEnforced() {
        Object object = this.mStartLock;
        synchronized (object) {
            boolean defaultsEnforced = false;
            if (!this.mStarted) {
                return defaultsEnforced;
            }
            try {
                try {
                    return this.mITts.areDefaultsEnforced();
                }
                catch (RemoteException e) {
                    Log.e("TextToSpeech.java - areDefaultsEnforced", "RemoteException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return defaultsEnforced;
                }
                catch (NullPointerException e) {
                    Log.e("TextToSpeech.java - areDefaultsEnforced", "NullPointerException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return defaultsEnforced;
                }
                catch (IllegalStateException e) {
                    Log.e("TextToSpeech.java - areDefaultsEnforced", "IllegalStateException");
                    e.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return defaultsEnforced;
                }
            }
            catch (Throwable throwable) {
                return defaultsEnforced;
            }
        }
    }

    public class Engine {
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_PITCH = 100;
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final String DEFAULT_VOLUME_STRING = "1.0";
        public static final float DEFAULT_PAN = 0.0f;
        public static final String DEFAULT_PAN_STRING = "0.0";
        public static final int USE_DEFAULTS = 0;
        public static final String DEFAULT_SYNTH = "com.svox.pico";
        public static final int DEFAULT_STREAM = 3;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        public static final int CHECK_VOICE_DATA_BAD_DATA = -1;
        public static final int CHECK_VOICE_DATA_MISSING_DATA = -2;
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        public static final String EXTRA_AVAILABLE_VOICES = "availableVoices";
        public static final String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        public static final String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_VARIANT = "variant";
        public static final String KEY_PARAM_ENGINE = "engine";
        public static final String KEY_PARAM_PITCH = "pitch";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static final String KEY_PARAM_VOLUME = "volume";
        public static final String KEY_PARAM_PAN = "pan";
        public static final int PARAM_POSITION_RATE = 0;
        public static final int PARAM_POSITION_LANGUAGE = 2;
        public static final int PARAM_POSITION_COUNTRY = 4;
        public static final int PARAM_POSITION_VARIANT = 6;
        public static final int PARAM_POSITION_STREAM = 8;
        public static final int PARAM_POSITION_UTTERANCE_ID = 10;
        public static final int PARAM_POSITION_ENGINE = 12;
        public static final int PARAM_POSITION_PITCH = 14;
        public static final int PARAM_POSITION_VOLUME = 16;
        public static final int PARAM_POSITION_PAN = 18;
        public static final int NB_CACHED_PARAMS = 20;
    }

    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }
}

