/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

public class MeasuredText {
    public static final boolean localLOGV = false;
    public CharSequence mText;
    public int mTextStart;
    public float[] mWidths;
    public char[] mChars;
    public byte[] mLevels;
    public int mDir;
    public boolean mEasy;
    public int mLen;
    public int mPos;
    public TextPaint mWorkPaint = new TextPaint();
    public static MeasuredText[] cached = new MeasuredText[3];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeasuredText obtain() {
        MeasuredText[] measuredTextArray = cached;
        synchronized (cached) {
            int i = cached.length;
            while (--i >= 0) {
                if (cached[i] == null) continue;
                MeasuredText mt = cached[i];
                MeasuredText.cached[i] = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                return mt;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            MeasuredText mt = new MeasuredText();
            return mt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MeasuredText recycle(MeasuredText mt) {
        mt.mText = null;
        if (mt.mLen >= 1000) return null;
        MeasuredText[] measuredTextArray = cached;
        synchronized (cached) {
            for (int i = 0; i < cached.length; ++i) {
                if (cached[i] != null) continue;
                MeasuredText.cached[i] = mt;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void setPara(CharSequence text, int start, int end, int bidiRequest) {
        int len;
        this.mText = text;
        this.mTextStart = start;
        this.mLen = len = end - start;
        this.mPos = 0;
        if (this.mWidths == null || this.mWidths.length < len) {
            this.mWidths = new float[ArrayUtils.idealFloatArraySize(len)];
        }
        if (this.mChars == null || this.mChars.length < len) {
            this.mChars = new char[ArrayUtils.idealCharArraySize(len)];
        }
        TextUtils.getChars(text, start, end, this.mChars, 0);
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            ReplacementSpan[] spans = spanned.getSpans(start, end, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int startInPara = spanned.getSpanStart(spans[i]) - start;
                int endInPara = spanned.getSpanEnd(spans[i]) - start;
                for (int j = startInPara; j < endInPara; ++j) {
                    this.mChars[j] = 65532;
                }
            }
        }
        if (TextUtils.doesNotNeedBidi(this.mChars, 0, len)) {
            this.mDir = 1;
            this.mEasy = true;
        } else {
            if (this.mLevels == null || this.mLevels.length < len) {
                this.mLevels = new byte[ArrayUtils.idealByteArraySize(len)];
            }
            this.mDir = AndroidBidi.bidi(bidiRequest, this.mChars, this.mLevels, len, false);
            this.mEasy = false;
        }
    }

    public float addStyleRun(TextPaint paint, int len, Paint.FontMetricsInt fm) {
        if (fm != null) {
            paint.getFontMetricsInt(fm);
        }
        int p = this.mPos;
        this.mPos = p + len;
        if (this.mEasy) {
            int flags = this.mDir == 1 ? 0 : 1;
            return paint.getTextRunAdvances(this.mChars, p, len, p, len, flags, this.mWidths, p);
        }
        float totalAdvance = 0.0f;
        byte level = this.mLevels[p];
        int q = p;
        int i = p + 1;
        int e = p + len;
        while (true) {
            if (i == e || this.mLevels[i] != level) {
                int flags = (level & 1) == 0 ? 0 : 1;
                totalAdvance += paint.getTextRunAdvances(this.mChars, q, i - q, q, i - q, flags, this.mWidths, q);
                if (i == e) break;
                q = i;
                level = this.mLevels[i];
            }
            ++i;
        }
        return totalAdvance;
    }

    public float addStyleRun(TextPaint paint, MetricAffectingSpan[] spans, int len, Paint.FontMetricsInt fm) {
        float wid;
        TextPaint workPaint = this.mWorkPaint;
        workPaint.set(paint);
        workPaint.baselineShift = 0;
        ReplacementSpan replacement = null;
        for (int i = 0; i < spans.length; ++i) {
            MetricAffectingSpan span = spans[i];
            if (span instanceof ReplacementSpan) {
                replacement = (ReplacementSpan)span;
                continue;
            }
            span.updateMeasureState(workPaint);
        }
        if (replacement == null) {
            wid = this.addStyleRun(workPaint, len, fm);
        } else {
            wid = replacement.getSize(workPaint, this.mText, this.mTextStart + this.mPos, this.mTextStart + this.mPos + len, fm);
            float[] w = this.mWidths;
            w[this.mPos] = wid;
            int e = this.mPos + len;
            for (int i = this.mPos + 1; i < e; ++i) {
                w[i] = 0.0f;
            }
        }
        if (fm != null) {
            if (workPaint.baselineShift < 0) {
                fm.ascent += workPaint.baselineShift;
                fm.top += workPaint.baselineShift;
            } else {
                fm.descent += workPaint.baselineShift;
                fm.bottom += workPaint.baselineShift;
            }
        }
        return wid;
    }

    public int breakText(int start, int limit, boolean forwards, float width) {
        float[] w = this.mWidths;
        if (forwards) {
            for (int i = start; i < limit; ++i) {
                float f;
                width -= w[i];
                if (!(f < 0.0f)) continue;
                return i - start;
            }
        } else {
            int i = limit;
            while (--i >= start) {
                float f;
                width -= w[i];
                if (!(f < 0.0f)) continue;
                return limit - i - 1;
            }
        }
        return limit - start;
    }

    public float measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths;
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }
}

