/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class BaseMovementMethod
implements MovementMethod {
    public boolean canSelectArbitrarily() {
        return false;
    }

    public void initialize(TextView widget, Spannable text) {
    }

    public boolean onKeyDown(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        int movementMetaState = this.getMovementMetaState(text, event);
        boolean handled = this.handleMovementKey(widget, text, keyCode, movementMetaState, event);
        if (handled) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(text);
            MetaKeyKeyListener.resetLockedMeta(text);
        }
        return handled;
    }

    public boolean onKeyOther(TextView widget, Spannable text, KeyEvent event) {
        int movementMetaState = this.getMovementMetaState(text, event);
        int keyCode = event.getKeyCode();
        if (keyCode != 0 && event.getAction() == 2) {
            int repeat = event.getRepeatCount();
            boolean handled = false;
            for (int i = 0; i < repeat && this.handleMovementKey(widget, text, keyCode, movementMetaState, event); ++i) {
                handled = true;
            }
            if (handled) {
                MetaKeyKeyListener.adjustMetaAfterKeypress(text);
                MetaKeyKeyListener.resetLockedMeta(text);
            }
            return handled;
        }
        return false;
    }

    public boolean onKeyUp(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        return false;
    }

    public void onTakeFocus(TextView widget, Spannable text, int direction) {
    }

    public boolean onTouchEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public boolean onTrackballEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public int getMovementMetaState(Spannable buffer, KeyEvent event) {
        int metaState = (event.getMetaState() | MetaKeyKeyListener.getMetaState(buffer)) & 0xFFFFF9FF;
        return KeyEvent.normalizeMetaState(metaState) & 0xFFFFFF3E;
    }

    public boolean handleMovementKey(TextView widget, Spannable buffer, int keyCode, int movementMetaState, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.left(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.lineStart(widget, buffer);
            }
            case 22: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.right(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.lineEnd(widget, buffer);
            }
            case 19: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.up(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.top(widget, buffer);
            }
            case 20: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.down(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.bottom(widget, buffer);
            }
            case 92: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.pageUp(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.top(widget, buffer);
            }
            case 93: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.pageDown(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.bottom(widget, buffer);
            }
            case 122: {
                if (!KeyEvent.metaStateHasNoModifiers(movementMetaState)) break;
                return this.home(widget, buffer);
            }
            case 123: {
                if (!KeyEvent.metaStateHasNoModifiers(movementMetaState)) break;
                return this.end(widget, buffer);
            }
        }
        return false;
    }

    public boolean left(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean right(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean up(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean down(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean pageUp(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean pageDown(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean top(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean bottom(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean lineStart(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean lineEnd(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean home(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean end(TextView widget, Spannable buffer) {
        return false;
    }
}

