/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Build;
import android.text.TextUtils;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;

public class CharsetUtils {
    public static final String VENDOR_DOCOMO = "docomo";
    public static final String VENDOR_KDDI = "kddi";
    public static final String VENDOR_SOFTBANK = "softbank";
    public static final Map<String, String> sVendorShiftJisMap = new HashMap<String, String>();

    public static String nameForVendor(String charsetName, String vendor) {
        String vendorShiftJis;
        if (!TextUtils.isEmpty(charsetName) && !TextUtils.isEmpty(vendor) && CharsetUtils.isShiftJis(charsetName) && (vendorShiftJis = sVendorShiftJisMap.get(vendor)) != null) {
            return vendorShiftJis;
        }
        return charsetName;
    }

    public static String nameForDefaultVendor(String charsetName) {
        return CharsetUtils.nameForVendor(charsetName, CharsetUtils.getDefaultVendor());
    }

    public static Charset charsetForVendor(String charsetName, String vendor) throws UnsupportedCharsetException, IllegalCharsetNameException {
        charsetName = CharsetUtils.nameForVendor(charsetName, vendor);
        return Charset.forName(charsetName);
    }

    public static Charset charsetForVendor(String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException {
        return CharsetUtils.charsetForVendor(charsetName, CharsetUtils.getDefaultVendor());
    }

    public static boolean isShiftJis(String charsetName) {
        if (charsetName == null) {
            return false;
        }
        int length = charsetName.length();
        if (length != 4 && length != 9) {
            return false;
        }
        return charsetName.equalsIgnoreCase("shift_jis") || charsetName.equalsIgnoreCase("shift-jis") || charsetName.equalsIgnoreCase("sjis");
    }

    public static String getDefaultVendor() {
        return Build.BRAND;
    }

    static {
        sVendorShiftJisMap.put(VENDOR_DOCOMO, "docomo-shift_jis-2007");
        sVendorShiftJisMap.put(VENDOR_KDDI, "kddi-shift_jis-2007");
        sVendorShiftJisMap.put(VENDOR_SOFTBANK, "softbank-shift_jis-2007");
    }
}

