/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20RecordingCanvas;
import android.view.HardwareCanvas;
import android.view.View;
import java.lang.ref.WeakReference;

public class GLES20DisplayList
extends DisplayList {
    public GLES20Canvas mCanvas;
    public boolean mStarted = false;
    public boolean mRecorded = false;
    public boolean mValid = false;
    public int mNativeDisplayList;
    public WeakReference<View> hostView;
    public DisplayListFinalizer mFinalizer;

    public GLES20DisplayList(View view) {
        this.hostView = new WeakReference<View>(view);
    }

    public void invalidateView() {
        View v = (View)this.hostView.get();
        if (v != null) {
            v.invalidate();
        }
    }

    public HardwareCanvas start() {
        if (this.mStarted) {
            throw new IllegalStateException("Recording has already started");
        }
        if (this.mCanvas != null) {
            ((GLES20RecordingCanvas)this.mCanvas).reset();
        } else {
            this.mCanvas = new GLES20RecordingCanvas(true);
        }
        this.mStarted = true;
        this.mRecorded = false;
        this.mValid = true;
        return this.mCanvas;
    }

    public void invalidate() {
        this.mStarted = false;
        this.mRecorded = false;
        this.mValid = false;
    }

    public boolean isValid() {
        return this.mValid;
    }

    public void end() {
        if (this.mCanvas != null) {
            this.mStarted = false;
            this.mRecorded = true;
            this.mNativeDisplayList = this.mCanvas.getDisplayList();
            this.mFinalizer = DisplayListFinalizer.getFinalizer(this.mFinalizer, this.mNativeDisplayList);
        }
    }

    public boolean isReady() {
        return !this.mStarted && this.mRecorded;
    }

    public static class DisplayListFinalizer {
        public int mNativeDisplayList;

        public static DisplayListFinalizer getFinalizer(DisplayListFinalizer oldFinalizer, int nativeDisplayList) {
            if (oldFinalizer == null) {
                return new DisplayListFinalizer(nativeDisplayList);
            }
            oldFinalizer.replaceNativeObject(nativeDisplayList);
            return oldFinalizer;
        }

        public DisplayListFinalizer(int nativeDisplayList) {
            this.mNativeDisplayList = nativeDisplayList;
        }

        public void replaceNativeObject(int newNativeDisplayList) {
            if (this.mNativeDisplayList != 0 && this.mNativeDisplayList != newNativeDisplayList) {
                GLES20Canvas.destroyDisplayList(this.mNativeDisplayList);
            }
            this.mNativeDisplayList = newNativeDisplayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            try {
                this.replaceNativeObject(0);
            }
            finally {
                super.finalize();
            }
        }
    }
}

