/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;

public abstract class InputEvent
implements Parcelable {
    public int mDeviceId;
    public int mSource;
    public static final int PARCEL_TOKEN_MOTION_EVENT = 1;
    public static final int PARCEL_TOKEN_KEY_EVENT = 2;
    public static final Parcelable.Creator<InputEvent> CREATOR = new Parcelable.Creator<InputEvent>(){

        @Override
        public InputEvent createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 2) {
                return KeyEvent.createFromParcelBody(in);
            }
            if (token == 1) {
                return MotionEvent.createFromParcelBody(in);
            }
            throw new IllegalStateException("Unexpected input event type token in parcel.");
        }

        public InputEvent[] newArray(int size) {
            return new InputEvent[size];
        }
    };

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public InputDevice getDevice() {
        return InputDevice.getDevice(this.mDeviceId);
    }

    public int getSource() {
        return this.mSource;
    }

    public void setSource(int source) {
        this.mSource = source;
    }

    public int describeContents() {
        return 0;
    }

    public void readBaseFromParcel(Parcel in) {
        this.mDeviceId = in.readInt();
        this.mSource = in.readInt();
    }

    public void writeBaseToParcel(Parcel out) {
        out.writeInt(this.mDeviceId);
        out.writeInt(this.mSource);
    }
}

