/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import android.view.InputEvent;
import android.view.KeyCharacterMap;
import com.android.tools.layoutlib.create.OverrideMethod;

public class KeyEvent
extends InputEvent
implements Parcelable {
    public static final int KEYCODE_UNKNOWN = 0;
    public static final int KEYCODE_SOFT_LEFT = 1;
    public static final int KEYCODE_SOFT_RIGHT = 2;
    public static final int KEYCODE_HOME = 3;
    public static final int KEYCODE_BACK = 4;
    public static final int KEYCODE_CALL = 5;
    public static final int KEYCODE_ENDCALL = 6;
    public static final int KEYCODE_0 = 7;
    public static final int KEYCODE_1 = 8;
    public static final int KEYCODE_2 = 9;
    public static final int KEYCODE_3 = 10;
    public static final int KEYCODE_4 = 11;
    public static final int KEYCODE_5 = 12;
    public static final int KEYCODE_6 = 13;
    public static final int KEYCODE_7 = 14;
    public static final int KEYCODE_8 = 15;
    public static final int KEYCODE_9 = 16;
    public static final int KEYCODE_STAR = 17;
    public static final int KEYCODE_POUND = 18;
    public static final int KEYCODE_DPAD_UP = 19;
    public static final int KEYCODE_DPAD_DOWN = 20;
    public static final int KEYCODE_DPAD_LEFT = 21;
    public static final int KEYCODE_DPAD_RIGHT = 22;
    public static final int KEYCODE_DPAD_CENTER = 23;
    public static final int KEYCODE_VOLUME_UP = 24;
    public static final int KEYCODE_VOLUME_DOWN = 25;
    public static final int KEYCODE_POWER = 26;
    public static final int KEYCODE_CAMERA = 27;
    public static final int KEYCODE_CLEAR = 28;
    public static final int KEYCODE_A = 29;
    public static final int KEYCODE_B = 30;
    public static final int KEYCODE_C = 31;
    public static final int KEYCODE_D = 32;
    public static final int KEYCODE_E = 33;
    public static final int KEYCODE_F = 34;
    public static final int KEYCODE_G = 35;
    public static final int KEYCODE_H = 36;
    public static final int KEYCODE_I = 37;
    public static final int KEYCODE_J = 38;
    public static final int KEYCODE_K = 39;
    public static final int KEYCODE_L = 40;
    public static final int KEYCODE_M = 41;
    public static final int KEYCODE_N = 42;
    public static final int KEYCODE_O = 43;
    public static final int KEYCODE_P = 44;
    public static final int KEYCODE_Q = 45;
    public static final int KEYCODE_R = 46;
    public static final int KEYCODE_S = 47;
    public static final int KEYCODE_T = 48;
    public static final int KEYCODE_U = 49;
    public static final int KEYCODE_V = 50;
    public static final int KEYCODE_W = 51;
    public static final int KEYCODE_X = 52;
    public static final int KEYCODE_Y = 53;
    public static final int KEYCODE_Z = 54;
    public static final int KEYCODE_COMMA = 55;
    public static final int KEYCODE_PERIOD = 56;
    public static final int KEYCODE_ALT_LEFT = 57;
    public static final int KEYCODE_ALT_RIGHT = 58;
    public static final int KEYCODE_SHIFT_LEFT = 59;
    public static final int KEYCODE_SHIFT_RIGHT = 60;
    public static final int KEYCODE_TAB = 61;
    public static final int KEYCODE_SPACE = 62;
    public static final int KEYCODE_SYM = 63;
    public static final int KEYCODE_EXPLORER = 64;
    public static final int KEYCODE_ENVELOPE = 65;
    public static final int KEYCODE_ENTER = 66;
    public static final int KEYCODE_DEL = 67;
    public static final int KEYCODE_GRAVE = 68;
    public static final int KEYCODE_MINUS = 69;
    public static final int KEYCODE_EQUALS = 70;
    public static final int KEYCODE_LEFT_BRACKET = 71;
    public static final int KEYCODE_RIGHT_BRACKET = 72;
    public static final int KEYCODE_BACKSLASH = 73;
    public static final int KEYCODE_SEMICOLON = 74;
    public static final int KEYCODE_APOSTROPHE = 75;
    public static final int KEYCODE_SLASH = 76;
    public static final int KEYCODE_AT = 77;
    public static final int KEYCODE_NUM = 78;
    public static final int KEYCODE_HEADSETHOOK = 79;
    public static final int KEYCODE_FOCUS = 80;
    public static final int KEYCODE_PLUS = 81;
    public static final int KEYCODE_MENU = 82;
    public static final int KEYCODE_NOTIFICATION = 83;
    public static final int KEYCODE_SEARCH = 84;
    public static final int KEYCODE_MEDIA_PLAY_PAUSE = 85;
    public static final int KEYCODE_MEDIA_STOP = 86;
    public static final int KEYCODE_MEDIA_NEXT = 87;
    public static final int KEYCODE_MEDIA_PREVIOUS = 88;
    public static final int KEYCODE_MEDIA_REWIND = 89;
    public static final int KEYCODE_MEDIA_FAST_FORWARD = 90;
    public static final int KEYCODE_MUTE = 91;
    public static final int KEYCODE_PAGE_UP = 92;
    public static final int KEYCODE_PAGE_DOWN = 93;
    public static final int KEYCODE_PICTSYMBOLS = 94;
    public static final int KEYCODE_SWITCH_CHARSET = 95;
    public static final int KEYCODE_BUTTON_A = 96;
    public static final int KEYCODE_BUTTON_B = 97;
    public static final int KEYCODE_BUTTON_C = 98;
    public static final int KEYCODE_BUTTON_X = 99;
    public static final int KEYCODE_BUTTON_Y = 100;
    public static final int KEYCODE_BUTTON_Z = 101;
    public static final int KEYCODE_BUTTON_L1 = 102;
    public static final int KEYCODE_BUTTON_R1 = 103;
    public static final int KEYCODE_BUTTON_L2 = 104;
    public static final int KEYCODE_BUTTON_R2 = 105;
    public static final int KEYCODE_BUTTON_THUMBL = 106;
    public static final int KEYCODE_BUTTON_THUMBR = 107;
    public static final int KEYCODE_BUTTON_START = 108;
    public static final int KEYCODE_BUTTON_SELECT = 109;
    public static final int KEYCODE_BUTTON_MODE = 110;
    public static final int KEYCODE_ESCAPE = 111;
    public static final int KEYCODE_FORWARD_DEL = 112;
    public static final int KEYCODE_CTRL_LEFT = 113;
    public static final int KEYCODE_CTRL_RIGHT = 114;
    public static final int KEYCODE_CAPS_LOCK = 115;
    public static final int KEYCODE_SCROLL_LOCK = 116;
    public static final int KEYCODE_META_LEFT = 117;
    public static final int KEYCODE_META_RIGHT = 118;
    public static final int KEYCODE_FUNCTION = 119;
    public static final int KEYCODE_SYSRQ = 120;
    public static final int KEYCODE_BREAK = 121;
    public static final int KEYCODE_MOVE_HOME = 122;
    public static final int KEYCODE_MOVE_END = 123;
    public static final int KEYCODE_INSERT = 124;
    public static final int KEYCODE_FORWARD = 125;
    public static final int KEYCODE_MEDIA_PLAY = 126;
    public static final int KEYCODE_MEDIA_PAUSE = 127;
    public static final int KEYCODE_MEDIA_CLOSE = 128;
    public static final int KEYCODE_MEDIA_EJECT = 129;
    public static final int KEYCODE_MEDIA_RECORD = 130;
    public static final int KEYCODE_F1 = 131;
    public static final int KEYCODE_F2 = 132;
    public static final int KEYCODE_F3 = 133;
    public static final int KEYCODE_F4 = 134;
    public static final int KEYCODE_F5 = 135;
    public static final int KEYCODE_F6 = 136;
    public static final int KEYCODE_F7 = 137;
    public static final int KEYCODE_F8 = 138;
    public static final int KEYCODE_F9 = 139;
    public static final int KEYCODE_F10 = 140;
    public static final int KEYCODE_F11 = 141;
    public static final int KEYCODE_F12 = 142;
    public static final int KEYCODE_NUM_LOCK = 143;
    public static final int KEYCODE_NUMPAD_0 = 144;
    public static final int KEYCODE_NUMPAD_1 = 145;
    public static final int KEYCODE_NUMPAD_2 = 146;
    public static final int KEYCODE_NUMPAD_3 = 147;
    public static final int KEYCODE_NUMPAD_4 = 148;
    public static final int KEYCODE_NUMPAD_5 = 149;
    public static final int KEYCODE_NUMPAD_6 = 150;
    public static final int KEYCODE_NUMPAD_7 = 151;
    public static final int KEYCODE_NUMPAD_8 = 152;
    public static final int KEYCODE_NUMPAD_9 = 153;
    public static final int KEYCODE_NUMPAD_DIVIDE = 154;
    public static final int KEYCODE_NUMPAD_MULTIPLY = 155;
    public static final int KEYCODE_NUMPAD_SUBTRACT = 156;
    public static final int KEYCODE_NUMPAD_ADD = 157;
    public static final int KEYCODE_NUMPAD_DOT = 158;
    public static final int KEYCODE_NUMPAD_COMMA = 159;
    public static final int KEYCODE_NUMPAD_ENTER = 160;
    public static final int KEYCODE_NUMPAD_EQUALS = 161;
    public static final int KEYCODE_NUMPAD_LEFT_PAREN = 162;
    public static final int KEYCODE_NUMPAD_RIGHT_PAREN = 163;
    public static final int KEYCODE_VOLUME_MUTE = 164;
    public static final int KEYCODE_INFO = 165;
    public static final int KEYCODE_CHANNEL_UP = 166;
    public static final int KEYCODE_CHANNEL_DOWN = 167;
    public static final int KEYCODE_ZOOM_IN = 168;
    public static final int KEYCODE_ZOOM_OUT = 169;
    public static final int KEYCODE_TV = 170;
    public static final int KEYCODE_WINDOW = 171;
    public static final int KEYCODE_GUIDE = 172;
    public static final int KEYCODE_DVR = 173;
    public static final int KEYCODE_BOOKMARK = 174;
    public static final int KEYCODE_CAPTIONS = 175;
    public static final int KEYCODE_SETTINGS = 176;
    public static final int KEYCODE_TV_POWER = 177;
    public static final int KEYCODE_TV_INPUT = 178;
    public static final int KEYCODE_STB_POWER = 179;
    public static final int KEYCODE_STB_INPUT = 180;
    public static final int KEYCODE_AVR_POWER = 181;
    public static final int KEYCODE_AVR_INPUT = 182;
    public static final int KEYCODE_PROG_RED = 183;
    public static final int KEYCODE_PROG_GREEN = 184;
    public static final int KEYCODE_PROG_YELLOW = 185;
    public static final int KEYCODE_PROG_BLUE = 186;
    public static final int KEYCODE_APP_SWITCH = 187;
    public static final int LAST_KEYCODE = 187;
    public static final String[] KEYCODE_SYMBOLIC_NAMES = new String[]{"KEYCODE_UNKNOWN", "KEYCODE_SOFT_LEFT", "KEYCODE_SOFT_RIGHT", "KEYCODE_HOME", "KEYCODE_BACK", "KEYCODE_CALL", "KEYCODE_ENDCALL", "KEYCODE_0", "KEYCODE_1", "KEYCODE_2", "KEYCODE_3", "KEYCODE_4", "KEYCODE_5", "KEYCODE_6", "KEYCODE_7", "KEYCODE_8", "KEYCODE_9", "KEYCODE_STAR", "KEYCODE_POUND", "KEYCODE_DPAD_UP", "KEYCODE_DPAD_DOWN", "KEYCODE_DPAD_LEFT", "KEYCODE_DPAD_RIGHT", "KEYCODE_DPAD_CENTER", "KEYCODE_VOLUME_UP", "KEYCODE_VOLUME_DOWN", "KEYCODE_POWER", "KEYCODE_CAMERA", "KEYCODE_CLEAR", "KEYCODE_A", "KEYCODE_B", "KEYCODE_C", "KEYCODE_D", "KEYCODE_E", "KEYCODE_F", "KEYCODE_G", "KEYCODE_H", "KEYCODE_I", "KEYCODE_J", "KEYCODE_K", "KEYCODE_L", "KEYCODE_M", "KEYCODE_N", "KEYCODE_O", "KEYCODE_P", "KEYCODE_Q", "KEYCODE_R", "KEYCODE_S", "KEYCODE_T", "KEYCODE_U", "KEYCODE_V", "KEYCODE_W", "KEYCODE_X", "KEYCODE_Y", "KEYCODE_Z", "KEYCODE_COMMA", "KEYCODE_PERIOD", "KEYCODE_ALT_LEFT", "KEYCODE_ALT_RIGHT", "KEYCODE_SHIFT_LEFT", "KEYCODE_SHIFT_RIGHT", "KEYCODE_TAB", "KEYCODE_SPACE", "KEYCODE_SYM", "KEYCODE_EXPLORER", "KEYCODE_ENVELOPE", "KEYCODE_ENTER", "KEYCODE_DEL", "KEYCODE_GRAVE", "KEYCODE_MINUS", "KEYCODE_EQUALS", "KEYCODE_LEFT_BRACKET", "KEYCODE_RIGHT_BRACKET", "KEYCODE_BACKSLASH", "KEYCODE_SEMICOLON", "KEYCODE_APOSTROPHE", "KEYCODE_SLASH", "KEYCODE_AT", "KEYCODE_NUM", "KEYCODE_HEADSETHOOK", "KEYCODE_FOCUS", "KEYCODE_PLUS", "KEYCODE_MENU", "KEYCODE_NOTIFICATION", "KEYCODE_SEARCH", "KEYCODE_MEDIA_PLAY_PAUSE", "KEYCODE_MEDIA_STOP", "KEYCODE_MEDIA_NEXT", "KEYCODE_MEDIA_PREVIOUS", "KEYCODE_MEDIA_REWIND", "KEYCODE_MEDIA_FAST_FORWARD", "KEYCODE_MUTE", "KEYCODE_PAGE_UP", "KEYCODE_PAGE_DOWN", "KEYCODE_PICTSYMBOLS", "KEYCODE_SWITCH_CHARSET", "KEYCODE_BUTTON_A", "KEYCODE_BUTTON_B", "KEYCODE_BUTTON_C", "KEYCODE_BUTTON_X", "KEYCODE_BUTTON_Y", "KEYCODE_BUTTON_Z", "KEYCODE_BUTTON_L1", "KEYCODE_BUTTON_R1", "KEYCODE_BUTTON_L2", "KEYCODE_BUTTON_R2", "KEYCODE_BUTTON_THUMBL", "KEYCODE_BUTTON_THUMBR", "KEYCODE_BUTTON_START", "KEYCODE_BUTTON_SELECT", "KEYCODE_BUTTON_MODE", "KEYCODE_ESCAPE", "KEYCODE_FORWARD_DEL", "KEYCODE_CTRL_LEFT", "KEYCODE_CTRL_RIGHT", "KEYCODE_CAPS_LOCK", "KEYCODE_SCROLL_LOCK", "KEYCODE_META_LEFT", "KEYCODE_META_RIGHT", "KEYCODE_FUNCTION", "KEYCODE_SYSRQ", "KEYCODE_BREAK", "KEYCODE_MOVE_HOME", "KEYCODE_MOVE_END", "KEYCODE_INSERT", "KEYCODE_FORWARD", "KEYCODE_MEDIA_PLAY", "KEYCODE_MEDIA_PAUSE", "KEYCODE_MEDIA_CLOSE", "KEYCODE_MEDIA_EJECT", "KEYCODE_MEDIA_RECORD", "KEYCODE_F1", "KEYCODE_F2", "KEYCODE_F3", "KEYCODE_F4", "KEYCODE_F5", "KEYCODE_F6", "KEYCODE_F7", "KEYCODE_F8", "KEYCODE_F9", "KEYCODE_F10", "KEYCODE_F11", "KEYCODE_F12", "KEYCODE_NUM_LOCK", "KEYCODE_NUMPAD_0", "KEYCODE_NUMPAD_1", "KEYCODE_NUMPAD_2", "KEYCODE_NUMPAD_3", "KEYCODE_NUMPAD_4", "KEYCODE_NUMPAD_5", "KEYCODE_NUMPAD_6", "KEYCODE_NUMPAD_7", "KEYCODE_NUMPAD_8", "KEYCODE_NUMPAD_9", "KEYCODE_NUMPAD_DIVIDE", "KEYCODE_NUMPAD_MULTIPLY", "KEYCODE_MUMPAD_SUBTRACT", "KEYCODE_NUMPAD_ADD", "KEYCODE_NUMPAD_DOT", "KEYCODE_NUMPAD_COMMA", "KEYCODE_NUMPAD_ENTER", "KEYCODE_NUMPAD_EQUALS", "KEYCODE_NUMPAD_LEFT_PAREN", "KEYCODE_NUMPAD_RIGHT_PAREN", "KEYCODE_VOLUME_MUTE", "KEYCODE_INFO", "KEYCODE_CHANNEL_UP", "KEYCODE_CHANNEL_DOWN", "KEYCODE_ZOOM_IN", "KEYCODE_ZOOM_OUT", "KEYCODE_TV", "KEYCODE_WINDOW", "KEYCODE_GUIDE", "KEYCODE_DVR", "KEYCODE_BOOKMARK", "KEYCODE_CAPTIONS", "KEYCODE_SETTINGS", "KEYCODE_TV_POWER", "KEYCODE_TV_INPUT", "KEYCODE_STB_INPUT", "KEYCODE_STB_POWER", "KEYCODE_AVR_POWER", "KEYCODE_AVR_INPUT", "KEYCODE_PROG_RED", "KEYCODE_PROG_GREEN", "KEYCODE_PROG_YELLOW", "KEYCODE_PROG_BLUE", "KEYCODE_APP_SWITCH"};
    public static final String[] META_SYMBOLIC_NAMES = new String[]{"META_SHIFT_ON", "META_ALT_ON", "META_SYM_ON", "META_FUNCTION_ON", "META_ALT_LEFT_ON", "META_ALT_RIGHT_ON", "META_SHIFT_LEFT_ON", "META_SHIFT_RIGHT_ON", "META_CAP_LOCKED", "META_ALT_LOCKED", "META_SYM_LOCKED", "0x00000800", "META_CTRL_ON", "META_CTRL_LEFT_ON", "META_CTRL_RIGHT_ON", "0x00008000", "META_META_ON", "META_META_LEFT_ON", "META_META_RIGHT_ON", "0x00080000", "META_CAPS_LOCK_ON", "META_NUM_LOCK_ON", "META_SCROLL_LOCK_ON", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
    @Deprecated
    public static final int MAX_KEYCODE = 84;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MULTIPLE = 2;
    public static final int META_CAP_LOCKED = 256;
    public static final int META_ALT_LOCKED = 512;
    public static final int META_SYM_LOCKED = 1024;
    public static final int META_SELECTING = 2048;
    public static final int META_ALT_ON = 2;
    public static final int META_ALT_LEFT_ON = 16;
    public static final int META_ALT_RIGHT_ON = 32;
    public static final int META_SHIFT_ON = 1;
    public static final int META_SHIFT_LEFT_ON = 64;
    public static final int META_SHIFT_RIGHT_ON = 128;
    public static final int META_SYM_ON = 4;
    public static final int META_FUNCTION_ON = 8;
    public static final int META_CTRL_ON = 4096;
    public static final int META_CTRL_LEFT_ON = 8192;
    public static final int META_CTRL_RIGHT_ON = 16384;
    public static final int META_META_ON = 65536;
    public static final int META_META_LEFT_ON = 131072;
    public static final int META_META_RIGHT_ON = 262144;
    public static final int META_CAPS_LOCK_ON = 0x100000;
    public static final int META_NUM_LOCK_ON = 0x200000;
    public static final int META_SCROLL_LOCK_ON = 0x400000;
    public static final int META_SHIFT_MASK = 193;
    public static final int META_ALT_MASK = 50;
    public static final int META_CTRL_MASK = 28672;
    public static final int META_META_MASK = 458752;
    public static final int FLAG_WOKE_HERE = 1;
    public static final int FLAG_SOFT_KEYBOARD = 2;
    public static final int FLAG_KEEP_TOUCH_MODE = 4;
    public static final int FLAG_FROM_SYSTEM = 8;
    public static final int FLAG_EDITOR_ACTION = 16;
    public static final int FLAG_CANCELED = 32;
    public static final int FLAG_VIRTUAL_HARD_KEY = 64;
    public static final int FLAG_LONG_PRESS = 128;
    public static final int FLAG_CANCELED_LONG_PRESS = 256;
    public static final int FLAG_TRACKING = 512;
    public static final int FLAG_FALLBACK = 1024;
    public static final int FLAG_START_TRACKING = 0x40000000;
    public static final boolean DEBUG = false;
    public static final String TAG = "KeyEvent";
    public static final int MAX_RECYCLED = 10;
    public static final Object gRecyclerLock = new Object();
    public static int gRecyclerUsed;
    public static KeyEvent gRecyclerTop;
    public KeyEvent mNext;
    public boolean mRecycled;
    public int mMetaState;
    public int mAction;
    public int mKeyCode;
    public int mScanCode;
    public int mRepeatCount;
    public int mFlags;
    public long mDownTime;
    public long mEventTime;
    public String mCharacters;
    public static final int META_MODIFIER_MASK = 487679;
    public static final int META_LOCK_MASK = 0x700000;
    public static final int META_ALL_MASK = 0x7770FF;
    public static final int META_SYNTHETIC_MASK = 3840;
    public static final int META_INVALID_MODIFIER_MASK = 0x700F00;
    public static final Parcelable.Creator<KeyEvent> CREATOR;

    public static int getMaxKeyCode() {
        return 187;
    }

    public static int getDeadChar(int accent, int c) {
        return KeyCharacterMap.getDeadChar(accent, c);
    }

    public KeyEvent() {
    }

    public KeyEvent(int action, int code) {
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = 0;
        this.mDeviceId = -1;
    }

    public KeyEvent(long downTime, long eventTime, int action, int code, int repeat) {
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = repeat;
        this.mDeviceId = -1;
    }

    public KeyEvent(long downTime, long eventTime, int action, int code, int repeat, int metaState) {
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = repeat;
        this.mMetaState = metaState;
        this.mDeviceId = -1;
    }

    public KeyEvent(long downTime, long eventTime, int action, int code, int repeat, int metaState, int deviceId, int scancode) {
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = repeat;
        this.mMetaState = metaState;
        this.mDeviceId = deviceId;
        this.mScanCode = scancode;
    }

    public KeyEvent(long downTime, long eventTime, int action, int code, int repeat, int metaState, int deviceId, int scancode, int flags) {
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = repeat;
        this.mMetaState = metaState;
        this.mDeviceId = deviceId;
        this.mScanCode = scancode;
        this.mFlags = flags;
    }

    public KeyEvent(long downTime, long eventTime, int action, int code, int repeat, int metaState, int deviceId, int scancode, int flags, int source) {
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mAction = action;
        this.mKeyCode = code;
        this.mRepeatCount = repeat;
        this.mMetaState = metaState;
        this.mDeviceId = deviceId;
        this.mScanCode = scancode;
        this.mFlags = flags;
        this.mSource = source;
    }

    public KeyEvent(long time, String characters, int deviceId, int flags) {
        this.mDownTime = time;
        this.mEventTime = time;
        this.mCharacters = characters;
        this.mAction = 2;
        this.mKeyCode = 0;
        this.mRepeatCount = 0;
        this.mDeviceId = deviceId;
        this.mFlags = flags;
        this.mSource = 257;
    }

    public KeyEvent(KeyEvent origEvent) {
        this.mDownTime = origEvent.mDownTime;
        this.mEventTime = origEvent.mEventTime;
        this.mAction = origEvent.mAction;
        this.mKeyCode = origEvent.mKeyCode;
        this.mRepeatCount = origEvent.mRepeatCount;
        this.mMetaState = origEvent.mMetaState;
        this.mDeviceId = origEvent.mDeviceId;
        this.mSource = origEvent.mSource;
        this.mScanCode = origEvent.mScanCode;
        this.mFlags = origEvent.mFlags;
        this.mCharacters = origEvent.mCharacters;
    }

    @Deprecated
    public KeyEvent(KeyEvent origEvent, long eventTime, int newRepeat) {
        this.mDownTime = origEvent.mDownTime;
        this.mEventTime = eventTime;
        this.mAction = origEvent.mAction;
        this.mKeyCode = origEvent.mKeyCode;
        this.mRepeatCount = newRepeat;
        this.mMetaState = origEvent.mMetaState;
        this.mDeviceId = origEvent.mDeviceId;
        this.mSource = origEvent.mSource;
        this.mScanCode = origEvent.mScanCode;
        this.mFlags = origEvent.mFlags;
        this.mCharacters = origEvent.mCharacters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyEvent obtain() {
        KeyEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            ev = gRecyclerTop;
            if (ev == null) {
                return new KeyEvent();
            }
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mRecycled = false;
        ev.mNext = null;
        return ev;
    }

    public static KeyEvent obtain(long downTime, long eventTime, int action, int code, int repeat, int metaState, int deviceId, int scancode, int flags, int source, String characters) {
        KeyEvent ev = KeyEvent.obtain();
        ev.mDownTime = downTime;
        ev.mEventTime = eventTime;
        ev.mAction = action;
        ev.mKeyCode = code;
        ev.mRepeatCount = repeat;
        ev.mMetaState = metaState;
        ev.mDeviceId = deviceId;
        ev.mScanCode = scancode;
        ev.mFlags = flags;
        ev.mSource = source;
        ev.mCharacters = characters;
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        this.mCharacters = null;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public static KeyEvent changeTimeRepeat(KeyEvent event, long eventTime, int newRepeat) {
        return new KeyEvent(event, eventTime, newRepeat);
    }

    public static KeyEvent changeTimeRepeat(KeyEvent event, long eventTime, int newRepeat, int newFlags) {
        KeyEvent ret = new KeyEvent(event);
        ret.mEventTime = eventTime;
        ret.mRepeatCount = newRepeat;
        ret.mFlags = newFlags;
        return ret;
    }

    public KeyEvent(KeyEvent origEvent, int action) {
        this.mDownTime = origEvent.mDownTime;
        this.mEventTime = origEvent.mEventTime;
        this.mAction = action;
        this.mKeyCode = origEvent.mKeyCode;
        this.mRepeatCount = origEvent.mRepeatCount;
        this.mMetaState = origEvent.mMetaState;
        this.mDeviceId = origEvent.mDeviceId;
        this.mSource = origEvent.mSource;
        this.mScanCode = origEvent.mScanCode;
        this.mFlags = origEvent.mFlags;
    }

    public static KeyEvent changeAction(KeyEvent event, int action) {
        return new KeyEvent(event, action);
    }

    public static KeyEvent changeFlags(KeyEvent event, int flags) {
        event = new KeyEvent(event);
        event.mFlags = flags;
        return event;
    }

    @Deprecated
    public boolean isDown() {
        return this.mAction == 0;
    }

    public boolean isSystem() {
        return this.native_isSystemKey(this.mKeyCode);
    }

    public boolean hasDefaultAction() {
        return this.native_hasDefaultAction(this.mKeyCode);
    }

    public int getMetaState() {
        return this.mMetaState;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public static int getModifierMetaStateMask() {
        return 487679;
    }

    public static boolean isModifierKey(int keyCode) {
        switch (keyCode) {
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 78: 
            case 113: 
            case 114: 
            case 117: 
            case 118: 
            case 119: {
                return true;
            }
        }
        return false;
    }

    public static int normalizeMetaState(int metaState) {
        if ((metaState & 0xC0) != 0) {
            metaState |= 1;
        }
        if ((metaState & 0x30) != 0) {
            metaState |= 2;
        }
        if ((metaState & 0x6000) != 0) {
            metaState |= 0x1000;
        }
        if ((metaState & 0x60000) != 0) {
            metaState |= 0x10000;
        }
        if ((metaState & 0x100) != 0) {
            metaState |= 0x100000;
        }
        if ((metaState & 0x200) != 0) {
            metaState |= 2;
        }
        if ((metaState & 0x400) != 0) {
            metaState |= 4;
        }
        return metaState & 0x7770FF;
    }

    public static boolean metaStateHasNoModifiers(int metaState) {
        return (KeyEvent.normalizeMetaState(metaState) & 0x770FF) == 0;
    }

    public static boolean metaStateHasModifiers(int metaState, int modifiers) {
        if ((modifiers & 0x700F00) != 0) {
            throw new IllegalArgumentException("modifiers must not contain META_CAPS_LOCK_ON, META_NUM_LOCK_ON, META_SCROLL_LOCK_ON, META_CAP_LOCKED, META_ALT_LOCKED, META_SYM_LOCKED, or META_SELECTING");
        }
        metaState = KeyEvent.normalizeMetaState(metaState) & 0x770FF;
        metaState = KeyEvent.metaStateFilterDirectionalModifiers(metaState, modifiers, 1, 64, 128);
        metaState = KeyEvent.metaStateFilterDirectionalModifiers(metaState, modifiers, 2, 16, 32);
        metaState = KeyEvent.metaStateFilterDirectionalModifiers(metaState, modifiers, 4096, 8192, 16384);
        return (metaState = KeyEvent.metaStateFilterDirectionalModifiers(metaState, modifiers, 65536, 131072, 262144)) == modifiers;
    }

    public static int metaStateFilterDirectionalModifiers(int metaState, int modifiers, int basic, int left, int right) {
        boolean wantLeftOrRight;
        boolean wantBasic = (modifiers & basic) != 0;
        int directional = left | right;
        boolean bl = wantLeftOrRight = (modifiers & directional) != 0;
        if (wantBasic) {
            if (wantLeftOrRight) {
                throw new IllegalArgumentException("modifiers must not contain " + KeyEvent.metaStateToString(basic) + " combined with " + KeyEvent.metaStateToString(left) + " or " + KeyEvent.metaStateToString(right));
            }
            return metaState & ~directional;
        }
        if (wantLeftOrRight) {
            return metaState & ~basic;
        }
        return metaState;
    }

    public boolean hasNoModifiers() {
        return KeyEvent.metaStateHasNoModifiers(this.mMetaState);
    }

    public boolean hasModifiers(int modifiers) {
        return KeyEvent.metaStateHasModifiers(this.mMetaState, modifiers);
    }

    public boolean isAltPressed() {
        return (this.mMetaState & 2) != 0;
    }

    public boolean isShiftPressed() {
        return (this.mMetaState & 1) != 0;
    }

    public boolean isSymPressed() {
        return (this.mMetaState & 4) != 0;
    }

    public boolean isCtrlPressed() {
        return (this.mMetaState & 0x1000) != 0;
    }

    public boolean isMetaPressed() {
        return (this.mMetaState & 0x10000) != 0;
    }

    public boolean isFunctionPressed() {
        return (this.mMetaState & 8) != 0;
    }

    public boolean isCapsLockOn() {
        return (this.mMetaState & 0x100000) != 0;
    }

    public boolean isNumLockOn() {
        return (this.mMetaState & 0x200000) != 0;
    }

    public boolean isScrollLockOn() {
        return (this.mMetaState & 0x400000) != 0;
    }

    public int getAction() {
        return this.mAction;
    }

    public boolean isCanceled() {
        return (this.mFlags & 0x20) != 0;
    }

    public void startTracking() {
        this.mFlags |= 0x40000000;
    }

    public boolean isTracking() {
        return (this.mFlags & 0x200) != 0;
    }

    public boolean isLongPress() {
        return (this.mFlags & 0x80) != 0;
    }

    public int getKeyCode() {
        return this.mKeyCode;
    }

    public String getCharacters() {
        return this.mCharacters;
    }

    public int getScanCode() {
        return this.mScanCode;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public long getDownTime() {
        return this.mDownTime;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    @Deprecated
    public int getKeyboardDevice() {
        return this.mDeviceId;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return KeyCharacterMap.load(this.mDeviceId);
    }

    public char getDisplayLabel() {
        return this.getKeyCharacterMap().getDisplayLabel(this.mKeyCode);
    }

    public int getUnicodeChar() {
        return this.getUnicodeChar(this.mMetaState);
    }

    public int getUnicodeChar(int metaState) {
        return this.getKeyCharacterMap().get(this.mKeyCode, metaState);
    }

    @Deprecated
    public boolean getKeyData(KeyCharacterMap.KeyData results) {
        return this.getKeyCharacterMap().getKeyData(this.mKeyCode, results);
    }

    public char getMatch(char[] chars) {
        return this.getMatch(chars, 0);
    }

    public char getMatch(char[] chars, int metaState) {
        return this.getKeyCharacterMap().getMatch(this.mKeyCode, chars, metaState);
    }

    public char getNumber() {
        return this.getKeyCharacterMap().getNumber(this.mKeyCode);
    }

    public boolean isPrintingKey() {
        return this.getKeyCharacterMap().isPrintingKey(this.mKeyCode);
    }

    @Deprecated
    public boolean dispatch(Callback receiver) {
        return this.dispatch(receiver, null, null);
    }

    public boolean dispatch(Callback receiver, DispatcherState state, Object target) {
        switch (this.mAction) {
            case 0: {
                this.mFlags &= 0xBFFFFFFF;
                boolean res = receiver.onKeyDown(this.mKeyCode, this);
                if (state != null) {
                    if (res && this.mRepeatCount == 0 && (this.mFlags & 0x40000000) != 0) {
                        state.startTracking(this, target);
                    } else if (this.isLongPress() && state.isTracking(this)) {
                        try {
                            if (receiver.onKeyLongPress(this.mKeyCode, this)) {
                                state.performedLongPress(this);
                                res = true;
                            }
                        }
                        catch (AbstractMethodError e) {
                            // empty catch block
                        }
                    }
                }
                return res;
            }
            case 1: {
                if (state != null) {
                    state.handleUpEvent(this);
                }
                return receiver.onKeyUp(this.mKeyCode, this);
            }
            case 2: {
                int count = this.mRepeatCount;
                int code = this.mKeyCode;
                if (receiver.onKeyMultiple(code, count, this)) {
                    return true;
                }
                if (code != 0) {
                    this.mAction = 0;
                    this.mRepeatCount = 0;
                    boolean handled = receiver.onKeyDown(code, this);
                    if (handled) {
                        this.mAction = 1;
                        receiver.onKeyUp(code, this);
                    }
                    this.mAction = 2;
                    this.mRepeatCount = count;
                    return handled;
                }
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "KeyEvent{action=" + KeyEvent.actionToString(this.mAction) + " keycode=" + KeyEvent.keyCodeToString(this.mKeyCode) + " scancode=" + this.mScanCode + " metaState=" + KeyEvent.metaStateToString(this.mMetaState) + " flags=0x" + Integer.toHexString(this.mFlags) + " repeat=" + this.mRepeatCount + " device=" + this.mDeviceId + " source=0x" + Integer.toHexString(this.mSource) + "}";
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 2: {
                return "ACTION_MULTIPLE";
            }
        }
        return Integer.toString(action);
    }

    public static String keyCodeToString(int keyCode) {
        if (keyCode >= 0 && keyCode < KEYCODE_SYMBOLIC_NAMES.length) {
            return KEYCODE_SYMBOLIC_NAMES[keyCode];
        }
        return Integer.toString(keyCode);
    }

    public static int keyCodeFromString(String symbolicName) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("symbolicName must not be null");
        }
        int count = KEYCODE_SYMBOLIC_NAMES.length;
        for (int i = 0; i < count; ++i) {
            if (!symbolicName.equals(KEYCODE_SYMBOLIC_NAMES[i])) continue;
            return i;
        }
        try {
            return Integer.parseInt(symbolicName, 10);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String metaStateToString(int metaState) {
        if (metaState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (metaState != 0) {
            boolean isSet = (metaState & 1) != 0;
            metaState >>>= 1;
            if (isSet) {
                String name = META_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (metaState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static KeyEvent createFromParcelBody(Parcel in) {
        return new KeyEvent(in);
    }

    public KeyEvent(Parcel in) {
        this.readBaseFromParcel(in);
        this.mAction = in.readInt();
        this.mKeyCode = in.readInt();
        this.mRepeatCount = in.readInt();
        this.mMetaState = in.readInt();
        this.mScanCode = in.readInt();
        this.mFlags = in.readInt();
        this.mDownTime = in.readLong();
        this.mEventTime = in.readLong();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(2);
        this.writeBaseToParcel(out);
        out.writeInt(this.mAction);
        out.writeInt(this.mKeyCode);
        out.writeInt(this.mRepeatCount);
        out.writeInt(this.mMetaState);
        out.writeInt(this.mScanCode);
        out.writeInt(this.mFlags);
        out.writeLong(this.mDownTime);
        out.writeLong(this.mEventTime);
    }

    public boolean native_isSystemKey(int n) {
        return OverrideMethod.invokeI("android.view.KeyEvent#native_isSystemKey(I)Z", true, this) != 0;
    }

    public boolean native_hasDefaultAction(int n) {
        return OverrideMethod.invokeI("android.view.KeyEvent#native_hasDefaultAction(I)Z", true, this) != 0;
    }

    static {
        if (META_SYMBOLIC_NAMES.length != 32) {
            throw new IllegalStateException("META_SYMBOLIC_NAMES array should contain exactly 32 entries.");
        }
        if (KEYCODE_SYMBOLIC_NAMES.length != 188) {
            throw new IllegalStateException("KEYCODE_SYMBOLIC_NAMES array is out of sync with the keycode constants.");
        }
        CREATOR = new Parcelable.Creator<KeyEvent>(){

            @Override
            public KeyEvent createFromParcel(Parcel in) {
                in.readInt();
                return KeyEvent.createFromParcelBody(in);
            }

            public KeyEvent[] newArray(int size) {
                return new KeyEvent[size];
            }
        };
    }

    public static class DispatcherState {
        public int mDownKeyCode;
        public Object mDownTarget;
        public SparseIntArray mActiveLongPresses = new SparseIntArray();

        public void reset() {
            this.mDownKeyCode = 0;
            this.mDownTarget = null;
            this.mActiveLongPresses.clear();
        }

        public void reset(Object target) {
            if (this.mDownTarget == target) {
                this.mDownKeyCode = 0;
                this.mDownTarget = null;
            }
        }

        public void startTracking(KeyEvent event, Object target) {
            if (event.getAction() != 0) {
                throw new IllegalArgumentException("Can only start tracking on a down event");
            }
            this.mDownKeyCode = event.getKeyCode();
            this.mDownTarget = target;
        }

        public boolean isTracking(KeyEvent event) {
            return this.mDownKeyCode == event.getKeyCode();
        }

        public void performedLongPress(KeyEvent event) {
            this.mActiveLongPresses.put(event.getKeyCode(), 1);
        }

        public void handleUpEvent(KeyEvent event) {
            int keyCode = event.getKeyCode();
            int index = this.mActiveLongPresses.indexOfKey(keyCode);
            if (index >= 0) {
                event.mFlags |= 288;
                this.mActiveLongPresses.removeAt(index);
            }
            if (this.mDownKeyCode == keyCode) {
                event.mFlags |= 512;
                this.mDownKeyCode = 0;
                this.mDownTarget = null;
            }
        }
    }

    public static interface Callback {
        public boolean onKeyDown(int var1, KeyEvent var2);

        public boolean onKeyLongPress(int var1, KeyEvent var2);

        public boolean onKeyUp(int var1, KeyEvent var2);

        public boolean onKeyMultiple(int var1, int var2, KeyEvent var3);
    }
}

