/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.RingtoneManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.SeekBar;
import java.util.HashMap;

public class VolumePanel
extends Handler
implements SeekBar.OnSeekBarChangeListener,
View.OnClickListener {
    public static final String TAG = "VolumePanel";
    public static boolean LOGD = false;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final int VIBRATE_DELAY = 300;
    public static final int VIBRATE_DURATION = 300;
    public static final int BEEP_DURATION = 150;
    public static final int MAX_VOLUME = 100;
    public static final int FREE_DELAY = 10000;
    public static final int TIMEOUT_DELAY = 3000;
    public static final int MSG_VOLUME_CHANGED = 0;
    public static final int MSG_FREE_RESOURCES = 1;
    public static final int MSG_PLAY_SOUND = 2;
    public static final int MSG_STOP_SOUNDS = 3;
    public static final int MSG_VIBRATE = 4;
    public static final int MSG_TIMEOUT = 5;
    public static final int MSG_RINGER_MODE_CHANGED = 6;
    public Context mContext;
    public AudioManager mAudioManager;
    public AudioService mAudioService;
    public boolean mRingIsSilent;
    public final Dialog mDialog;
    public final View mView;
    public final ViewGroup mSliderGroup;
    public final View mMoreButton;
    public final View mDivider;
    public int mActiveStreamType = -1;
    public HashMap<Integer, StreamControl> mStreamControls;
    public static final int[] STREAM_TYPES = new int[]{2, 0, 3, 5};
    public static final int[] STREAM_ICONS_NORMAL = new int[]{17302155, 17302155, 17302156, 17302153};
    public static final int[] STREAM_ICONS_MUTED = new int[]{17302155, 17302155, 17302157, 17302154};
    public ToneGenerator[] mToneGenerators;
    public Vibrator mVibrator;

    public VolumePanel(Context context, AudioService volumeService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = volumeService;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = this.mView = inflater.inflate(17367194, null);
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                VolumePanel.this.resetTimeout();
                return true;
            }
        });
        this.mSliderGroup = (ViewGroup)this.mView.findViewById(16908988);
        this.mMoreButton = (ImageView)this.mView.findViewById(16908990);
        this.mMoreButton.setOnClickListener(this);
        this.mDivider = (ImageView)this.mView.findViewById(16908989);
        this.mDialog = new Dialog(context, 16974293);
        this.mDialog.setTitle("Volume control");
        this.mDialog.setContentView(this.mView);
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                VolumePanel.this.mActiveStreamType = -1;
                VolumePanel.this.mAudioManager.forceVolumeControlStream(VolumePanel.this.mActiveStreamType);
            }
        });
        Window window = this.mDialog.getWindow();
        window.setGravity(48);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.token = null;
        lp.type = 2003;
        window.setAttributes(lp);
        window.addFlags(131072);
        this.mToneGenerators = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mVibrator = new Vibrator();
        this.listenToRingerMode();
    }

    public void listenToRingerMode() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.media.RINGER_MODE_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.media.RINGER_MODE_CHANGED".equals(action)) {
                    VolumePanel.this.removeMessages(6);
                    VolumePanel.this.sendMessage(VolumePanel.this.obtainMessage(6));
                }
            }
        }, filter);
    }

    public boolean isMuted(int streamType) {
        return this.mAudioManager.isStreamMute(streamType);
    }

    public void createSliders() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mStreamControls = new HashMap(STREAM_TYPES.length);
        for (int i = 0; i < STREAM_TYPES.length; ++i) {
            StreamControl sc = new StreamControl(null);
            sc.streamType = STREAM_TYPES[i];
            sc.group = (ViewGroup)inflater.inflate(17367195, null);
            sc.group.setTag(sc);
            sc.icon = (ImageView)sc.group.findViewById(16908991);
            sc.icon.setOnClickListener(this);
            sc.icon.setTag(sc);
            sc.iconRes = STREAM_ICONS_NORMAL[i];
            sc.iconMuteRes = STREAM_ICONS_MUTED[i];
            sc.icon.setImageResource(sc.iconRes);
            sc.seekbarView = (SeekBar)sc.group.findViewById(16908966);
            sc.seekbarView.setMax(this.mAudioManager.getStreamMaxVolume(STREAM_TYPES[i]));
            sc.seekbarView.setOnSeekBarChangeListener(this);
            sc.seekbarView.setTag(sc);
            this.mStreamControls.put(STREAM_TYPES[i], sc);
        }
    }

    public void reorderSliders(int activeStreamType) {
        this.mSliderGroup.removeAllViews();
        StreamControl active = this.mStreamControls.get(activeStreamType);
        if (active == null) {
            Log.e(TAG, "Missing stream type! - " + activeStreamType);
            this.mActiveStreamType = -1;
        } else {
            this.mSliderGroup.addView(active.group);
            this.mActiveStreamType = activeStreamType;
            active.group.setVisibility(0);
            this.updateSlider(active);
        }
        for (int i = 0; i < STREAM_TYPES.length; ++i) {
            int streamType = STREAM_TYPES[i];
            if (streamType == 2 || streamType == 0 || streamType == activeStreamType) continue;
            StreamControl sc = this.mStreamControls.get(streamType);
            this.mSliderGroup.addView(sc.group);
            this.updateSlider(sc);
        }
    }

    public void updateSlider(StreamControl sc) {
        sc.seekbarView.setProgress(this.mAudioManager.getLastAudibleStreamVolume(sc.streamType));
        boolean muted = this.isMuted(sc.streamType);
        sc.icon.setImageResource(muted ? sc.iconMuteRes : sc.iconRes);
        sc.seekbarView.setEnabled(!muted);
    }

    public boolean isExpanded() {
        return this.mMoreButton.getVisibility() != 0;
    }

    public void expand() {
        int count = this.mSliderGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mSliderGroup.getChildAt(i).setVisibility(0);
        }
        this.mMoreButton.setVisibility(4);
        this.mDivider.setVisibility(4);
    }

    public void collapse() {
        this.mMoreButton.setVisibility(0);
        this.mDivider.setVisibility(0);
        int count = this.mSliderGroup.getChildCount();
        for (int i = 1; i < count; ++i) {
            this.mSliderGroup.getChildAt(i).setVisibility(8);
        }
    }

    public void updateStates() {
        int count = this.mSliderGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            StreamControl sc = (StreamControl)this.mSliderGroup.getChildAt(i).getTag();
            this.updateSlider(sc);
        }
    }

    public void postVolumeChanged(int streamType, int flags) {
        if (this.hasMessages(0)) {
            return;
        }
        if (this.mStreamControls == null) {
            this.createSliders();
        }
        this.removeMessages(1);
        this.obtainMessage(0, streamType, flags).sendToTarget();
    }

    public void onVolumeChanged(int streamType, int flags) {
        if (LOGD) {
            Log.d(TAG, "onVolumeChanged(streamType: " + streamType + ", flags: " + flags + ")");
        }
        if (this.mActiveStreamType == -1) {
            this.reorderSliders(streamType);
        }
        if ((flags & 1) != 0) {
            this.onShowVolumeChanged(streamType, flags);
        }
        if ((flags & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, streamType, flags), 300L);
        }
        if ((flags & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
        this.resetTimeout();
    }

    public void onShowVolumeChanged(int streamType, int flags) {
        int index = this.mAudioService.isStreamMute(streamType) ? this.mAudioService.getLastAudibleStreamVolume(streamType) : this.mAudioService.getStreamVolume(streamType);
        this.mRingIsSilent = false;
        if (LOGD) {
            Log.d(TAG, "onShowVolumeChanged(streamType: " + streamType + ", flags: " + flags + "), index: " + index);
        }
        int max = this.mAudioService.getStreamMaxVolume(streamType);
        switch (streamType) {
            case 2: {
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 1);
                if (ringuri != null) break;
                this.mRingIsSilent = true;
                break;
            }
            case 3: {
                if (this.mAudioManager.isBluetoothA2dpOn()) {
                    this.setMusicIcon(17302151, 17302152);
                    break;
                }
                this.setMusicIcon(17302156, 17302157);
                break;
            }
            case 0: {
                ++index;
                ++max;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 2);
                if (ringuri != null) break;
                this.mRingIsSilent = true;
                break;
            }
            case 6: {
                ++index;
                ++max;
            }
        }
        StreamControl sc = this.mStreamControls.get(streamType);
        if (sc != null) {
            sc.seekbarView.setProgress(index);
        }
        if (!this.mDialog.isShowing()) {
            this.mAudioManager.forceVolumeControlStream(streamType);
            this.mDialog.setContentView(this.mView);
            this.collapse();
            this.mDialog.show();
        }
        if ((flags & 0x10) != 0 && this.mAudioService.isStreamAffectedByRingerMode(streamType) && this.mAudioService.getRingerMode() == 1 && this.mAudioService.shouldVibrate(0)) {
            this.sendMessageDelayed(this.obtainMessage(4), 300L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaySound(int streamType, int flags) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            ToneGenerator toneGen = this.getOrCreateToneGenerator(streamType);
            if (toneGen != null) {
                toneGen.startTone(24);
                this.sendMessageDelayed(this.obtainMessage(3), 150L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStopSounds() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int i = numStreamTypes - 1; i >= 0; --i) {
                ToneGenerator toneGen = this.mToneGenerators[i];
                if (toneGen == null) continue;
                toneGen.stopTone();
            }
        }
    }

    public void onVibrate() {
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToneGenerator getOrCreateToneGenerator(int streamType) {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            block6: {
                if (this.mToneGenerators[streamType] == null) {
                    try {
                        this.mToneGenerators[streamType] = new ToneGenerator(streamType, 100);
                    }
                    catch (RuntimeException e) {
                        if (!LOGD) break block6;
                        Log.d(TAG, "ToneGenerator constructor failed with RuntimeException: " + e);
                    }
                }
            }
            return this.mToneGenerators[streamType];
        }
    }

    public void setMusicIcon(int resId, int resMuteId) {
        StreamControl sc = this.mStreamControls.get(3);
        if (sc != null) {
            sc.iconRes = resId;
            sc.iconMuteRes = resMuteId;
            sc.icon.setImageResource(this.isMuted(sc.streamType) ? sc.iconMuteRes : sc.iconRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFreeResources() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            for (int i = this.mToneGenerators.length - 1; i >= 0; --i) {
                if (this.mToneGenerators[i] != null) {
                    this.mToneGenerators[i].release();
                }
                this.mToneGenerators[i] = null;
            }
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.onVolumeChanged(msg.arg1, msg.arg2);
                break;
            }
            case 1: {
                this.onFreeResources();
                break;
            }
            case 3: {
                this.onStopSounds();
                break;
            }
            case 2: {
                this.onPlaySound(msg.arg1, msg.arg2);
                break;
            }
            case 4: {
                this.onVibrate();
                break;
            }
            case 5: {
                if (!this.mDialog.isShowing()) break;
                this.mDialog.dismiss();
                this.mActiveStreamType = -1;
                break;
            }
            case 6: {
                if (!this.mDialog.isShowing()) break;
                this.updateStates();
            }
        }
    }

    public void resetTimeout() {
        this.removeMessages(5);
        this.sendMessageDelayed(this.obtainMessage(5), 3000L);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        Object tag = seekBar.getTag();
        if (fromUser && tag instanceof StreamControl) {
            StreamControl sc = (StreamControl)tag;
            if (this.mAudioManager.getStreamVolume(sc.streamType) != progress) {
                this.mAudioManager.setStreamVolume(sc.streamType, progress, 0);
            }
        }
        this.resetTimeout();
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onClick(View v) {
        if (v == this.mMoreButton) {
            this.expand();
        } else if (v.getTag() instanceof StreamControl) {
            StreamControl sc = (StreamControl)v.getTag();
            this.mAudioManager.setRingerMode(this.mAudioManager.isSilentMode() ? 2 : 0);
            if (!this.isExpanded()) {
                this.expand();
            }
        }
        this.resetTimeout();
    }

    public class StreamControl {
        public int streamType;
        public ViewGroup group;
        public ImageView icon;
        public SeekBar seekbarView;
        public int iconRes;
        public int iconMuteRes;

        public StreamControl() {
        }

        public /* synthetic */ StreamControl(1 x1) {
            this();
        }
    }
}

