/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.util.Slog;

public abstract class WindowOrientationListener {
    public static final String TAG = "WindowOrientationListener";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public SensorManager mSensorManager;
    public boolean mEnabled;
    public int mRate;
    public Sensor mSensor;
    public SensorEventListenerImpl mSensorEventListener;
    public boolean mLogEnabled;

    public WindowOrientationListener(Context context) {
        this(context, 2);
    }

    public WindowOrientationListener(Context context, int rate) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    public int getCurrentRotation(int lastRotation) {
        if (this.mEnabled) {
            return this.mSensorEventListener.getCurrentRotation(lastRotation);
        }
        return lastRotation;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onOrientationChanged(int var1);

    public void setLogEnabled(boolean enable) {
        this.mLogEnabled = enable;
    }

    public static class SensorEventListenerImpl
    implements SensorEventListener {
        public static final float RADIANS_TO_DEGREES = 57.29578f;
        public static final int ACCELEROMETER_DATA_X = 0;
        public static final int ACCELEROMETER_DATA_Y = 1;
        public static final int ACCELEROMETER_DATA_Z = 2;
        public static final int ROTATION_UNKNOWN = -1;
        public final WindowOrientationListener mOrientationListener;
        public int mRotation = -1;
        public long mLastTimestamp = Long.MAX_VALUE;
        public float mLastFilteredX;
        public float mLastFilteredY;
        public float mLastFilteredZ;
        public static final float MAX_FILTER_DELTA_TIME_MS = 1000.0f;
        public static final float FILTER_CUTOFF_FREQUENCY_HZ = 1.0f;
        public static final float FILTER_TIME_CONSTANT_MS = 159.15494f;
        public static final float FILTER_GAIN = 0.999f;
        public static final float MIN_ACCELERATION_MAGNITUDE = 4.903325f;
        public static final float MAX_ACCELERATION_MAGNITUDE = 14.709975f;
        public static final int MAX_TILT = 75;
        public static final int[][] TILT_TOLERANCE = new int[][]{{-20, 75}, {-20, 70}, {-20, 65}, {-20, 70}};
        public static final int ADJACENT_ORIENTATION_ANGLE_GAP = 30;
        public static final float ORIENTATION_ANGLE_CONFIDENCE_SCALE = SensorEventListenerImpl.confidenceScaleFromDelta(30.0f);
        public static final float TILT_ANGLE_CONFIDENCE_SCALE = SensorEventListenerImpl.confidenceScaleFromDelta(45.0f);
        public static final float MAGNITUDE_CONFIDENCE_SCALE = SensorEventListenerImpl.confidenceScaleFromDelta(2.4516625f);
        public static final float ORIENTATION_SETTLE_TIME_MS = 250.0f;
        public float[] mConfidence = new float[4];

        public SensorEventListenerImpl(WindowOrientationListener orientationListener) {
            this.mOrientationListener = orientationListener;
        }

        public int getCurrentRotation(int lastRotation) {
            return this.mRotation != -1 ? this.mRotation : lastRotation;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public void onSensorChanged(SensorEvent event) {
            boolean skipSample;
            float timeDeltaMS;
            boolean log = this.mOrientationListener.mLogEnabled;
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            if (log) {
                Slog.v(WindowOrientationListener.TAG, "Raw acceleration vector: x=" + x + ", y=" + y + ", z=" + z);
            }
            if ((timeDeltaMS = (float)(event.timestamp - this.mLastTimestamp) * 1.0E-6f) <= 0.0f || timeDeltaMS > 1000.0f || x == 0.0f && y == 0.0f && z == 0.0f) {
                if (log) {
                    Slog.v(WindowOrientationListener.TAG, "Resetting orientation listener.");
                }
                for (int i = 0; i < 4; ++i) {
                    this.mConfidence[i] = 0.0f;
                }
                skipSample = true;
            } else {
                float alpha = timeDeltaMS / (159.15494f + timeDeltaMS) * 0.999f;
                x = alpha * (x - this.mLastFilteredX) + this.mLastFilteredX;
                y = alpha * (y - this.mLastFilteredY) + this.mLastFilteredY;
                z = alpha * (z - this.mLastFilteredZ) + this.mLastFilteredZ;
                if (log) {
                    Slog.v(WindowOrientationListener.TAG, "Filtered acceleration vector: x=" + x + ", y=" + y + ", z=" + z);
                }
                skipSample = false;
            }
            this.mLastTimestamp = event.timestamp;
            this.mLastFilteredX = x;
            this.mLastFilteredY = y;
            this.mLastFilteredZ = z;
            boolean orientationChanged = false;
            if (!skipSample) {
                int proposedOrientation = -1;
                float combinedConfidence = 1.0f;
                float magnitude = (float)Math.sqrt(x * x + y * y + z * z);
                if (magnitude < 4.903325f || magnitude > 14.709975f) {
                    if (log) {
                        Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, magnitude out of range: magnitude=" + magnitude);
                    }
                } else {
                    int tiltAngle = (int)Math.round(Math.asin(z / magnitude) * (double)57.29578f);
                    if (Math.abs(tiltAngle) > 75) {
                        if (log) {
                            Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, tilt angle too high: magnitude=" + magnitude + ", tiltAngle=" + tiltAngle);
                        }
                    } else {
                        int orientationAngle = (int)Math.round(-Math.atan2(-x, y) * (double)57.29578f);
                        if (orientationAngle < 0) {
                            orientationAngle += 360;
                        }
                        int nearestOrientation = (orientationAngle + 45) / 90;
                        int nearestOrientationAngle = nearestOrientation * 90;
                        if (nearestOrientation == 4) {
                            nearestOrientation = 0;
                        }
                        if (this.isTiltAngleAcceptable(nearestOrientation, tiltAngle) && this.isOrientationAngleAcceptable(nearestOrientation, orientationAngle)) {
                            proposedOrientation = nearestOrientation;
                            float idealOrientationAngle = nearestOrientationAngle;
                            float orientationConfidence = SensorEventListenerImpl.confidence(orientationAngle, idealOrientationAngle, ORIENTATION_ANGLE_CONFIDENCE_SCALE);
                            float idealTiltAngle = 0.0f;
                            float tiltConfidence = SensorEventListenerImpl.confidence(tiltAngle, 0.0f, TILT_ANGLE_CONFIDENCE_SCALE);
                            float idealMagnitude = 9.80665f;
                            float magnitudeConfidence = SensorEventListenerImpl.confidence(magnitude, 9.80665f, MAGNITUDE_CONFIDENCE_SCALE);
                            combinedConfidence = orientationConfidence * tiltConfidence * magnitudeConfidence;
                            if (log) {
                                Slog.v(WindowOrientationListener.TAG, "Proposal: magnitude=" + magnitude + ", tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle + ", proposedOrientation=" + proposedOrientation + ", combinedConfidence=" + combinedConfidence + ", orientationConfidence=" + orientationConfidence + ", tiltConfidence=" + tiltConfidence + ", magnitudeConfidence=" + magnitudeConfidence);
                            }
                        } else if (log) {
                            Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, no proposal: magnitude=" + magnitude + ", tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle);
                        }
                    }
                }
                float confidenceAmount = combinedConfidence * timeDeltaMS / 250.0f;
                for (int i = 0; i < 4; ++i) {
                    if (i == proposedOrientation) {
                        int n = i;
                        this.mConfidence[n] = this.mConfidence[n] + confidenceAmount;
                        if (!(this.mConfidence[i] >= 1.0f)) continue;
                        this.mConfidence[i] = 1.0f;
                        if (i == this.mRotation) continue;
                        if (log) {
                            Slog.v(WindowOrientationListener.TAG, "Orientation changed!  rotation=" + i);
                        }
                        this.mRotation = i;
                        orientationChanged = true;
                        continue;
                    }
                    int n = i;
                    this.mConfidence[n] = this.mConfidence[n] - confidenceAmount;
                    if (!(this.mConfidence[i] < 0.0f)) continue;
                    this.mConfidence[i] = 0.0f;
                }
            }
            if (log) {
                Slog.v(WindowOrientationListener.TAG, "Result: rotation=" + this.mRotation + ", confidence=[" + this.mConfidence[0] + ", " + this.mConfidence[1] + ", " + this.mConfidence[2] + ", " + this.mConfidence[3] + "], timeDeltaMS=" + timeDeltaMS);
            }
            if (orientationChanged) {
                this.mOrientationListener.onOrientationChanged(this.mRotation);
            }
        }

        public boolean isTiltAngleAcceptable(int proposedOrientation, int tiltAngle) {
            return tiltAngle >= TILT_TOLERANCE[proposedOrientation][0] && tiltAngle <= TILT_TOLERANCE[proposedOrientation][1];
        }

        public boolean isOrientationAngleAcceptable(int proposedOrientation, int orientationAngle) {
            int currentOrientation = this.mRotation;
            if (currentOrientation != -1) {
                if (proposedOrientation == currentOrientation || proposedOrientation == (currentOrientation + 1) % 4) {
                    int lowerBound = proposedOrientation * 90 - 45 + 15;
                    if (proposedOrientation == 0 ? orientationAngle >= 315 && orientationAngle < lowerBound + 360 : orientationAngle < lowerBound) {
                        return false;
                    }
                }
                if (proposedOrientation == currentOrientation || proposedOrientation == (currentOrientation + 3) % 4) {
                    int upperBound = proposedOrientation * 90 + 45 - 15;
                    if (proposedOrientation == 0 ? orientationAngle <= 45 && orientationAngle > upperBound : orientationAngle > upperBound) {
                        return false;
                    }
                }
            }
            return true;
        }

        public static float confidence(float value, float target, float scale) {
            return (float)Math.exp(-Math.abs(value - target) * scale);
        }

        public static float confidenceScaleFromDelta(float cutoffDelta) {
            return (float)(-Math.log(0.5)) / cutoffDelta;
        }
    }
}

