/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.InputStream;

public class JniUtil {
    public static final String LOGTAG = "webkit";
    public static String sDatabaseDirectory;
    public static String sCacheDirectory;
    public static Boolean sUseChromiumHttpStack;
    public static Context sContext;
    public static boolean initialized;
    public static final String ANDROID_CONTENT = "content:";

    public static void checkIntialized() {
        if (!initialized) {
            throw new IllegalStateException("Call CookieSyncManager::createInstance() or create a webview before using this class");
        }
    }

    public static synchronized void setContext(Context context) {
        if (initialized) {
            return;
        }
        sContext = context.getApplicationContext();
        initialized = true;
    }

    public static synchronized String getDatabaseDirectory() {
        JniUtil.checkIntialized();
        if (sDatabaseDirectory == null) {
            sDatabaseDirectory = sContext.getDatabasePath("dummy").getParent();
        }
        return sDatabaseDirectory;
    }

    public static synchronized String getCacheDirectory() {
        JniUtil.checkIntialized();
        if (sCacheDirectory == null) {
            sCacheDirectory = sContext.getCacheDir().getAbsolutePath();
        }
        return sCacheDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long contentUrlSize(String url) {
        if (url.startsWith(ANDROID_CONTENT)) {
            try {
                int mimeIndex = url.lastIndexOf(63);
                if (mimeIndex != -1) {
                    url = url.substring(0, mimeIndex);
                }
                Uri uri = Uri.parse(url);
                InputStream is = sContext.getContentResolver().openInputStream(uri);
                byte[] buffer = new byte[1024];
                long size = 0L;
                try {
                    int n;
                    while ((n = is.read(buffer)) != -1) {
                        size += (long)n;
                    }
                }
                finally {
                    is.close();
                }
                return size;
            }
            catch (Exception e) {
                Log.e(LOGTAG, "Exception: " + url);
                return 0L;
            }
        }
        return 0L;
    }

    public static synchronized InputStream contentUrlStream(String url) {
        if (url.startsWith(ANDROID_CONTENT)) {
            try {
                int mimeIndex = url.lastIndexOf(63);
                if (mimeIndex != -1) {
                    url = url.substring(0, mimeIndex);
                }
                Uri uri = Uri.parse(url);
                return sContext.getContentResolver().openInputStream(uri);
            }
            catch (Exception e) {
                Log.e(LOGTAG, "Exception: " + url);
                return null;
            }
        }
        return null;
    }

    public static boolean useChromiumHttpStack() {
        if (sUseChromiumHttpStack == null) {
            sUseChromiumHttpStack = JniUtil.nativeUseChromiumHttpStack();
        }
        return sUseChromiumHttpStack;
    }

    public static boolean nativeUseChromiumHttpStack() {
        return OverrideMethod.invokeI("android.webkit.JniUtil#nativeUseChromiumHttpStack()Z", true, null) != 0;
    }

    static {
        initialized = false;
    }
}

