/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Bitmap;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.MalformedURLException;
import java.net.URL;

public class WebHistoryItem
implements Cloneable {
    public static int sNextId = 0;
    public final int mId;
    public String mTitle;
    public String mUrl;
    public String mOriginalUrl;
    public Bitmap mFavicon;
    public byte[] mFlattenedData;
    public String mTouchIconUrlFromLink;
    public String mTouchIconUrlServerDefault;
    public Object mCustomData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebHistoryItem() {
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebHistoryItem(byte[] data) {
        this.mUrl = null;
        this.mFlattenedData = data;
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public WebHistoryItem(WebHistoryItem item) {
        this.mUrl = item.mUrl;
        this.mTitle = item.mTitle;
        this.mFlattenedData = item.mFlattenedData;
        this.mFavicon = item.mFavicon;
        this.mId = item.mId;
    }

    public int getId() {
        return this.mId;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getOriginalUrl() {
        return this.mOriginalUrl;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    public String getTouchIconUrl() {
        if (this.mTouchIconUrlFromLink != null) {
            return this.mTouchIconUrlFromLink;
        }
        if (this.mTouchIconUrlServerDefault != null) {
            return this.mTouchIconUrlServerDefault;
        }
        try {
            URL url = new URL(this.mOriginalUrl);
            this.mTouchIconUrlServerDefault = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/apple-touch-icon.png").toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.mTouchIconUrlServerDefault;
    }

    public Object getCustomData() {
        return this.mCustomData;
    }

    public void setCustomData(Object data) {
        this.mCustomData = data;
    }

    public void setFavicon(Bitmap icon) {
        this.mFavicon = icon;
    }

    public void setTouchIconUrl(String url, boolean precomposed) {
        if (precomposed || this.mTouchIconUrlFromLink == null) {
            this.mTouchIconUrlFromLink = url;
        }
    }

    public byte[] getFlattenedData() {
        return this.mFlattenedData;
    }

    public void inflate(int nativeFrame) {
        this.inflate(nativeFrame, this.mFlattenedData);
    }

    public synchronized WebHistoryItem clone() {
        return new WebHistoryItem(this);
    }

    public void inflate(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.webkit.WebHistoryItem#inflate(I[B)V", true, this);
    }

    public void update(String url, String originalUrl, String title, Bitmap favicon, byte[] data) {
        this.mUrl = url;
        this.mOriginalUrl = originalUrl;
        this.mTitle = title;
        this.mFavicon = favicon;
        this.mFlattenedData = data;
    }
}

