/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.CalendarView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.android.internal.R;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePicker
extends FrameLayout {
    public static final String LOG_TAG = DatePicker.class.getSimpleName();
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    public static final int DEFAULT_START_YEAR = 1900;
    public static final int DEFAULT_END_YEAR = 2100;
    public static final boolean DEFAULT_CALENDAR_VIEW_SHOWN = true;
    public static final boolean DEFAULT_SPINNERS_SHOWN = true;
    public static final boolean DEFAULT_ENABLED_STATE = true;
    public final NumberPicker mDaySpinner;
    public final LinearLayout mSpinners;
    public final NumberPicker mMonthSpinner;
    public final NumberPicker mYearSpinner;
    public final CalendarView mCalendarView;
    public OnDateChangedListener mOnDateChangedListener;
    public Locale mMonthLocale;
    public final Calendar mTempDate = Calendar.getInstance();
    public final int mNumberOfMonths = this.mTempDate.getActualMaximum(2) + 1;
    public final String[] mShortMonths = new String[this.mNumberOfMonths];
    public final java.text.DateFormat mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    public final Calendar mMinDate = Calendar.getInstance();
    public final Calendar mMaxDate = Calendar.getInstance();
    public final Calendar mCurrentDate = Calendar.getInstance();
    public boolean mIsEnabled = true;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843612);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyle, 0);
        boolean spinnersShown = attributesArray.getBoolean(5, true);
        boolean calendarViewShown = attributesArray.getBoolean(6, true);
        int startYear = attributesArray.getInt(1, 1900);
        int endYear = attributesArray.getInt(2, 2100);
        String minDate = attributesArray.getString(3);
        String maxDate = attributesArray.getString(4);
        int layoutResourceId = attributesArray.getResourceId(0, 17367084);
        attributesArray.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(layoutResourceId, (ViewGroup)this, true);
        NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mTempDate.setTimeInMillis(DatePicker.this.mCurrentDate.getTimeInMillis());
                if (picker == DatePicker.this.mDaySpinner) {
                    int maxDayOfMonth = DatePicker.this.mTempDate.getActualMaximum(5);
                    if (oldVal == maxDayOfMonth && newVal == 1) {
                        DatePicker.this.mTempDate.add(5, 1);
                    } else if (oldVal == 1 && newVal == maxDayOfMonth) {
                        DatePicker.this.mTempDate.add(5, -1);
                    } else {
                        DatePicker.this.mTempDate.add(5, newVal - oldVal);
                    }
                } else if (picker == DatePicker.this.mMonthSpinner) {
                    if (oldVal == 11 && newVal == 0) {
                        DatePicker.this.mTempDate.add(2, 1);
                    } else if (oldVal == 0 && newVal == 11) {
                        DatePicker.this.mTempDate.add(2, -1);
                    } else {
                        DatePicker.this.mTempDate.add(2, newVal - oldVal);
                    }
                } else if (picker == DatePicker.this.mYearSpinner) {
                    DatePicker.this.mTempDate.set(1, newVal);
                } else {
                    throw new IllegalArgumentException();
                }
                DatePicker.this.setDate(DatePicker.this.mTempDate.get(1), DatePicker.this.mTempDate.get(2), DatePicker.this.mTempDate.get(5));
                DatePicker.this.updateSpinners();
                DatePicker.this.updateCalendarView();
                DatePicker.this.notifyDateChanged();
            }
        };
        this.mSpinners = (LinearLayout)this.findViewById(0x1020211);
        this.mCalendarView = (CalendarView)this.findViewById(16908821);
        this.mCalendarView.setOnDateChangeListener(new CalendarView.OnDateChangeListener(){

            public void onSelectedDayChange(CalendarView view, int year, int month, int monthDay) {
                DatePicker.this.setDate(year, month, monthDay);
                DatePicker.this.updateSpinners();
                DatePicker.this.notifyDateChanged();
            }
        });
        this.mDaySpinner = (NumberPicker)this.findViewById(16908819);
        this.mDaySpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mDaySpinner.setOnLongPressUpdateInterval(100L);
        this.mDaySpinner.setOnValueChangedListener(onChangeListener);
        this.mMonthSpinner = (NumberPicker)this.findViewById(0x1020212);
        this.mMonthSpinner.setMinValue(0);
        this.mMonthSpinner.setMaxValue(this.mNumberOfMonths - 1);
        this.mMonthSpinner.setDisplayedValues(this.getShortMonths());
        this.mMonthSpinner.setOnLongPressUpdateInterval(200L);
        this.mMonthSpinner.setOnValueChangedListener(onChangeListener);
        this.mYearSpinner = (NumberPicker)this.findViewById(16908820);
        this.mYearSpinner.setOnLongPressUpdateInterval(100L);
        this.mYearSpinner.setOnValueChangedListener(onChangeListener);
        if (!spinnersShown && !calendarViewShown) {
            this.setSpinnersShown(true);
        } else {
            this.setSpinnersShown(spinnersShown);
            this.setCalendarViewShown(calendarViewShown);
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(minDate)) {
                if (!this.parseDate(minDate, this.mTempDate)) {
                    this.mTempDate.set(startYear, 0, 1);
                }
            } else {
                this.mTempDate.set(startYear, 0, 1);
            }
            this.mMinDate.clear();
            this.setMinDate(this.mTempDate.getTimeInMillis());
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(maxDate)) {
                if (!this.parseDate(maxDate, this.mTempDate)) {
                    this.mTempDate.set(endYear, 11, 31);
                }
            } else {
                this.mTempDate.set(endYear, 11, 31);
            }
            this.mMaxDate.clear();
            this.setMaxDate(this.mTempDate.getTimeInMillis());
            this.mCurrentDate.setTimeInMillis(System.currentTimeMillis());
            this.init(this.mCurrentDate.get(1), this.mCurrentDate.get(2), this.mCurrentDate.get(5), null);
        }
        this.reorderSpinners();
    }

    public long getMinDate() {
        return this.mCalendarView.getMinDate();
    }

    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mCalendarView.setMinDate(minDate);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    public long getMaxDate() {
        return this.mCalendarView.getMaxDate();
    }

    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mCalendarView.setMaxDate(maxDate);
        if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mDaySpinner.setEnabled(enabled);
        this.mMonthSpinner.setEnabled(enabled);
        this.mYearSpinner.setEnabled(enabled);
        this.mCalendarView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 22;
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mCurrentDate.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
        return true;
    }

    public boolean getCalendarViewShown() {
        return this.mCalendarView.isShown();
    }

    public void setCalendarViewShown(boolean shown) {
        this.mCalendarView.setVisibility(shown ? 0 : 8);
    }

    public boolean getSpinnersShown() {
        return this.mSpinners.isShown();
    }

    public void setSpinnersShown(boolean shown) {
        this.mSpinners.setVisibility(shown ? 0 : 8);
    }

    public void reorderSpinners() {
        java.text.DateFormat format = this.getShortMonths()[0].startsWith("1") ? DateFormat.getDateFormat(this.getContext()) : DateFormat.getMediumDateFormat(this.getContext());
        String order = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : new String(DateFormat.getDateFormatOrder(this.getContext()));
        LinearLayout parent = this.mSpinners;
        parent.removeAllViews();
        boolean quoted = false;
        boolean didDay = false;
        boolean didMonth = false;
        boolean didYear = false;
        for (int i = 0; i < order.length(); ++i) {
            char c = order.charAt(i);
            if (c == '\'') {
                boolean bl = quoted = !quoted;
            }
            if (quoted) continue;
            if (c == 'd' && !didDay) {
                parent.addView(this.mDaySpinner);
                didDay = true;
                continue;
            }
            if (!(c != 'M' && c != 'L' || didMonth)) {
                parent.addView(this.mMonthSpinner);
                didMonth = true;
                continue;
            }
            if (c != 'y' || didYear) continue;
            parent.addView(this.mYearSpinner);
            didYear = true;
        }
        if (!didMonth) {
            parent.addView(this.mMonthSpinner);
        }
        if (!didDay) {
            parent.addView(this.mDaySpinner);
        }
        if (!didYear) {
            parent.addView(this.mYearSpinner);
        }
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        if (!this.isNewDate(year, month, dayOfMonth)) {
            return;
        }
        this.setDate(year, month, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
        this.notifyDateChanged();
    }

    @Override
    public void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getYear(), this.getMonth(), this.getDayOfMonth(), null);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setDate(ss.mYear, ss.mMonth, ss.mDay);
        this.updateSpinners();
        this.updateCalendarView();
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.setDate(year, monthOfYear, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
        this.mOnDateChangedListener = onDateChangedListener;
    }

    public boolean parseDate(String date, Calendar outDate) {
        try {
            outDate.setTime(this.mDateFormat.parse(date));
            return true;
        }
        catch (ParseException e) {
            Log.w(LOG_TAG, "Date: " + date + " not in format: " + DATE_FORMAT);
            return false;
        }
    }

    public String[] getShortMonths() {
        Locale currentLocale = Locale.getDefault();
        if (currentLocale.equals(this.mMonthLocale)) {
            return this.mShortMonths;
        }
        for (int i = 0; i < this.mNumberOfMonths; ++i) {
            this.mShortMonths[i] = DateUtils.getMonthString(0 + i, 20);
        }
        this.mMonthLocale = currentLocale;
        return this.mShortMonths;
    }

    public boolean isNewDate(int year, int month, int dayOfMonth) {
        return this.mCurrentDate.get(1) != year || this.mCurrentDate.get(2) != dayOfMonth || this.mCurrentDate.get(5) != month;
    }

    public void setDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(year, month, dayOfMonth);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        } else if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
    }

    public void updateSpinners() {
        if (this.mCurrentDate.equals(this.mMinDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else if (this.mCurrentDate.equals(this.mMaxDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else {
            this.mDaySpinner.setMinValue(1);
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(true);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(0);
            this.mMonthSpinner.setMaxValue(11);
            this.mMonthSpinner.setWrapSelectorWheel(true);
        }
        String[] displayedValues = Arrays.copyOfRange(this.getShortMonths(), this.mMonthSpinner.getMinValue(), this.mMonthSpinner.getMaxValue() + 1);
        this.mMonthSpinner.setDisplayedValues(displayedValues);
        this.mYearSpinner.setMinValue(this.mMinDate.get(1));
        this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
        this.mYearSpinner.setWrapSelectorWheel(false);
        this.mYearSpinner.setValue(this.mCurrentDate.get(1));
        this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
        this.mDaySpinner.setValue(this.mCurrentDate.get(5));
    }

    public void updateCalendarView() {
        this.mCalendarView.setDate(this.mCurrentDate.getTimeInMillis(), false, false);
    }

    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    public int getMonth() {
        return this.mCurrentDate.get(2);
    }

    public int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    public void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnDateChangedListener != null) {
            this.mOnDateChangedListener.onDateChanged(this, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public final int mYear;
        public final int mMonth;
        public final int mDay;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState, int year, int month, int day) {
            super(superState);
            this.mYear = year;
            this.mMonth = month;
            this.mDay = day;
        }

        public SavedState(Parcel in) {
            super(in);
            this.mYear = in.readInt();
            this.mMonth = in.readInt();
            this.mDay = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYear);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mDay);
        }

        public /* synthetic */ SavedState(Parcelable x0, int x1, int x2, int x3, 1 x4) {
            this(x0, x1, x2, x3);
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }
}

