/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.ImageDescriptor;
import java.util.HashMap;

public class IconLoader
extends Handler {
    public int mState = 1;
    public ImageDescriptor mId = null;
    public Bitmap mCurrentIcon = null;
    public int mRecordNumber;
    public IccFileHandler mSimFH = null;
    public Message mEndMsg = null;
    public byte[] mIconData = null;
    public int[] mRecordNumbers = null;
    public int mCurrentRecordIndex = 0;
    public Bitmap[] mIcons = null;
    public HashMap<Integer, Bitmap> mIconsCache = null;
    public static IconLoader sLoader = null;
    public static final int STATE_SINGLE_ICON = 1;
    public static final int STATE_MULTI_ICONS = 2;
    public static final int EVENT_READ_EF_IMG_RECOED_DONE = 1;
    public static final int EVENT_READ_ICON_DONE = 2;
    public static final int EVENT_READ_CLUT_DONE = 3;
    public static final int CLUT_LOCATION_OFFSET = 4;
    public static final int CLUT_ENTRY_SIZE = 3;

    public IconLoader(Looper looper, IccFileHandler fh) {
        super(looper);
        this.mSimFH = fh;
        this.mIconsCache = new HashMap(50);
    }

    public static IconLoader getInstance(Handler caller, IccFileHandler fh) {
        if (sLoader != null) {
            return sLoader;
        }
        if (fh != null) {
            HandlerThread thread = new HandlerThread("Cat Icon Loader");
            thread.start();
            return new IconLoader(thread.getLooper(), fh);
        }
        return null;
    }

    public void loadIcons(int[] recordNumbers, Message msg) {
        if (recordNumbers == null || recordNumbers.length == 0 || msg == null) {
            return;
        }
        this.mEndMsg = msg;
        this.mIcons = new Bitmap[recordNumbers.length];
        this.mRecordNumbers = recordNumbers;
        this.mCurrentRecordIndex = 0;
        this.mState = 2;
        this.startLoadingIcon(recordNumbers[0]);
    }

    public void loadIcon(int recordNumber, Message msg) {
        if (msg == null) {
            return;
        }
        this.mEndMsg = msg;
        this.mState = 1;
        this.startLoadingIcon(recordNumber);
    }

    public void startLoadingIcon(int recordNumber) {
        this.mId = null;
        this.mIconData = null;
        this.mCurrentIcon = null;
        this.mRecordNumber = recordNumber;
        if (this.mIconsCache.containsKey(recordNumber)) {
            this.mCurrentIcon = this.mIconsCache.get(recordNumber);
            this.postIcon();
            return;
        }
        this.readId();
    }

    public void handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (this.handleImageDescriptor((byte[])ar.result)) {
                        this.readIconData();
                        break;
                    }
                    throw new Exception("Unable to parse image descriptor");
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] rawData = (byte[])ar.result;
                    if (this.mId.codingScheme == 17) {
                        this.mCurrentIcon = IconLoader.parseToBnW(rawData, rawData.length);
                        this.mIconsCache.put(this.mRecordNumber, this.mCurrentIcon);
                        this.postIcon();
                        break;
                    }
                    if (this.mId.codingScheme != 33) break;
                    this.mIconData = rawData;
                    this.readClut();
                    break;
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] clut = (byte[])ar.result;
                    this.mCurrentIcon = IconLoader.parseToRGB(this.mIconData, this.mIconData.length, false, clut);
                    this.mIconsCache.put(this.mRecordNumber, this.mCurrentIcon);
                    this.postIcon();
                }
            }
        }
        catch (Exception e) {
            CatLog.d(this, "Icon load failed");
            this.postIcon();
        }
    }

    public boolean handleImageDescriptor(byte[] rawData) {
        this.mId = ImageDescriptor.parse(rawData, 1);
        return this.mId != null;
    }

    public void readClut() {
        int length = this.mIconData[3] * 3;
        Message msg = this.obtainMessage(3);
        this.mSimFH.loadEFImgTransparent(this.mId.imageId, this.mIconData[4], this.mIconData[5], length, msg);
    }

    public void readId() {
        if (this.mRecordNumber < 0) {
            this.mCurrentIcon = null;
            this.postIcon();
            return;
        }
        Message msg = this.obtainMessage(1);
        this.mSimFH.loadEFImgLinearFixed(this.mRecordNumber, msg);
    }

    public void readIconData() {
        Message msg = this.obtainMessage(2);
        this.mSimFH.loadEFImgTransparent(this.mId.imageId, 0, 0, this.mId.length, msg);
    }

    public void postIcon() {
        if (this.mState == 1) {
            this.mEndMsg.obj = this.mCurrentIcon;
            this.mEndMsg.sendToTarget();
        } else if (this.mState == 2) {
            this.mIcons[this.mCurrentRecordIndex++] = this.mCurrentIcon;
            if (this.mCurrentRecordIndex < this.mRecordNumbers.length) {
                this.startLoadingIcon(this.mRecordNumbers[this.mCurrentRecordIndex]);
            } else {
                this.mEndMsg.obj = this.mIcons;
                this.mEndMsg.sendToTarget();
            }
        }
    }

    public static Bitmap parseToBnW(byte[] data, int length) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        int pixelIndex = 0;
        int bitIndex = 7;
        byte currentByte = 0;
        while (pixelIndex < numOfPixels) {
            if (pixelIndex % 8 == 0) {
                currentByte = data[valueIndex++];
                bitIndex = 7;
            }
            pixels[pixelIndex++] = IconLoader.bitToBnW(currentByte >> bitIndex-- & 1);
        }
        if (pixelIndex != numOfPixels) {
            CatLog.d("IconLoader", "parseToBnW; size error");
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    public static int bitToBnW(int bit) {
        if (bit == 1) {
            return -1;
        }
        return -16777216;
    }

    public static Bitmap parseToRGB(byte[] data, int length, boolean transparency, byte[] clut) {
        boolean bitsOverlaps;
        int bitsStartOffset;
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int bitsPerImg = data[valueIndex++] & 0xFF;
        int numOfClutEntries = data[valueIndex++] & 0xFF;
        if (transparency) {
            clut[numOfClutEntries - 1] = 0;
        }
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        valueIndex = 6;
        int pixelIndex = 0;
        int bitIndex = bitsStartOffset = 8 - bitsPerImg;
        byte currentByte = data[valueIndex++];
        int mask = IconLoader.getMask(bitsPerImg);
        boolean bl = bitsOverlaps = 8 % bitsPerImg == 0;
        while (pixelIndex < numOfPixels) {
            if (bitIndex < 0) {
                currentByte = data[valueIndex++];
                bitIndex = bitsOverlaps ? bitsStartOffset : bitIndex * -1;
            }
            int clutEntry = currentByte >> bitIndex & mask;
            int clutIndex = clutEntry * 3;
            pixels[pixelIndex++] = Color.rgb(clut[clutIndex], clut[clutIndex + 1], clut[clutIndex + 2]);
            bitIndex -= bitsPerImg;
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    public static int getMask(int numOfBits) {
        int mask = 0;
        switch (numOfBits) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 3;
                break;
            }
            case 3: {
                mask = 7;
                break;
            }
            case 4: {
                mask = 15;
                break;
            }
            case 5: {
                mask = 31;
                break;
            }
            case 6: {
                mask = 63;
                break;
            }
            case 7: {
                mask = 127;
                break;
            }
            case 8: {
                mask = 255;
            }
        }
        return mask;
    }
}

