/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.cat.BerTlv;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.CommandParamsFactory;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.RilMessage;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public class RilMessageDecoder
extends HierarchicalStateMachine {
    public static final int CMD_START = 1;
    public static final int CMD_PARAMS_READY = 2;
    public static RilMessageDecoder sInstance = null;
    public CommandParamsFactory mCmdParamsFactory = null;
    public RilMessage mCurrentRilMessage = null;
    public Handler mCaller = null;
    public StateStart mStateStart = new StateStart(null);
    public StateCmdParamsReady mStateCmdParamsReady = new StateCmdParamsReady(null);

    public static synchronized RilMessageDecoder getInstance(Handler caller, IccFileHandler fh) {
        if (sInstance == null) {
            sInstance = new RilMessageDecoder(caller, fh);
            sInstance.start();
        }
        return sInstance;
    }

    public void sendStartDecodingMessageParams(RilMessage rilMsg) {
        Message msg = this.obtainMessage(1);
        msg.obj = rilMsg;
        this.sendMessage(msg);
    }

    public void sendMsgParamsDecoded(ResultCode resCode, CommandParams cmdParams) {
        Message msg = this.obtainMessage(2);
        msg.arg1 = resCode.value();
        msg.obj = cmdParams;
        this.sendMessage(msg);
    }

    public void sendCmdForExecution(RilMessage rilMsg) {
        Message msg = this.mCaller.obtainMessage(10, new RilMessage(rilMsg));
        msg.sendToTarget();
    }

    public RilMessageDecoder(Handler caller, IccFileHandler fh) {
        super("RilMessageDecoder");
        this.addState(this.mStateStart);
        this.addState(this.mStateCmdParamsReady);
        this.setInitialState(this.mStateStart);
        this.mCaller = caller;
        this.mCmdParamsFactory = CommandParamsFactory.getInstance(this, fh);
    }

    public boolean decodeMessageParams(RilMessage rilMsg) {
        boolean decodingStarted;
        this.mCurrentRilMessage = rilMsg;
        switch (rilMsg.mId) {
            case 1: 
            case 4: {
                this.mCurrentRilMessage.mResCode = ResultCode.OK;
                this.sendCmdForExecution(this.mCurrentRilMessage);
                decodingStarted = false;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                byte[] rawData = null;
                try {
                    rawData = IccUtils.hexStringToBytes((String)rilMsg.mData);
                }
                catch (Exception e) {
                    CatLog.d(this, "decodeMessageParams dropping zombie messages");
                    decodingStarted = false;
                    break;
                }
                try {
                    this.mCmdParamsFactory.make(BerTlv.decode(rawData));
                    decodingStarted = true;
                }
                catch (ResultException e) {
                    this.mCurrentRilMessage.mResCode = e.result();
                    this.sendCmdForExecution(this.mCurrentRilMessage);
                    decodingStarted = false;
                }
                break;
            }
            default: {
                decodingStarted = false;
            }
        }
        return decodingStarted;
    }

    public static class 1 {
    }

    public class StateCmdParamsReady
    extends HierarchicalState {
        public StateCmdParamsReady() {
        }

        public boolean processMessage(Message msg) {
            if (msg.what == 2) {
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mResCode = ResultCode.fromInt(msg.arg1);
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mData = msg.obj;
                RilMessageDecoder.this.sendCmdForExecution(RilMessageDecoder.this.mCurrentRilMessage);
                RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateStart);
            } else {
                CatLog.d(this, "StateCmdParamsReady expecting CMD_PARAMS_READY=2 got " + msg.what);
                RilMessageDecoder.this.deferMessage(msg);
            }
            return true;
        }

        public /* synthetic */ StateCmdParamsReady(1 x1) {
            this();
        }
    }

    public class StateStart
    extends HierarchicalState {
        public StateStart() {
        }

        public boolean processMessage(Message msg) {
            if (msg.what == 1) {
                if (RilMessageDecoder.this.decodeMessageParams((RilMessage)msg.obj)) {
                    RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateCmdParamsReady);
                }
            } else {
                CatLog.d(this, "StateStart unexpected expecting START=1 got " + msg.what);
            }
            return true;
        }

        public /* synthetic */ StateStart(1 x1) {
            this();
        }
    }
}

