/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.cdma.CDMAPhone;

public class CdmaDataConnection
extends DataConnection {
    public static final String LOG_TAG = "CDMA";
    public static final int PS_NET_DOWN_REASON_OPERATOR_DETERMINED_BARRING = 8;
    public static final int PS_NET_DOWN_REASON_AUTH_FAILED = 29;
    public static final int PS_NET_DOWN_REASON_OPTION_NOT_SUPPORTED = 32;
    public static final int PS_NET_DOWN_REASON_OPTION_UNSUBSCRIBED = 33;

    public CdmaDataConnection(CDMAPhone phone, String name, RetryManager rm) {
        super(phone, name, rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CdmaDataConnection makeDataConnection(CDMAPhone phone, int id2, RetryManager rm) {
        Object object = mCountLock;
        synchronized (object) {
        }
        CdmaDataConnection cdmaDc = new CdmaDataConnection(phone, "CdmaDataConnection-" + ++mCount, rm);
        cdmaDc.start();
        cdmaDc.log("Made " + cdmaDc.getName());
        cdmaDc.mId = id2;
        return cdmaDc;
    }

    public void onConnect(DataConnection.ConnectionParams cp) {
        int dataProfile;
        this.log("CdmaDataConnection Connecting...");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        if (cp.apn != null && cp.apn.types.length > 0 && cp.apn.types[0] != null && cp.apn.types[0].equals("dun")) {
            this.log("CdmaDataConnection using DUN");
            dataProfile = 1;
        } else {
            dataProfile = 0;
        }
        Message msg = this.obtainMessage(3, cp);
        msg.obj = cp;
        this.phone.mCM.setupDataCall(Integer.toString(0), Integer.toString(dataProfile), null, null, null, Integer.toString(3), "IP", msg);
    }

    public String toString() {
        return "State=" + this.getCurrentState().getName() + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFasilCause=" + (Object)((Object)this.lastFailCause);
    }

    public DataConnection.FailCause getFailCauseFromRequest(int rilCause) {
        DataConnection.FailCause cause;
        switch (rilCause) {
            case 8: {
                cause = DataConnection.FailCause.OPERATOR_BARRED;
                break;
            }
            case 29: {
                cause = DataConnection.FailCause.USER_AUTHENTICATION;
                break;
            }
            case 32: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
                break;
            }
            case 33: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
                break;
            }
            default: {
                cause = DataConnection.FailCause.UNKNOWN;
            }
        }
        return cause;
    }

    public boolean isDnsOk(String[] domainNameServers) {
        return !"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || ((CDMAPhone)this.phone).isDnsCheckDisabled();
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }
}

