/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.net.sip.SipAudioCall;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;

public abstract class SipConnectionBase
extends Connection {
    public static final String LOG_TAG = "SIP_CONN";
    public SipAudioCall mSipAudioCall;
    public String dialString;
    public String postDialString;
    public int nextPostDialChar;
    public boolean isIncoming;
    public long createTime;
    public long connectTime;
    public long disconnectTime;
    public long connectTimeReal;
    public long duration = -1L;
    public long holdingStartTime;
    public Connection.DisconnectCause mCause = Connection.DisconnectCause.NOT_DISCONNECTED;
    public Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;

    public SipConnectionBase(String dialString) {
        this.dialString = dialString;
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.isIncoming = false;
        this.createTime = System.currentTimeMillis();
    }

    public void setState(Call.State state) {
        switch (state) {
            case ACTIVE: {
                if (this.connectTime != 0L) break;
                this.connectTimeReal = SystemClock.elapsedRealtime();
                this.connectTime = System.currentTimeMillis();
                break;
            }
            case DISCONNECTED: {
                this.duration = this.getDurationMillis();
                this.disconnectTime = System.currentTimeMillis();
                break;
            }
            case HOLDING: {
                this.holdingStartTime = SystemClock.elapsedRealtime();
            }
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration < 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    public void setDisconnectCause(Connection.DisconnectCause cause) {
        this.mCause = cause;
    }

    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    public void proceedAfterWaitChar() {
    }

    public void proceedAfterWildChar(String str) {
    }

    public void cancelPostDial() {
    }

    public abstract Phone getPhone();

    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        return this.postDialString.substring(this.nextPostDialChar);
    }

    public void log(String msg) {
        Log.d(LOG_TAG, "[SipConn] " + msg);
    }

    public int getNumberPresentation() {
        return Connection.PRESENTATION_ALLOWED;
    }

    public UUSInfo getUUSInfo() {
        return null;
    }
}

