/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.MenuView;
import java.util.ArrayList;

public class ActionMenuView
extends LinearLayout
implements MenuBuilder.ItemInvoker,
MenuView {
    public static final String TAG = "ActionMenuView";
    public static final int DIVIDER_PADDING = 12;
    public MenuBuilder mMenu;
    public int mMaxItems;
    public int mWidthLimit;
    public boolean mReserveOverflow;
    public OverflowMenuButton mOverflowButton;
    public MenuPopupHelper mOverflowPopup;
    public float mDividerPadding;
    public Drawable mDivider;
    public final Runnable mShowOverflow = new Runnable(){

        public void run() {
            ActionMenuView.this.showOverflowMenu();
        }
    };
    public OpenOverflowRunnable mPostedOpenRunnable;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = this.getResources();
        this.mMaxItems = this.getMaxActionButtons();
        int screen = res.getConfiguration().screenLayout;
        this.mReserveOverflow = (screen & 0xF) == 4;
        this.mWidthLimit = res.getDisplayMetrics().widthPixels / 2;
        TypedArray a = context.obtainStyledAttributes(R.styleable.Theme);
        this.mDivider = a.getDrawable(156);
        a.recycle();
        this.mDividerPadding = 12.0f * res.getDisplayMetrics().density;
        this.setBaselineAligned(false);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int screen = newConfig.screenLayout;
        this.mReserveOverflow = (screen & 0xF) == 4;
        this.mMaxItems = this.getMaxActionButtons();
        this.mWidthLimit = this.getResources().getDisplayMetrics().widthPixels / 2;
        if (this.mMenu != null) {
            this.mMenu.setMaxActionItems(this.mMaxItems);
            this.updateChildren(false);
        }
        if (this.mOverflowPopup != null && this.mOverflowPopup.isShowing()) {
            this.mOverflowPopup.dismiss();
            this.post(this.mShowOverflow);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mOverflowPopup != null && this.mOverflowPopup.isShowing()) {
            this.mOverflowPopup.dismiss();
        }
        this.removeCallbacks(this.mShowOverflow);
        if (this.mPostedOpenRunnable != null) {
            this.removeCallbacks(this.mPostedOpenRunnable);
        }
    }

    public int getMaxActionButtons() {
        return this.getResources().getInteger(17694758);
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    public void setOverflowReserved(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
    }

    public View getOverflowButton() {
        return this.mOverflowButton;
    }

    public LinearLayout.LayoutParams generateDefaultLayoutParams() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 16;
        return params;
    }

    public LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams result = new LinearLayout.LayoutParams((LinearLayout.LayoutParams)p);
            if (result.gravity <= 0) {
                result.gravity = 16;
            }
            return result;
        }
        return this.generateDefaultLayoutParams();
    }

    public boolean invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction(item, 0);
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void initialize(MenuBuilder menu2, int menuType) {
        int width = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                OverflowMenuButton button;
                this.mOverflowButton = button = new OverflowMenuButton(this.mContext);
            }
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.mOverflowButton.measure(spec, spec);
            width -= this.mOverflowButton.getMeasuredWidth();
        }
        menu2.setActionWidthLimit(width);
        menu2.setMaxActionItems(this.mMaxItems);
        this.mMenu = menu2;
        this.updateChildren(true);
    }

    public void updateChildren(boolean cleared) {
        boolean reserveOverflow = this.mReserveOverflow;
        this.removeAllViews();
        ArrayList<MenuItemImpl> itemsToShow = this.mMenu.getActionItems(reserveOverflow);
        int itemCount = itemsToShow.size();
        boolean needsDivider = false;
        for (int i = 0; i < itemCount; ++i) {
            View actionView;
            MenuItemImpl itemData = itemsToShow.get(i);
            boolean hasDivider = false;
            if (needsDivider) {
                this.addView((View)this.makeDividerView(), this.makeDividerLayoutParams());
                hasDivider = true;
            }
            if ((actionView = itemData.getActionView()) != null) {
                ViewParent parent = actionView.getParent();
                if (parent instanceof ViewGroup) {
                    ((ViewGroup)parent).removeView(actionView);
                }
                this.addView(actionView, this.makeActionViewLayoutParams(actionView));
                continue;
            }
            ActionMenuItemView view = (ActionMenuItemView)itemData.getItemView(3, this);
            view.setItemInvoker(this);
            if (i > 0 && !hasDivider && view.hasText() && itemData.getIcon() == null) {
                this.addView((View)this.makeDividerView(), this.makeDividerLayoutParams());
            }
            this.addView(view);
            needsDivider = view.hasText();
        }
        if (reserveOverflow) {
            if (this.mMenu.getNonActionItems(true).size() > 0) {
                if (itemCount > 0) {
                    this.addView((View)this.makeDividerView(), this.makeDividerLayoutParams());
                }
                if (this.mOverflowButton == null) {
                    OverflowMenuButton button;
                    this.mOverflowButton = button = new OverflowMenuButton(this.mContext);
                }
                this.addView(this.mOverflowButton);
            } else {
                this.mOverflowButton = null;
            }
        }
    }

    public boolean showOverflowMenu() {
        if (this.mOverflowButton != null && !this.isOverflowMenuShowing()) {
            this.mMenu.getCallback().onMenuModeChange(this.mMenu);
            return true;
        }
        return false;
    }

    public void openOverflowMenu() {
        OverflowPopup popup = new OverflowPopup(this.getContext(), this.mMenu, this.mOverflowButton, true);
        this.mPostedOpenRunnable = new OpenOverflowRunnable(popup);
        this.post(this.mPostedOpenRunnable);
    }

    public boolean isOverflowMenuShowing() {
        return this.mOverflowPopup != null && this.mOverflowPopup.isShowing();
    }

    public boolean isOverflowMenuOpen() {
        return this.mOverflowPopup != null;
    }

    public boolean hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null) {
            this.removeCallbacks(this.mPostedOpenRunnable);
            return true;
        }
        MenuPopupHelper popup = this.mOverflowPopup;
        if (popup != null) {
            popup.dismiss();
            return true;
        }
        return false;
    }

    public boolean addItemView(boolean needsDivider, ActionMenuItemView view) {
        view.setItemInvoker(this);
        boolean hasText = view.hasText();
        if (hasText && needsDivider) {
            this.addView((View)this.makeDividerView(), this.makeDividerLayoutParams());
        }
        this.addView(view);
        return hasText;
    }

    public ImageView makeDividerView() {
        ImageView result = new ImageView(this.mContext);
        result.setImageDrawable(this.mDivider);
        result.setScaleType(ImageView.ScaleType.FIT_XY);
        return result;
    }

    public LinearLayout.LayoutParams makeDividerLayoutParams() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        params.topMargin = (int)this.mDividerPadding;
        params.bottomMargin = (int)this.mDividerPadding;
        return params;
    }

    public LinearLayout.LayoutParams makeActionViewLayoutParams(View view) {
        return this.generateLayoutParams(view.getLayoutParams());
    }

    public class OverflowPopup
    extends MenuPopupHelper {
        public OverflowPopup(Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly) {
            super(context, menu2, anchorView, overflowOnly);
        }

        public void onDismiss() {
            super.onDismiss();
            ActionMenuView.this.mMenu.getCallback().onCloseMenu(ActionMenuView.this.mMenu, true);
            ActionMenuView.this.mOverflowPopup = null;
        }
    }

    public class OverflowMenuButton
    extends ImageButton {
        public OverflowMenuButton(Context context) {
            super(context, null, 16843510);
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
        }

        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            ActionMenuView.this.showOverflowMenu();
            return true;
        }
    }

    public class OpenOverflowRunnable
    implements Runnable {
        public MenuPopupHelper mPopup;

        public OpenOverflowRunnable(MenuPopupHelper popup) {
            this.mPopup = popup;
        }

        public void run() {
            if (this.mPopup.tryShow()) {
                ActionMenuView.this.mOverflowPopup = this.mPopup;
                ActionMenuView.this.mPostedOpenRunnable = null;
            }
        }
    }
}

