/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.content.res.XmlResourceParser;
import android.util.XmlPullAttributes;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlPullAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BridgeXmlBlockParser
implements XmlResourceParser {
    private final XmlPullParser mParser;
    private final XmlPullAttributes mAttrib;
    private final BridgeContext mContext;
    private final boolean mPlatformFile;
    private boolean mStarted = false;
    private int mEventType = 0;
    private boolean mPopped = true;

    public BridgeXmlBlockParser(XmlPullParser xmlPullParser, BridgeContext bridgeContext, boolean bl) {
        this.mParser = xmlPullParser;
        this.mContext = bridgeContext;
        this.mPlatformFile = bl;
        this.mAttrib = new BridgeXmlPullAttributes(xmlPullParser, bridgeContext, this.mPlatformFile);
        if (this.mContext != null) {
            this.mContext.pushParser(this);
            this.mPopped = false;
        }
    }

    public XmlPullParser getParser() {
        return this.mParser;
    }

    public boolean isPlatformFile() {
        return this.mPlatformFile;
    }

    public Object getViewCookie() {
        if (this.mParser instanceof ILayoutPullParser) {
            return ((ILayoutPullParser)this.mParser).getViewCookie();
        }
        return null;
    }

    public void ensurePopped() {
        if (this.mContext != null && !this.mPopped) {
            this.mContext.popParser();
            this.mPopped = true;
        }
    }

    public void setFeature(String string2, boolean bl) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2) && bl) {
            return;
        }
        if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2) && bl) {
            return;
        }
        throw new XmlPullParserException("Unsupported feature: " + string2);
    }

    public boolean getFeature(String string2) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2)) {
            return true;
        }
        return "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2);
    }

    public void setProperty(String string2, Object object) throws XmlPullParserException {
        throw new XmlPullParserException("setProperty() not supported");
    }

    public Object getProperty(String string2) {
        return null;
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.mParser.setInput(reader);
    }

    public void setInput(InputStream inputStream, String string2) throws XmlPullParserException {
        this.mParser.setInput(inputStream, string2);
    }

    public void defineEntityReplacementText(String string2, String string3) throws XmlPullParserException {
        throw new XmlPullParserException("defineEntityReplacementText() not supported");
    }

    public String getNamespacePrefix(int n) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespacePrefix() not supported");
    }

    public String getInputEncoding() {
        return null;
    }

    public String getNamespace(String string2) {
        throw new RuntimeException("getNamespace() not supported");
    }

    public int getNamespaceCount(int n) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceCount() not supported");
    }

    public String getPositionDescription() {
        return "Binary XML file line #" + this.getLineNumber();
    }

    public String getNamespaceUri(int n) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceUri() not supported");
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getDepth() {
        return this.mParser.getDepth();
    }

    public String getText() {
        return this.mParser.getText();
    }

    public int getLineNumber() {
        return this.mParser.getLineNumber();
    }

    public int getEventType() {
        return this.mEventType;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.mParser.isWhitespace();
    }

    public String getPrefix() {
        throw new RuntimeException("getPrefix not supported");
    }

    public char[] getTextCharacters(int[] nArray) {
        String string2 = this.getText();
        char[] cArray = null;
        if (string2 != null) {
            nArray[0] = 0;
            nArray[1] = string2.length();
            cArray = new char[string2.length()];
            string2.getChars(0, string2.length(), cArray, 0);
        }
        return cArray;
    }

    public String getNamespace() {
        return this.mParser.getNamespace();
    }

    public String getName() {
        return this.mParser.getName();
    }

    public String getAttributeNamespace(int n) {
        return this.mParser.getAttributeNamespace(n);
    }

    public String getAttributeName(int n) {
        return this.mParser.getAttributeName(n);
    }

    public String getAttributePrefix(int n) {
        throw new RuntimeException("getAttributePrefix not supported");
    }

    public boolean isEmptyElementTag() {
        return false;
    }

    public int getAttributeCount() {
        return this.mParser.getAttributeCount();
    }

    public String getAttributeValue(int n) {
        return this.mParser.getAttributeValue(n);
    }

    public String getAttributeType(int n) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int n) {
        return false;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public String getAttributeValue(String string2, String string3) {
        return this.mParser.getAttributeValue(string2, string3);
    }

    public int next() throws XmlPullParserException, IOException {
        if (!this.mStarted) {
            this.mStarted = true;
            return 0;
        }
        int n = this.mParser.next();
        if (n == 3 && this.mParser.getDepth() == 1) {
            this.ensurePopped();
        }
        this.mEventType = n;
        return n;
    }

    public static String eventTypeToString(int n) {
        switch (n) {
            case 0: {
                return "START_DOC";
            }
            case 1: {
                return "END_DOC";
            }
            case 2: {
                return "START_TAG";
            }
            case 3: {
                return "END_TAG";
            }
            case 4: {
                return "TEXT";
            }
            case 5: {
                return "CDSECT";
            }
            case 6: {
                return "ENTITY_REF";
            }
            case 7: {
                return "IGNORABLE_WHITESPACE";
            }
            case 8: {
                return "PROCESSING_INSTRUCTION";
            }
            case 9: {
                return "COMMENT";
            }
            case 10: {
                return "DOCDECL";
            }
        }
        return "????";
    }

    public void require(int n, String string2, String string3) throws XmlPullParserException {
        if (n != this.getEventType() || string2 != null && !string2.equals(this.getNamespace()) || string3 != null && !string3.equals(this.getName())) {
            throw new XmlPullParserException("expected " + TYPES[n] + this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", this, null);
        }
        int n = this.next();
        if (n == 4) {
            String string2 = this.getText();
            n = this.next();
            if (n != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", this, null);
            }
            return string2;
        }
        if (n == 3) {
            return "";
        }
        throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int n = this.next();
        if (n == 4 && this.isWhitespace()) {
            n = this.next();
        }
        if (n != 2 && n != 3) {
            throw new XmlPullParserException(this.getPositionDescription() + ": expected start or end tag", this, null);
        }
        return n;
    }

    public void close() {
    }

    public boolean getAttributeBooleanValue(int n, boolean bl) {
        return this.mAttrib.getAttributeBooleanValue(n, bl);
    }

    public boolean getAttributeBooleanValue(String string2, String string3, boolean bl) {
        return this.mAttrib.getAttributeBooleanValue(string2, string3, bl);
    }

    public float getAttributeFloatValue(int n, float f) {
        return this.mAttrib.getAttributeFloatValue(n, f);
    }

    public float getAttributeFloatValue(String string2, String string3, float f) {
        return this.mAttrib.getAttributeFloatValue(string2, string3, f);
    }

    public int getAttributeIntValue(int n, int n2) {
        return this.mAttrib.getAttributeIntValue(n, n2);
    }

    public int getAttributeIntValue(String string2, String string3, int n) {
        return this.mAttrib.getAttributeIntValue(string2, string3, n);
    }

    public int getAttributeListValue(int n, String[] stringArray, int n2) {
        return this.mAttrib.getAttributeListValue(n, stringArray, n2);
    }

    public int getAttributeListValue(String string2, String string3, String[] stringArray, int n) {
        return this.mAttrib.getAttributeListValue(string2, string3, stringArray, n);
    }

    public int getAttributeNameResource(int n) {
        return this.mAttrib.getAttributeNameResource(n);
    }

    public int getAttributeResourceValue(int n, int n2) {
        return this.mAttrib.getAttributeResourceValue(n, n2);
    }

    public int getAttributeResourceValue(String string2, String string3, int n) {
        return this.mAttrib.getAttributeResourceValue(string2, string3, n);
    }

    public int getAttributeUnsignedIntValue(int n, int n2) {
        return this.mAttrib.getAttributeUnsignedIntValue(n, n2);
    }

    public int getAttributeUnsignedIntValue(String string2, String string3, int n) {
        return this.mAttrib.getAttributeUnsignedIntValue(string2, string3, n);
    }

    public String getClassAttribute() {
        return this.mAttrib.getClassAttribute();
    }

    public String getIdAttribute() {
        return this.mAttrib.getIdAttribute();
    }

    public int getIdAttributeResourceValue(int n) {
        return this.mAttrib.getIdAttributeResourceValue(n);
    }

    public int getStyleAttribute() {
        return this.mAttrib.getStyleAttribute();
    }
}

