/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontLoader {
    private static final String FONTS_DEFINITIONS = "fonts.xml";
    private static final String NODE_FONTS = "fonts";
    private static final String NODE_FONT = "font";
    private static final String NODE_NAME = "name";
    private static final String NODE_FALLBACK = "fallback";
    private static final String ATTR_TTF = "ttf";
    private static final String FONT_EXT = ".ttf";
    private static final String[] FONT_STYLE_DEFAULT = new String[]{"", "-Regular"};
    private static final String[] FONT_STYLE_BOLD = new String[]{"-Bold"};
    private static final String[] FONT_STYLE_ITALIC = new String[]{"-Italic"};
    private static final String[] FONT_STYLE_BOLDITALIC = new String[]{"-BoldItalic"};
    private static final String[][] FONT_STYLES = new String[][]{FONT_STYLE_DEFAULT, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
    private final Map<String, String> mFamilyToTtf = new HashMap<String, String>();
    private final Map<String, Map<Integer, Font>> mTtfToFontMap = new HashMap<String, Map<Integer, Font>>();
    private List<Font> mFallBackFonts = null;

    public static FontLoader create(String string2) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            File file = new File(string2 + File.separator + FONTS_DEFINITIONS);
            FontDefinitionParser fontDefinitionParser = new FontDefinitionParser(string2 + File.separator);
            sAXParser.parse((InputStream)new FileInputStream(file), (DefaultHandler)fontDefinitionParser);
            return fontDefinitionParser.getFontLoader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private FontLoader(List<FontInfo> list, List<String> list2) {
        for (FontInfo object : list) {
            for (String string2 : object.families) {
                this.mFamilyToTtf.put(string2, object.ttf);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (String string3 : list2) {
            File file = new File(string3 + FONT_EXT);
            if (!file.isFile()) continue;
            try {
                Font font = Font.createFont(0, file);
                if (font == null) continue;
                arrayList.add(font);
            }
            catch (FontFormatException fontFormatException) {
            }
            catch (IOException iOException) {}
        }
        this.mFallBackFonts = Collections.unmodifiableList(arrayList);
    }

    public List<Font> getFallBackFonts() {
        return this.mFallBackFonts;
    }

    public synchronized Font getFont(String string2, int[] nArray) {
        Font font;
        if (string2 == null) {
            return null;
        }
        String string3 = this.mFamilyToTtf.get(string2);
        if (string3 == null) {
            return null;
        }
        Map<Integer, Font> map = this.mTtfToFontMap.get(string3);
        if (map == null) {
            map = new HashMap<Integer, Font>();
            this.mTtfToFontMap.put(string3, map);
        }
        if ((font = map.get(nArray[0])) != null) {
            return font;
        }
        switch (nArray[0]) {
            case 0: {
                font = this.getFont(string3, FONT_STYLES[0]);
                break;
            }
            case 1: 
            case 2: {
                font = this.getFont(string3, FONT_STYLES[nArray[0]]);
                if (font != null) break;
                font = this.getFont(string3, FONT_STYLES[0]);
                nArray[0] = 0;
                break;
            }
            case 3: {
                font = this.getFont(string3, FONT_STYLES[nArray[0]]);
                if (font != null) break;
                font = this.getFont(string3, FONT_STYLES[1]);
                if (font != null) {
                    nArray[0] = 1;
                    break;
                }
                font = this.getFont(string3, FONT_STYLES[2]);
                if (font != null) {
                    nArray[0] = 2;
                    break;
                }
                font = this.getFont(string3, FONT_STYLES[0]);
                nArray[0] = 0;
            }
        }
        if (font != null) {
            map.put(nArray[0], font);
            return font;
        }
        return null;
    }

    private Font getFont(String string2, String[] stringArray) {
        for (String string3 : stringArray) {
            String string4 = string2 + string3 + FONT_EXT;
            File file = new File(string4);
            if (!file.isFile()) continue;
            try {
                Font font = Font.createFont(0, file);
                if (font == null) continue;
                return font;
            }
            catch (FontFormatException fontFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class FontDefinitionParser
    extends DefaultHandler {
        private final String mOsFontsLocation;
        private FontInfo mFontInfo = null;
        private final StringBuilder mBuilder = new StringBuilder();
        private List<FontInfo> mFontList;
        private List<String> mFallBackList;

        private FontDefinitionParser(String string2) {
            this.mOsFontsLocation = string2;
        }

        FontLoader getFontLoader() {
            return new FontLoader(this.mFontList, this.mFallBackList);
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            String string5;
            if (FontLoader.NODE_FONTS.equals(string3)) {
                this.mFontList = new ArrayList<FontInfo>();
                this.mFallBackList = new ArrayList<String>();
            } else if (FontLoader.NODE_FONT.equals(string3)) {
                String string6;
                if (this.mFontList != null && (string6 = attributes.getValue(FontLoader.ATTR_TTF)) != null) {
                    this.mFontInfo = new FontInfo();
                    this.mFontInfo.ttf = this.mOsFontsLocation + string6;
                    this.mFontList.add(this.mFontInfo);
                }
            } else if (!FontLoader.NODE_NAME.equals(string3) && FontLoader.NODE_FALLBACK.equals(string3) && this.mFallBackList != null && (string5 = attributes.getValue(FontLoader.ATTR_TTF)) != null) {
                this.mFallBackList.add(this.mOsFontsLocation + string5);
            }
            this.mBuilder.setLength(0);
            super.startElement(string2, string3, string4, attributes);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mBuilder.append(cArray, n, n2);
        }

        public void endElement(String string2, String string3, String string4) throws SAXException {
            if (!FontLoader.NODE_FONTS.equals(string3)) {
                if (FontLoader.NODE_FONT.equals(string3)) {
                    this.mFontInfo = null;
                } else if (FontLoader.NODE_NAME.equals(string3)) {
                    if (this.mFontInfo != null) {
                        String string5 = this.trimXmlWhitespaces(this.mBuilder.toString());
                        this.mFontInfo.families.add(string5);
                    }
                } else if (FontLoader.NODE_FALLBACK.equals(string3)) {
                    // empty if block
                }
            }
        }

        private String trimXmlWhitespaces(String string2) {
            int n;
            int n2;
            int n3;
            if (string2 == null) {
                return null;
            }
            while ((n3 = string2.indexOf(10)) != -1) {
                int n4;
                for (n2 = n3 - 1; n2 >= 0 && Character.isWhitespace(string2.charAt(n2)); --n2) {
                }
                n = string2.length();
                for (n4 = n3 + 1; n4 < n && Character.isWhitespace(string2.charAt(n4)); ++n4) {
                }
                String string3 = null;
                if (n2 >= 0) {
                    string3 = string2.substring(0, n2 + 1);
                }
                String string4 = null;
                if (n4 < n) {
                    string4 = string2.substring(n4);
                }
                if (string3 != null) {
                    string2 = string3;
                    if (string4 == null) continue;
                    string2 = string2 + " " + string4;
                    continue;
                }
                string2 = string4 != null ? string4 : "";
            }
            n2 = string2.length();
            char[] cArray = string2.toCharArray();
            for (n = 0; n < n2; ++n) {
                if (cArray[n] != '\\') continue;
                if (cArray[n + 1] == 'n') {
                    cArray[n + 1] = 10;
                }
                System.arraycopy(cArray, n + 1, cArray, n, n2 - n - 1);
                --n2;
            }
            return new String(cArray, 0, n2);
        }
    }

    private static final class FontInfo {
        String ttf;
        final Set<String> families = new HashSet<String>();

        FontInfo() {
        }
    }
}

